/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.DatabaseLink;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.engine.BaseDatabase;
import org.axiondb.engine.DiskTableFactory;
import org.axiondb.engine.commands.AlterTableCommand;
import org.axiondb.engine.tables.BaseDiskTable;
import org.axiondb.engine.tables.MemoryTable;
import org.axiondb.engine.tables.TableViewFactory;
import org.axiondb.io.FileUtil;

public class DiskDatabase
extends BaseDatabase {
    private static final TableFactory DEFAULT_TABLE_FACTORY = new DiskTableFactory();
    private static final String IGNORE_LOCK_FILE_PROPERTY_NAME = "org.axiondb.engine.DiskDatabase.IGNORE_LOCK_FILE";
    private static final String LOCK_FILE_NAME = "lockfile.txt";
    private File _dbDir = null;
    private boolean _ignoreLockFile = false;
    private static final int DB_MAJOR_VERSION = 0;
    private static final int DB_MINOR_VERSION = 3;
    private static final int DB_INTERNAL_MINOR_VERSION = 1;
    private static final int AXION_DB_VERSION = 131;
    private int _dbVersion = -1;
    private static Logger _log = Logger.getLogger(DiskDatabase.class.getName());
    private static final String DATABASE_LOCKFILE_IGNORE_PROPERTY_NAME = "database.lockfile.ignore";

    public DiskDatabase(File dbDir) throws AxionException {
        this(dbDir.getName(), dbDir);
    }

    public DiskDatabase(String name, File dbDir) throws AxionException {
        this(name, dbDir, null);
    }

    public DiskDatabase(String name, File dbDir, Properties props) throws AxionException {
        super(name);
        if (null == dbDir) {
            throw new AxionException("Database directory required.");
        }
        this._dbDir = dbDir;
        _log.log(Level.FINE, "Constructing disk-based database in " + dbDir);
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            throw new AxionException("Database directory \"" + dbDir + "\" could not be created or is not a directory.");
        }
        props = this.loadProperties(dbDir, props);
        this.obtainLockFile(props);
        this.obtainDBVersion();
        this.migrate(this._dbVersion);
        this.createMetaDataTables();
        this.loadProperties(props);
        this.loadDBLinks();
        this.loadTables(this._dbDir);
        this.loadSequences();
        if (!this.isReadOnly()) {
            this.writeDbVersion();
        }
        _log.log(Level.FINE, "Disk-based database construction successful");
    }

    private void writeDbVersion() throws AxionException {
        File verFile = this.getDbFileName(".VER");
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(verFile));
            out.writeInt(131);
            out.flush();
            this.closeOutputStream(out);
        }
        catch (IOException e) {
            try {
                String msg = "Unable to persist version file";
                _log.log(Level.SEVERE, msg, e);
                throw new AxionException(msg);
            }
            catch (Throwable throwable) {
                this.closeOutputStream(out);
                throw throwable;
            }
        }
    }

    protected File getDbFileName(String extension) {
        return new File(this._dbDir, this.getName().toUpperCase() + extension);
    }

    public void checkpoint() throws AxionException {
        super.checkpoint();
        if (this.getSequenceCount() != 0) {
            File seqFile = this.getDbFileName(".SEQ");
            DataOutputStream out = null;
            try {
                out = new DataOutputStream(new FileOutputStream(seqFile));
                out.writeInt(this.getSequenceCount());
                Iterator i = this.getSequences();
                while (i.hasNext()) {
                    Sequence cur = (Sequence)i.next();
                    cur.write(out);
                }
                out.flush();
                this.closeOutputStream(out);
            }
            catch (IOException e) {
                try {
                    String msg = "Unable to persist sequence file";
                    _log.log(Level.SEVERE, msg, e);
                    throw new AxionException(msg);
                }
                catch (Throwable throwable) {
                    this.closeOutputStream(out);
                    throw throwable;
                }
            }
        }
    }

    private void closeOutputStream(DataOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void createSequence(Sequence seq) throws AxionException {
        super.createSequence(seq);
        this.checkpoint();
    }

    public void defrag() throws AxionException {
        this.checkpoint();
        Iterator i = this.getTables();
        ArrayList<String> tablesToDefrag = new ArrayList<String>();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!(table instanceof BaseDiskTable)) continue;
            tablesToDefrag.add(table.getName());
        }
        Iterator t = tablesToDefrag.iterator();
        while (t.hasNext()) {
            this.defragTable((String)t.next());
        }
    }

    public int defragTable(String tableName) throws AxionException {
        try {
            AlterTableCommand alterTableCmd = new AlterTableCommand(tableName, false);
            return alterTableCmd.executeUpdate(this);
        }
        catch (AxionException e) {
            throw new AxionException("Unable to defrag table " + tableName, e);
        }
    }

    public File getDBDirectory() {
        return this._dbDir;
    }

    public TableFactory getTableFactory(String name) {
        if (null == name || "default".equals(name)) {
            return DEFAULT_TABLE_FACTORY;
        }
        return super.getTableFactory(name);
    }

    public void migrate(int version) throws AxionException {
        if (version != -1 && version < 131) {
            try {
                FileUtil.renameToUpperCase(this.getDBDirectory());
                this._dbVersion = 131;
                this.writeDbVersion();
            }
            catch (IOException e) {
                throw new AxionException(e);
            }
        }
    }

    public void remount(File newdir) throws AxionException {
        _log.log(Level.FINE, "Remounting from " + this._dbDir + " to " + newdir);
        this._dbDir = newdir;
        super.remount(newdir);
    }

    public void shutdown() throws AxionException {
        super.shutdown();
        this.releaseLockFile();
    }

    protected Table createSystemTable(String name) {
        return new MemoryTable(name, "SYSTEM TABLE");
    }

    public void createDatabaseLink(DatabaseLink dblink) throws AxionException {
        try {
            this.persistDBLink(dblink);
        }
        catch (IOException ex) {
            throw new AxionException(ex);
        }
        super.createDatabaseLink(dblink);
    }

    public void dropDatabaseLink(String name) throws AxionException {
        File dblink = new File(this.getDBDirectory().getAbsolutePath() + File.separator + "DBLINK", name + ".link");
        if (dblink.exists()) {
            dblink.delete();
        }
        super.dropDatabaseLink(name);
    }

    private void persistDBLink(DatabaseLink dblink) throws IOException {
        File dblinkFile;
        File links = new File(this.getDBDirectory().getAbsolutePath(), "DBLINK");
        if (!links.exists()) {
            links.mkdir();
        }
        if ((dblinkFile = new File(links.getAbsolutePath(), dblink.getName() + ".link")).exists()) {
            dblinkFile.delete();
        }
        dblinkFile.createNewFile();
        FileOutputStream out = new FileOutputStream(dblinkFile);
        dblink.getProperties().store(out, "DBLink info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File dbDir, Properties props) {
        if (null == props) {
            props = null != DiskDatabase.getBaseProperties() ? new Properties(DiskDatabase.getBaseProperties()) : new Properties();
            File propfile = new File(dbDir, "axiondb.properties");
            if (propfile.exists()) {
                _log.log(Level.FINE, "Loading properties from \"" + propfile + "\".");
                FileInputStream in = null;
                try {
                    in = new FileInputStream(propfile);
                    props.load(in);
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "Exception while loading properties from \"" + propfile + "\".", e);
                }
                finally {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return props;
    }

    private void obtainDBVersion() throws AxionException {
        File verFile = this.getDbFileName(".VER");
        if (!verFile.exists()) {
            verFile = new File(this._dbDir, this.getName() + ".ver");
        }
        if (verFile.exists()) {
            DataInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(verFile));
                this._dbVersion = in.readInt();
                this.closeInputStream(in);
            }
            catch (IOException e) {
                try {
                    String msg = "Unable to read db version file";
                    _log.log(Level.SEVERE, msg, e);
                    throw new AxionException(msg);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(in);
                    throw throwable;
                }
            }
        }
    }

    private void closeInputStream(DataInputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadSequences() throws AxionException {
        File seqFile = this.getDbFileName(".SEQ");
        if (seqFile.exists()) {
            DataInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(seqFile));
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Sequence seq;
                    if (this._dbVersion > 102) {
                        seq = new Sequence();
                        seq.read(in);
                    } else {
                        String name = in.readUTF();
                        int value = in.readInt();
                        seq = new Sequence(name, value);
                    }
                    super.createSequence(seq);
                }
                this.closeInputStream(in);
            }
            catch (Exception e) {
                try {
                    String msg = "Unable to read sequence file";
                    _log.log(Level.SEVERE, msg, e);
                    throw new AxionException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(in);
                    throw throwable;
                }
            }
        }
    }

    private void loadTables(File parentdir) throws AxionException {
        String[] tables = parentdir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File idx;
                File file = new File(dir, name);
                return file.isDirectory() && (idx = new File(file, name + ".TYPE")).exists();
            }
        });
        ArrayList<String> views = new ArrayList<String>();
        for (int i = 0; i < tables.length; ++i) {
            _log.log(Level.FINE, "Recreating table " + tables[i]);
            File tabledir = new File(parentdir, tables[i]);
            File typefile = new File(tabledir, tables[i] + ".TYPE");
            String factoryname = null;
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(typefile)));
                factoryname = in.readUTF();
            }
            catch (IOException e) {
                throw new AxionException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            TableFactory factory = null;
            try {
                Class<?> clazz = Class.forName(factoryname);
                factory = (TableFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
            if (factory instanceof TableViewFactory) {
                views.add(tabledir.getName());
                continue;
            }
            Table table = factory.createTable(this, tabledir.getName());
            this.addTable(table);
        }
        Iterator itr = views.iterator();
        TableViewFactory factory = new TableViewFactory();
        while (itr.hasNext()) {
            Table table = factory.createTable(this, (String)itr.next());
            this.addTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainLockFile(Properties props) throws AxionException {
        String lockFileIgnoreProp = System.getProperty(IGNORE_LOCK_FILE_PROPERTY_NAME);
        this._ignoreLockFile = lockFileIgnoreProp == null ? Boolean.valueOf(props.getProperty(DATABASE_LOCKFILE_IGNORE_PROPERTY_NAME)).booleanValue() : Boolean.valueOf(lockFileIgnoreProp).booleanValue();
        if (this.isReadOnly()) {
            this._ignoreLockFile = true;
        }
        if (!this._ignoreLockFile) {
            File lock = new File(this._dbDir, LOCK_FILE_NAME);
            if (lock.exists()) {
                throw new AxionException("The database directory at " + this._dbDir.getAbsolutePath() + " appears to already be in use by another process. " + " If you feel you have reached this message in error, " + "delete the file at " + lock.getAbsolutePath() + ".", 8002);
            }
            lock.deleteOnExit();
            FileWriter out = null;
            try {
                out = new FileWriter(lock);
                out.write("lock");
                out.write("\t");
                out.write(this.getName());
                out.write("\t");
                out.write(String.valueOf(System.currentTimeMillis()));
                out.flush();
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Unable to create lock file at " + lock.getAbsolutePath() + " due to exception.", e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void releaseLockFile() {
        File lock;
        if (!this._ignoreLockFile && (lock = new File(this._dbDir, LOCK_FILE_NAME)).exists() && !lock.delete()) {
            _log.log(Level.WARNING, "Unable to delete lock file at " + lock.getAbsolutePath() + " due to exception.");
        }
    }

    private void loadDBLinks() throws AxionException {
        try {
            File dblinks = new File(this.getDBDirectory().getAbsolutePath(), "DBLINK");
            if (dblinks.exists()) {
                File[] files;
                for (File file : files = dblinks.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".link");
                    }
                })) {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(file));
                    DatabaseLink dblink = new DatabaseLink(file.getName().substring(0, file.getName().indexOf(".")), prop);
                    this.createDatabaseLink(dblink);
                }
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }
}

