/*
 * Decompiled with CFR 0.152.
 */
package com.sun.axiondb.functions;

import com.sun.sbme.api.SbmeStandRecord;
import com.sun.sbme.api.SbmeStandRecordFactory;
import com.sun.sbme.api.SbmeStandardizationEngine;
import com.sun.sbmeapi.StandConfigFilesAccess;
import com.sun.sbmeapi.impl.StandConfigFilesAccessImpl;
import org.axiondb.AxionException;

public class EViewFunctionUtil {
    private SbmeStandardizationEngine _sbme = new SbmeStandardizationEngine((StandConfigFilesAccess)new StandConfigFilesAccessImpl());
    private static EViewFunctionUtil _instance;

    private EViewFunctionUtil() throws Exception {
    }

    public static EViewFunctionUtil getInstance() {
        return _instance;
    }

    public synchronized SbmeStandRecord standardize(String stdType, String addressColumn, String locale) throws AxionException {
        if (this.isNull(stdType)) {
            throw new AxionException("Standardization type 'Null' not allowed");
        }
        try {
            if (this.isNull(locale)) {
                locale = "US";
            }
            return this._sbme.standardize(stdType, addressColumn, locale)[0];
        }
        catch (Exception e) {
            throw new AxionException("While applying Standardization", e);
        }
    }

    private boolean isNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public SbmeStandRecord normalize(String normalizeType, String normalizeConst, String normalizable, String locale) throws AxionException {
        if (this.isNull(normalizeType)) {
            throw new AxionException("Normalization type 'Null' not allowed");
        }
        try {
            SbmeStandRecord normalizableObj = SbmeStandRecordFactory.getInstance((String)normalizeType);
            normalizableObj.setValue(normalizeConst, normalizable);
            if (this.isNull(locale)) {
                locale = "US";
            }
            return this._sbme.normalize(normalizableObj, locale);
        }
        catch (Exception e) {
            throw new AxionException("While applying Normalization", e);
        }
    }

    static {
        try {
            _instance = new EViewFunctionUtil();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

