/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.beanutils.ConversionException;

class HeaderInfo {
    private String[] mHeaderLines;

    HeaderInfo() {
    }

    final String[] getHeaderLines() {
        return this.mHeaderLines;
    }

    final void setHeaderFile(String aFileName) throws ConversionException {
        if (aFileName == null || aFileName.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        FileReader headerReader = null;
        try {
            headerReader = new FileReader(aFileName);
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header file " + aFileName, (Throwable)ex);
        }
        finally {
            if (headerReader != null) {
                try {
                    ((Reader)headerReader).close();
                }
                catch (IOException ex) {
                    throw new ConversionException("unable to close header file " + aFileName, (Throwable)ex);
                }
            }
        }
    }

    final void setHeader(String aHeader) {
        if (aHeader == null || aHeader.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        String headerExpandedNewLines = aHeader.replaceAll("\\\\n", "\n");
        StringReader headerReader = new StringReader(headerExpandedNewLines);
        try {
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header", (Throwable)ex);
        }
        finally {
            try {
                ((Reader)headerReader).close();
            }
            catch (IOException ex) {
                throw new ConversionException("unable to close header", (Throwable)ex);
            }
        }
    }

    private void checkHeaderNotInitialized() {
        if (this.mHeaderLines != null) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    private void loadHeader(Reader aHeaderReader) throws IOException {
        String l;
        LineNumberReader lnr = new LineNumberReader(aHeaderReader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = lnr.readLine()) != null) {
            lines.add(l);
        }
        this.mHeaderLines = lines.toArray(new String[lines.size()]);
        this.postprocessHeaderLines();
    }

    protected void postprocessHeaderLines() {
    }
}

