/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.PaintElement;
import org.w3c.dom.DOMException;

public class PaintServerReference {
    static final RGB UNRESOLVED_PAINT = new RGB(0, 0, 0);

    public static PaintServer resolve(DocumentNode doc, PaintTarget paintTarget, String traitName, String idRef) {
        ElementNode ref = (ElementNode)doc.getElementById(idRef);
        if (ref != null) {
            if (!(ref instanceof PaintElement)) {
                throw new DOMException(11, Messages.formatMessage("error.invalid.paint.server.reference", new String[]{idRef, ref.getNamespaceURI(), ref.getLocalName()}));
            }
            return ((PaintElement)ref).getPaintServer(traitName, paintTarget);
        }
        return new Unresolved(doc, paintTarget, traitName, idRef);
    }

    static class Unresolved
    implements IDRef,
    PaintServer {
        String idRef;
        PaintTarget paintTarget;
        String paintType;

        public Unresolved(DocumentNode ownerDocument, PaintTarget paintTarget, String paintType, String idRef) {
            if (ownerDocument == null || paintTarget == null || idRef == null || paintType == null) {
                throw new IllegalArgumentException();
            }
            this.paintTarget = paintTarget;
            this.idRef = idRef;
            this.paintType = paintType;
            ownerDocument.resolveIDRef(this, idRef);
        }

        public void resolveTo(ElementNode ref) {
            if (!(ref instanceof PaintServer)) {
                throw new DOMException(11, Messages.formatMessage("error.invalid.paint.server.reference", new String[]{this.idRef, ref.getNamespaceURI(), ref.getLocalName()}));
            }
            this.paintTarget.onPaintServerUpdate(this.paintType, (PaintServer)((Object)ref));
        }

        public String getIdRef() {
            return this.idRef;
        }

        public PaintDef getPaintDef() {
            return UNRESOLVED_PAINT;
        }

        public void setPaintTarget(String paintType, PaintTarget paintTarget) {
            if (paintTarget != this.paintTarget) {
                throw new Error();
            }
        }

        public void dispose() {
        }
    }
}

