/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.TraitAnimationNode;
import com.sun.perseus.util.SimpleTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMException;

public abstract class AbstractAnimate
extends TraitAnimationNode {
    public static final int CALC_MODE_LINEAR = 1;
    public static final int CALC_MODE_DISCRETE = 2;
    public static final int CALC_MODE_PACED = 3;
    public static final int CALC_MODE_SPLINE = 4;
    public static final float MIN_FLATNESS_SQUARE = 1.0E-4f;
    String to;
    String from;
    String by;
    String values;
    int calcMode = 1;
    int actualCalcMode = 2;
    float[] keyTimes;
    float[][] keySplines;
    float[][][] refSplines;
    boolean additive;
    boolean accumulate;
    RefValues refValues = null;
    RefValues toRefValues;
    RefValues fromRefValues;
    RefValues byRefValues;
    RefValues valuesRefValues;
    float[] refTimes;
    float[] sisp = new float[]{0.0f, 0.0f};
    boolean isToAnimation;

    public AbstractAnimate(DocumentNode ownerDocument, String localName) {
        super(ownerDocument, localName);
    }

    Object[] f(long t) {
        float p = 0.0f;
        if (this.timedElementSupport.simpleDur != null && this.timedElementSupport.simpleDur.isResolved()) {
            p = (float)t / (float)this.timedElementSupport.simpleDur.value;
        }
        int nc = this.refValues.getComponents();
        float sp = 0.0f;
        int si = 0;
        float endTime = 1.0f;
        float beginTime = 0.0f;
        int i = 0;
        for (i = 1; i < this.refTimes.length; ++i) {
            if (p < this.refTimes[i]) {
                endTime = this.refTimes[i];
                break;
            }
            beginTime = this.refTimes[i];
        }
        si = i - 1;
        sp = endTime == beginTime ? 1.0f : (p - beginTime) / (endTime - beginTime);
        sp = this.calcMode(sp, si);
        this.sisp[0] = si;
        this.sisp[1] = sp;
        this.mapToSegmentProgress(si, sp, this.sisp);
        si = (int)this.sisp[0];
        sp = this.sisp[1];
        if (this.isToAnimation) {
            Object[] baseValue = this.baseVal.getBaseValue();
            this.refValues.getSegment(0).setStart(baseValue);
            return this.refValues.compute(si, sp);
        }
        Object[] v = this.refValues.compute(si, sp);
        if (!this.isToAnimation && this.accumulate && this.timedElementSupport.curIter > 0) {
            Object[] lv = this.refValues.getSegment(this.refValues.getSegments() - 1).getEnd();
            Object[] r = this.traitAnim.multiply(lv, this.timedElementSupport.curIter);
            v = this.traitAnim.sum(r, v);
        }
        if (!this.additive) {
            return v;
        }
        return this.traitAnim.sum(this.baseVal.getBaseValue(), v);
    }

    protected void mapToSegmentProgress(int si, float sp, float[] sisp) {
    }

    float calcMode(float p, int si) {
        switch (this.actualCalcMode) {
            case 2: {
                return 0.0f;
            }
            case 1: 
            case 3: {
                return p;
            }
        }
        return AbstractAnimate.curve(p, this.refSplines[si]);
    }

    static float[][][] toRefSplines(float[][] splines) {
        float[][][] rSplines = new float[splines.length][][];
        float[][] splineDef = new float[4][2];
        for (int i = 0; i < splines.length; ++i) {
            Vector<float[]> v = new Vector<float[]>();
            v.addElement(new float[]{0.0f, 0.0f});
            splineDef[0][0] = 0.0f;
            splineDef[0][1] = 0.0f;
            splineDef[1][0] = splines[i][0];
            splineDef[1][1] = splines[i][1];
            splineDef[2][0] = splines[i][2];
            splineDef[2][1] = splines[i][3];
            splineDef[3][0] = 1.0f;
            splineDef[3][1] = 1.0f;
            AbstractAnimate.toRefSpline(splineDef, v);
            float[][] polyline = new float[v.size()][];
            v.copyInto((Object[])polyline);
            rSplines[i] = polyline;
        }
        return rSplines;
    }

    static void toRefSpline(float[][] curve, Vector segments) {
        if (AbstractAnimate.isFlat(curve, 1.0E-4f)) {
            segments.addElement(new float[]{curve[3][0], curve[3][1]});
            return;
        }
        float[][] lcurve = new float[4][2];
        float[][] rcurve = new float[4][2];
        lcurve[0] = curve[0];
        lcurve[1][0] = (curve[0][0] + curve[1][0]) / 2.0f;
        lcurve[1][1] = (curve[0][1] + curve[1][1]) / 2.0f;
        float[] h = new float[]{(curve[1][0] + curve[2][0]) / 2.0f, (curve[1][1] + curve[2][1]) / 2.0f};
        lcurve[2][0] = (lcurve[1][0] + h[0]) / 2.0f;
        lcurve[2][1] = (lcurve[1][1] + h[1]) / 2.0f;
        rcurve[2][0] = (curve[2][0] + curve[3][0]) / 2.0f;
        rcurve[2][1] = (curve[2][1] + curve[3][1]) / 2.0f;
        rcurve[1][0] = (h[0] + rcurve[2][0]) / 2.0f;
        rcurve[1][1] = (h[1] + rcurve[2][1]) / 2.0f;
        lcurve[3][0] = (lcurve[2][0] + rcurve[1][0]) / 2.0f;
        lcurve[3][1] = (lcurve[2][1] + rcurve[1][1]) / 2.0f;
        rcurve[0] = lcurve[3];
        rcurve[3] = curve[3];
        AbstractAnimate.toRefSpline(lcurve, segments);
        AbstractAnimate.toRefSpline(rcurve, segments);
    }

    static boolean isFlat(float[][] curve, float flatness) {
        float dx = curve[3][0] - curve[0][0];
        float dy = curve[3][1] - curve[0][1];
        float div = dx * dx + dy * dy;
        if (div == 0.0f) {
            return true;
        }
        float den = dx * (curve[1][1] - curve[0][1]) - dy * (curve[1][0] - curve[0][0]);
        float dP2Sq = den * den / div;
        den = dx * (curve[2][1] - curve[0][1]) - dy * (curve[2][0] - curve[0][0]);
        float dP3Sq = den * den / div;
        return dP2Sq <= flatness && dP3Sq <= flatness;
    }

    static float curve(float p, float[][] polyline) {
        int i;
        for (i = 0; i < polyline.length && !(p < polyline[i][0]); ++i) {
        }
        if (i == polyline.length || i == 0) {
            return (float)i / (float)polyline.length;
        }
        float[] from = polyline[i - 1];
        float[] to = polyline[i];
        return (to[0] * from[1] - to[1] * from[0] + p * (to[1] - from[1])) / (to[0] - from[0]);
    }

    boolean supportsTrait(String traitName) {
        if ("to" == traitName || "from" == traitName || "by" == traitName || "values" == traitName || "calcMode" == traitName || "keyTimes" == traitName || "keySplines" == traitName || "additive" == traitName || "accumulate" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("to" == name) {
            return this.to;
        }
        if ("from" == name) {
            return this.from;
        }
        if ("by" == name) {
            return this.by;
        }
        if ("values" == name) {
            return this.values;
        }
        if ("calcMode" == name) {
            switch (this.calcMode) {
                case 2: {
                    return "discrete";
                }
                case 1: {
                    return "linear";
                }
                case 3: {
                    return "paced";
                }
            }
            return "spline";
        }
        if ("keyTimes" == name) {
            return this.toStringTrait(this.keyTimes);
        }
        if ("keySplines" == name) {
            return this.toStringTrait(this.keySplines);
        }
        if ("additive" == name) {
            if (this.additive) {
                return "sum";
            }
            return "replace";
        }
        if ("accumulate" == name) {
            if (this.accumulate) {
                return "sum";
            }
            return "none";
        }
        return super.getTraitImpl(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("to" == name) {
            this.checkWriteLoading(name);
            this.to = value;
            return;
        } else if ("from" == name) {
            this.checkWriteLoading(name);
            this.from = value;
            return;
        } else if ("by" == name) {
            this.checkWriteLoading(name);
            this.by = value;
            return;
        } else if ("values" == name) {
            this.checkWriteLoading(name);
            this.values = value;
            return;
        } else if ("keyTimes" == name) {
            this.checkWriteLoading(name);
            this.keyTimes = this.parseFloatArrayTrait(name, value.replace(';', ','));
            if (this.keyTimes[0] < 0.0f || this.keyTimes[0] > 1.0f) {
                throw this.illegalTraitValue(name, value);
            }
            for (int i = 1; i < this.keyTimes.length; ++i) {
                if (this.keyTimes[i] < 0.0f || this.keyTimes[i] > 1.0f) {
                    throw this.illegalTraitValue(name, value);
                }
                if (!(this.keyTimes[i] < this.keyTimes[i - 1])) continue;
                throw this.illegalTraitValue(name, value);
            }
            return;
        } else if ("keySplines" == name) {
            this.checkWriteLoading(name);
            SimpleTokenizer st = new SimpleTokenizer(value, ";");
            int n = st.countTokens();
            this.keySplines = new float[n][];
            for (int i = 0; i < n; ++i) {
                String splineDef = st.nextToken();
                this.keySplines[i] = this.parseFloatArrayTrait(name, splineDef);
                if (!(this.keySplines[i].length != 4 || this.keySplines[i][0] < 0.0f || this.keySplines[i][0] > 1.0f || this.keySplines[i][1] < 0.0f || this.keySplines[i][1] > 1.0f || this.keySplines[i][2] < 0.0f || this.keySplines[i][2] > 1.0f || this.keySplines[i][3] < 0.0f) && !(this.keySplines[i][3] > 1.0f)) continue;
                throw this.illegalTraitValue(name, value);
            }
            return;
        } else if ("additive" == name) {
            this.checkWriteLoading(name);
            if ("replace".equals(value)) {
                this.additive = false;
                return;
            } else {
                if (!"sum".equals(value)) throw this.illegalTraitValue(name, value);
                this.additive = true;
            }
            return;
        } else if ("accumulate" == name) {
            this.checkWriteLoading(name);
            if ("none".equals(value)) {
                this.accumulate = false;
                return;
            } else {
                if (!"sum".equals(value)) throw this.illegalTraitValue(name, value);
                this.accumulate = true;
            }
            return;
        } else if ("calcMode" == name) {
            if ("discrete".equals(value)) {
                this.calcMode = 2;
                return;
            } else if ("linear".equals(value)) {
                this.calcMode = 1;
                return;
            } else if ("paced".equals(value)) {
                this.calcMode = 3;
                return;
            } else {
                if (!"spline".equals(value)) throw this.illegalTraitValue(name, value);
                this.calcMode = 4;
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    float[] getDefaultTiming(RefValues refValues) {
        int ns = refValues.getSegments();
        float[] refTimes = new float[ns];
        float startTime = 0.0f;
        float segLength = 1.0f / (float)ns;
        for (int i = 0; i < ns; ++i) {
            refTimes[i] = startTime;
            startTime += segLength;
        }
        return refTimes;
    }

    float[] getPacedTiming(RefValues refValues) {
        float D = refValues.getLength();
        int ns = refValues.getSegments();
        this.refTimes = new float[ns];
        float prevRefTime = 0.0f;
        if (D > 0.0f) {
            for (int si = 1; si < ns; ++si) {
                this.refTimes[si] = prevRefTime + refValues.getLength(si - 1) / D;
                prevRefTime = this.refTimes[si];
            }
        } else {
            float sl = 1.0f / (float)ns;
            for (int si = 1; si < ns; ++si) {
                this.refTimes[si] = (float)si * sl;
            }
        }
        return this.refTimes;
    }

    void validate() throws DOMException {
        super.validate();
        if (this.traitName == null) {
            throw this.illegalTraitValue("attributeName", this.traitName);
        }
        this.traitAnim = this.targetElement.getSafeTraitAnimNS(this.traitNamespace, this.traitName);
        this.actualCalcMode = this.traitAnim.supportsInterpolation() ? this.calcMode : 2;
        this.validateValues();
        this.selectRefValues();
        if (this.hasNoEffect) {
            return;
        }
        if (this.actualCalcMode == 2) {
            this.refValues.makeDiscrete();
        }
        this.refValues.initialize();
        this.computeRefTimes();
        if (this.actualCalcMode == 4) {
            if (this.keySplines == null || this.refTimes.length != this.keySplines.length) {
                throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage("error.invalid.animation.key.splines", new Object[]{this.getTrait("keySplines"), this.getTrait("keyTimes")}));
            }
            this.refSplines = AbstractAnimate.toRefSplines(this.keySplines);
        }
    }

    protected void computeRefTimes() throws DOMException {
        if (this.actualCalcMode == 3) {
            this.refTimes = this.getPacedTiming(this.refValues);
        } else if (this.keyTimes != null) {
            if (this.keyTimes.length < 1 || this.keyTimes[0] != 0.0f || this.actualCalcMode != 2 && (this.keyTimes[this.keyTimes.length - 1] != 1.0f || this.keyTimes.length != this.refValues.getSegments() + 1) || this.actualCalcMode == 2 && this.keyTimes.length != this.refValues.getSegments()) {
                throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage("error.invalid.animation.key.times", new Object[]{this.getTrait("keyTimes")}));
            }
            if (this.actualCalcMode != 2) {
                this.refTimes = new float[this.keyTimes.length - 1];
                System.arraycopy(this.keyTimes, 0, this.refTimes, 0, this.refTimes.length);
            } else {
                this.refTimes = this.keyTimes;
            }
            if (this.refTimes.length != this.refValues.getSegments()) {
                throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage("error.invalid.animation.key.times", new Object[]{this.getTrait("keyTimes")}));
            }
        } else {
            this.refTimes = this.getDefaultTiming(this.refValues);
        }
    }

    final void validateValues() throws DOMException {
        this.toRefValues = null;
        if (this.to != null) {
            this.toRefValues = this.traitAnim.toRefValues(this, new String[]{this.to}, null, "to");
        }
        this.byRefValues = null;
        if (this.by != null) {
            this.byRefValues = this.traitAnim.toRefValues(this, new String[]{this.by}, null, "by");
        }
        this.fromRefValues = null;
        if (this.from != null) {
            this.fromRefValues = this.traitAnim.toRefValues(this, new String[]{this.from}, null, "from");
        }
        this.valuesRefValues = null;
        if (this.values != null) {
            String[] v = this.parseStringArrayTrait("values", this.values, ";");
            this.valuesRefValues = this.traitAnim.toRefValues(this, v, null, "values");
        }
        this.validateValuesExtra();
    }

    void validateValuesExtra() throws DOMException {
    }

    void selectRefValuesExtra() throws DOMException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void selectRefValues() throws DOMException {
        this.refValues = null;
        this.selectRefValuesExtra();
        if (this.refValues != null) {
            return;
        }
        this.isToAnimation = false;
        if (this.values != null) {
            this.refValues = this.valuesRefValues;
            return;
        } else if (this.from != null) {
            this.refValues = this.fromRefValues;
            if (this.to != null) {
                this.refValues.getSegment(0).collapse(this.toRefValues.getSegment(0), this);
                return;
            } else {
                if (this.by == null) throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage("error.invalid.animation.from.anim", null));
                if (!this.refValues.getSegment(0).isAdditive()) throw new DOMException(9, Messages.formatMessage(Messages.ERROR_ATTRIBUTE_NOT_ADDITIVE_FROM_BY, new Object[]{this.traitName, this.traitNamespace, this.getLocalName(), this.getNamespaceURI()}));
                try {
                    this.refValues.getSegment(0).addToEnd(this.byRefValues.getSegment(0).getStart());
                    return;
                }
                catch (IllegalArgumentException iae) {
                    throw new DOMException(9, Messages.formatMessage(Messages.ERROR_INCOMPATIBLE_FROM_BY, new Object[]{this.traitName, this.traitNamespace, this.getLocalName(), this.getNamespaceURI(), this.from, this.to}));
                }
            }
        } else if (this.by != null) {
            if (!this.byRefValues.getSegment(0).isAdditive()) {
                throw new DOMException(9, Messages.formatMessage(Messages.ERROR_ATTRIBUTE_NOT_ADDITIVE_BY, new Object[]{this.traitName, this.traitNamespace, this.getLocalName(), this.getNamespaceURI()}));
            }
            this.refValues = this.byRefValues;
            this.refValues.getSegment(0).setZeroStart();
            this.additive = true;
            return;
        } else if (this.to != null) {
            this.isToAnimation = true;
            this.refValues = this.toRefValues;
            return;
        } else {
            this.hasNoEffect = true;
        }
    }
}

