/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.custom.runtime.provider.Delim;
import com.sun.encoder.custom.runtime.provider.Match;
import com.sun.encoder.custom.runtime.provider.Nodes;
import com.sun.encoder.custom.runtime.provider.NodesFactory;
import com.sun.encoder.custom.runtime.provider.OtdDelim;
import com.sun.encoder.runtime.CoderFactory;
import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.OtdLocation;
import com.sun.encoder.runtime.OtdMeta;
import com.sun.encoder.runtime.StringCoder;
import com.sun.encoder.runtime.UnmarshalException;
import com.sun.encoder.runtime.provider.Misc;
import com.sun.encoder.runtime.provider.StringOtdInputStreamImpl;
import com.sun.encoder.runtime.provider.WrapOtdInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Parse
implements OtdDelim.MatchReply {
    private final OtdDelim.OtdDelimInst mInst;
    private final Nodes mNodes;
    private Match mMatch = new Match();
    private byte[] mData = null;
    private int mPos = 0;
    private int mEnd = 0;
    private boolean mDone = false;
    private Delim mLast = null;
    private OtdMeta mMeta = null;
    private PrintStream mDebug = null;
    private int mMatchPos = 0;
    private int mDataStartPos = 0;
    private int mDataLength = 0;
    private String mReason = null;
    private static final int FRAG_SIZE = 10;
    public static final String NO_PATH = "<no path>";

    public Parse(OtdDelim.OtdDelimInst inst, Nodes nodes) {
        this.mInst = inst;
        this.mNodes = nodes;
        this.mMatch.setMetadataLocation(this.mNodes.getMetadataLocation());
        this.mMatch.setMetadataNamespace(this.mNodes.getMetadataNamespace());
    }

    public void setPos(int pos) {
        this.mMatchPos = pos;
    }

    public void setDataStartPos(int pos) {
        this.mDataStartPos = pos;
    }

    public void setDataLength(int length) {
        this.mDataLength = length;
    }

    public void setDebugStream(PrintStream out) {
        this.mDebug = out;
    }

    public PrintStream getDebugStream() {
        return this.mDebug;
    }

    public void setMeta(OtdMeta meta) {
        this.mMeta = meta;
    }

    public boolean parse(int top, ContentHandler handler, StringCoder decoder, byte[] data) throws IOException, UnmarshalException, SAXException {
        if (this.mDebug != null) {
            this.mDebug.println("[ - parse root=" + top + ", " + data.length + " bytes");
        }
        if (this.mNodes.get(top).isSimple()) {
            throw new IllegalArgumentException("leaf field can't be top rule");
        }
        StringOtdInputStreamImpl in = new StringOtdInputStreamImpl(data);
        this.mInst.setSlotData(this.getEmbeddedDelimiters(this.mInst.getOtd().mSlots, (OtdInputStream)in));
        this.mData = data;
        this.mPos = 0;
        this.mEnd = data.length;
        this.mDone = false;
        this.mLast = null;
        if (this.mDebug != null) {
            this.mDebug.println("[ - clear match list ]");
        }
        this.mMatch.clear();
        if (this.parseNode(top, true, null, this.mInst.getOtd().mEmptyStack, 0, true) != 1) {
            throw new RuntimeException("mandatory match failed");
        }
        if (this.mPos < this.mEnd) {
            this.fail(null, "left over " + (this.mEnd - this.mPos) + " bytes at end of data");
        }
        if (!this.mDone) {
            this.fail(null, "expecting more data, most likely caused by a delimiter at the end of data");
        }
        if (this.mDebug != null) {
            this.mMatch.print(new PrintWriter(this.mDebug, true));
            this.mDebug.println("[ - apply match list ]");
        }
        this.mMatch.apply(this.mNodes, handler, decoder, (OtdInputStream)in);
        return true;
    }

    public boolean parse(int top, ContentHandler handler, StringCoder decoder, OtdInputStream in) throws IOException, UnmarshalException, SAXException {
        if (this.mNodes.get(top).isSimple()) {
            throw new IllegalArgumentException("leaf field can't be top rule");
        }
        this.mInst.setSlotData(this.getEmbeddedDelimiters(this.mInst.getOtd().mSlots, in));
        this.mData = WrapOtdInputStream.getBytes((OtdInputStream)in);
        this.mPos = 0;
        this.mEnd = this.mData.length;
        this.mDone = false;
        this.mLast = null;
        this.mMatch.clear();
        if (this.parseNode(top, true, null, this.mInst.getOtd().mEmptyStack, 0, true) != 1) {
            throw new RuntimeException("mandatory match failed");
        }
        if (this.mPos < this.mEnd) {
            this.fail(null, "left over " + (this.mEnd - this.mPos) + " bytes at end of data");
        }
        if (this.mLast != null && this.mLast.mTerm == 0 && !this.mDone) {
            this.fail(null, "expecting more data, most likely caused by a delimiter at the end of data");
        }
        if (this.mDebug != null) {
            this.mMatch.print(new PrintWriter(this.mDebug, true));
        }
        this.mMatch.apply(this.mNodes, handler, decoder, in);
        return true;
    }

    public byte[][] getEmbeddedDelimiters(Delim.Slot[] slots, OtdInputStream in) throws IOException, UnmarshalException {
        if (slots == null) {
            return null;
        }
        byte[][] data = new byte[slots.length][];
        long offset = 0L;
        for (int i = 0; i < slots.length; ++i) {
            data[i] = new byte[slots[i].mLength];
            long skip = slots[i].mOffset - offset;
            if (skip < 0L) {
                in.rewind();
                skip += offset;
                offset = 0L;
            }
            if (skip > 0L) {
                in.skip(skip);
                offset += skip;
            }
            if (in.read(data[i]) < data[i].length) {
                throw new UnmarshalException((OtdLocation)new Ud1Location(offset), "embedded delimiter (offset=" + slots[i].mOffset + ", length=" + slots[i].mLength + ") extends beyond end of data");
            }
            offset += (long)slots[i].mLength;
            if (this.mDebug == null) continue;
            this.mDebug.println("[ got embed #" + i + " = " + Misc.printable((byte[])data[i]) + " ]");
        }
        if (offset > 0L) {
            in.rewind();
        }
        return data;
    }

    public Nodes getNodes() {
        return this.mNodes;
    }

    private String fragment(int pos) {
        int len = this.mData.length;
        int ante = pos - 10;
        int post = pos + 10;
        if (ante < 3) {
            ante = 0;
        }
        if (post > len - 3) {
            post = len;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ante == 0 ? "<SOD>\"" : "\"...");
        for (int i = ante; i < post; ++i) {
            if (i == pos) {
                sb.append("\"<POS>\"");
            }
            sb.append(Misc.printable((byte)this.mData[i]));
        }
        sb.append(post == len ? "\"<EOD>" : "...\"");
        if (pos == len) {
            sb.append("<POS>");
        }
        return sb.toString();
    }

    public static String last(OtdMeta meta, Match match) {
        int[] at = match.last();
        if (at.length == 0) {
            return NO_PATH;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < at.length; i += 2) {
            sb.append('.');
            if (meta == null || meta.isLeaf() || meta.getChildCount() < at[i]) {
                sb.append(at[i]);
                meta = null;
            } else {
                meta = meta.getChild(at[i]);
                sb.append(meta.getName());
            }
            if (at[i + 1] < 0) continue;
            sb.append("[" + at[i + 1] + "]");
        }
        return sb.toString().substring(1);
    }

    public void fail(Nodes.Node node, String text) {
        throw new UnmarshalException((OtdLocation)new Ud1Location(this.mPos), this.fragment(this.mPos) + " failed input match" + (node == null ? "" : ", name=" + (node.mName == null ? "" : new QName(node.mNamespace, node.mName))) + ", after " + Parse.last(this.mMeta, this.mMatch) + ": " + text);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String byteSeq(byte align, byte[] data, int from, int to) {
        if (this.mDebug != null) {
            this.mDebug.println("[ - match " + Nodes.nodeAlign(align) + " " + Misc.printable((byte[])data) + " ]");
        }
        int len = to - from;
        int rest = len - data.length;
        switch (align) {
            case 0: {
                return null;
            }
            case 2: {
                if (rest < 0) {
                    return "failed begin-match length";
                }
                int i = 0;
                while (true) {
                    if (i >= data.length) {
                        return null;
                    }
                    if (this.mData[from + i] != data[i]) {
                        return "failed begin-match sequence";
                    }
                    ++i;
                }
            }
            case 1: {
                if (rest != 0) {
                    return "failed exact-match length";
                }
                int i = 0;
                while (true) {
                    if (i >= data.length) {
                        return null;
                    }
                    if (this.mData[from + i] != data[i]) {
                        return "failed exact-match sequence";
                    }
                    ++i;
                }
            }
            case 3: {
                if (rest < 0) {
                    return "failed final-match length";
                }
                from += rest;
                int i = 0;
                while (true) {
                    if (i >= data.length) {
                        return null;
                    }
                    if (this.mData[from + i] != data[i]) {
                        return "failed final-match sequence";
                    }
                    ++i;
                }
            }
            case 4: {
                if (rest < 0) {
                    return "failed inter-match length";
                }
                block12: while (true) {
                    if (rest-- < 0) {
                        return "failed inter-match sequence";
                    }
                    int i = 0;
                    while (true) {
                        if (i >= data.length) {
                            return null;
                        }
                        if (this.mData[from + i] != data[i]) {
                            ++from;
                            continue block12;
                        }
                        ++i;
                    }
                    break;
                }
            }
            case 6: {
                if (data.length < 1) {
                    return "failed oneof-match length";
                }
                byte init = data[0];
                int pos = 0;
                while (true) {
                    int next;
                    if (pos >= data.length) {
                        return "failed oneof-match sequence";
                    }
                    for (next = ++pos; next < data.length && data[next] != init; ++next) {
                    }
                    int sublen = next - pos;
                    if (sublen == len) {
                        int i = 0;
                        while (true) {
                            if (i >= len) {
                                return null;
                            }
                            if (this.mData[from + i] != data[pos + i]) break;
                            ++i;
                        }
                    }
                    pos = next;
                }
            }
            case 5: {
                if (rest > 0) {
                    return "failed super-match length";
                }
                int sub = 0;
                block17: while (rest++ <= 0) {
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            return null;
                        }
                        if (this.mData[from + i] != data[sub + i]) {
                            ++sub;
                            continue block17;
                        }
                        ++i;
                    }
                    break;
                }
                return "failed super-match sequence";
            }
        }
        throw new RuntimeException("unsupported alignment: " + align);
    }

    private String showFragment(int from, int to) {
        int SHOW_MAX = 20;
        StringBuffer sb = new StringBuffer();
        int total = to - from;
        int show = total;
        if (show > 20) {
            show = 17;
        }
        for (int i = 0; i < show; ++i) {
            sb.append(Misc.printable((byte)this.mData[from + i]));
        }
        if (show < total) {
            sb.append("...");
        }
        return sb.toString();
    }

    private int parseSingleDelim(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count) {
        if (this.mDebug != null) {
            this.mDebug.println("[ parse single delim, Fog#" + node.mNodeId + (must ? ", must" : "") + " ]");
        }
        if (node.mLevel != null) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - push local delim list ]");
            }
            level = node.mLevel;
        }
        if (this.mDone) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - fail, end of parent ]");
            }
            if (node.mOption && !level.isExplicit()) {
                return 0;
            }
            if (must) {
                this.fail(node, "end of parent");
            }
            return -1;
        }
        if (level == null) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - fail, no current delimiter ]");
            }
            if (must) {
                this.fail(node, "no delimiter defined");
            }
            return -1;
        }
        if (stack == null) {
            throw new NullPointerException("no delim stack");
        }
        stack = this.mInst.push(stack, level, node.mRepeat);
        String why = null;
        do {
            if (count == node.mMaxOcc) {
                if (this.mDebug == null) break;
                this.mDebug.println("[ - reached max occurs ]");
                break;
            }
            Delim delim = stack.match(this.mData, this.mPos, this.mEnd, this);
            if (delim == null) {
                if (level.isTerminal()) {
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - no delim, missing terminator ]");
                    }
                    this.fail(node, "missing terminator");
                }
                if (node.mMatch != null && node.mAlign != 0 && (why = this.byteSeq(node.mAlign, node.mMatch, this.mPos, this.mEnd)) != null) break;
                if (this.mDebug != null) {
                    this.mDebug.println("[ - okay, no delim, match to EOD ]");
                }
                this.mDone = true;
                this.mMatch.field(node.mChild, node.mRepeat ? count : -1, this.mPos, this.mEnd - this.mPos);
                this.mPos = this.mEnd;
                this.mLast = null;
                ++count;
                break;
            }
            this.mLast = delim;
            boolean local = level.contains(this.mLast);
            if (!local && level.isTerminal()) {
                if (this.mDebug != null) {
                    this.mDebug.println("[ - hit parent delim, missing local terminator ]");
                }
                this.fail(node, "missing local terminator");
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - okay, got delim " + Misc.printable((byte[])this.mLast.mData) + " ]");
            }
            if (node.mOption && this.mDataLength == 0 && (level.mPlainDelim != null ? level.mPlainDelim.mLieu != 0 : delim.mLieu != 0)) {
                if (local) {
                    this.mPos = this.mMatchPos + (this.mLast.embedded() ? this.mInst.getOtd().mSlots[this.mLast.mSlot].mLength : this.mLast.mData.length);
                }
                this.mDone = !local;
                break;
            }
            if (node.mMatch != null && node.mAlign != 0 && (why = this.byteSeq(node.mAlign, node.mMatch, this.mDataStartPos, this.mDataStartPos + this.mDataLength)) != null) break;
            this.mMatch.field(node.mChild, node.mRepeat ? count : -1, this.mDataStartPos, this.mDataLength);
            ++count;
            if (this.mDebug != null) {
                this.mDebug.println("[ - matched data " + this.mPos + " to " + this.mMatchPos + ": \"" + this.showFragment(this.mPos, this.mMatchPos) + "\" ]");
            }
            this.mPos = this.mMatchPos;
            if (!local) {
                if (this.mDebug != null) {
                    this.mDebug.println("[ - delim not local, leave it ]");
                }
                this.mDone = true;
                break;
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - delim was local, skip it ]");
            }
            this.mPos += this.mLast.embedded() ? this.mInst.getOtd().mSlots[this.mLast.mSlot].mLength : this.mLast.mData.length;
            if (node.mType != 1 || this.mLast.mType != 0) continue;
            if (this.mDebug == null) break;
            this.mDebug.println("[ - delim ends array ]");
            break;
        } while (node.mRepeat && !this.mDone);
        this.mReason = why;
        return count;
    }

    private int parseFixed(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count) {
        boolean might;
        if (node == null) {
            throw new NullPointerException("no node");
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ parse fixed, Fog#" + node.mNodeId + ", count=" + count + (must ? ", must" : "") + " ]");
        }
        String why = null;
        boolean bl = might = must && !node.mOption && !node.mRepeat;
        block0: do {
            if (count == node.mMaxOcc) {
                if (this.mDebug == null) break;
                this.mDebug.println("[ - reached max occurs ]");
                break;
            }
            if (this.mDone) {
                why = "end of parent";
                break;
            }
            int newEnd = this.mEnd;
            if (node.mLength > 0 && this.mEnd < (newEnd = this.mPos + node.mLength)) {
                why = "insufficient data for fixed field";
                break;
            }
            int pos = this.mPos;
            stack = this.mInst.hide(stack, 10);
            if (!node.isSimple()) {
                int oldEnd = this.mEnd;
                this.mEnd = newEnd;
                int e = this.mMatch.enter(node.mChild, node.mRepeat ? count : -1, this.mPos);
                for (int i = 0; i < node.mSub.length; ++i) {
                    if (this.parseNode(node.mSub[i], might, level, stack, 0, true) >= 0) continue;
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - failed child #" + i + ": reset map=" + e + ", pos=" + pos + " ]");
                    }
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    this.mDone = false;
                    this.mEnd = oldEnd;
                    break block0;
                }
                this.mEnd = oldEnd;
                if (node.mLength > 0 && this.mPos != newEnd) {
                    why = "trailing junk in fixed/parent";
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    this.mDone = false;
                    break;
                }
                if (node.mRepeat && pos == this.mPos) {
                    why = "empty repetition occurrence";
                    this.mMatch.reset(e);
                    this.mDone = false;
                    break;
                }
                this.mMatch.leave(e);
                ++count;
                this.mDone = this.mPos == this.mEnd;
                continue;
            }
            Delim delim = stack.match(this.mData, this.mPos, newEnd, this);
            if (delim == null) {
                if (node.mMatch != null && node.mAlign != 0 && (why = this.byteSeq(node.mAlign, node.mMatch, this.mPos, newEnd)) != null) break;
                this.mDone = this.mMatchPos == this.mEnd;
                this.mLast = null;
            } else {
                if (node.mLength > 0) {
                    why = "fixed field cut off by ancestor delimiter";
                    break;
                }
                newEnd = this.mMatchPos;
                this.mLast = delim;
                this.mDone = true;
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - matched data " + this.mPos + " to " + newEnd + ": \"" + this.showFragment(this.mPos, newEnd) + "\" ]");
            }
            this.mMatch.field(node.mChild, node.mRepeat ? count : -1, this.mPos, newEnd - this.mPos);
            ++count;
            this.mPos = newEnd;
        } while (node.mRepeat && !this.mDone);
        this.mReason = why;
        return count;
    }

    private int parseMultiDelim(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count) {
        boolean might;
        if (node.isSimple()) {
            throw new IllegalArgumentException("simple node");
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ parse group delim, Fog#" + node.mNodeId + (must ? ", must" : "") + " ]");
        }
        if (this.mDone) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - fail, end of parent ]");
            }
            if (node.mOption || node.mRepeat) {
                return 0;
            }
            if (must) {
                this.fail(node, "end of parent");
            }
            return -1;
        }
        if (node.mLevel != null) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - push local delim list ]");
            }
            level = node.mLevel;
        }
        if (level == null) {
            if (this.mDebug != null) {
                this.mDebug.println("[ - fail, no current delimiter ]");
            }
            if (must) {
                this.fail(node, "no delimiter defined");
            }
            return -1;
        }
        stack = this.mInst.push(stack, level, node.mRepeat);
        if (node.mSub.length == 0) {
            throw new RuntimeException("childless parent");
        }
        String why = null;
        boolean bl = might = must && !node.mOption && !node.mRepeat;
        block0: do {
            boolean local;
            Delim delim;
            if (count == node.mMaxOcc) {
                if (this.mDebug == null) break;
                this.mDebug.println("[ - reached max occurs ]");
                break;
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - iteration #" + count + " ]");
            }
            int pos = this.mPos;
            int e = this.mMatch.enter(node.mChild, node.mRepeat ? count : -1, pos);
            boolean anyDelimChild = false;
            for (int i = 0; i < node.mSub.length; ++i) {
                Nodes.Node child = this.mNodes.get(node.mSub[i]);
                anyDelimChild |= child.isArray() || child.isDelim();
                if (this.parseNode(child, might, level.mNext, stack, 0, true) >= 0) continue;
                if (this.mDebug != null) {
                    this.mDebug.println("[ - failed child #" + i + ": reset map=" + e + ", pos=" + pos + " ]");
                }
                this.mMatch.reset(e);
                this.mPos = pos;
                this.mDone = false;
                if (!node.mOption || node.mRepeat || (delim = stack.match(this.mData, this.mPos, this.mEnd, this)) == null || this.mDataLength != 0 || !level.contains(delim) || delim.mLieu == 0) break block0;
                if (this.mDebug != null) {
                    this.mDebug.println("[ - consume absent-option delim ]");
                }
                this.mPos = this.mMatchPos + (delim.embedded() ? this.mInst.getOtd().mSlots[delim.mSlot].mLength : delim.mData.length);
                this.mLast = null;
                break block0;
            }
            if (!this.mDone) {
                if (anyDelimChild && (this.mLast == null || this.mLast.mTerm <= 0)) {
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - no EOD or parent delim, stop ]");
                    }
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    why = "trailing data after last child";
                    break;
                }
                if (this.mDebug != null) {
                    this.mDebug.println("[ - retry parent delimiter ]");
                }
                delim = null;
                if (this.mPos != this.mEnd && ((delim = stack.match(this.mData, this.mPos, this.mEnd, this)) == null || this.mDataLength > 0)) {
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - retry failed: " + (delim != null ? "overshoot" : "no delim") + (delim != null ? ", del=" + this.mMatchPos : "") + ", pos=" + this.mPos + " ]");
                    }
                    why = "trailing junk after last child";
                    break;
                }
                this.mLast = delim;
                this.mDone = true;
            }
            boolean bl2 = local = this.mLast != null && level.contains(this.mLast);
            if (level.isTerminal() && !local) {
                if (this.mDebug != null) {
                    this.mDebug.println("[ - no delim, missing terminator ]");
                }
                this.mMatch.reset(e);
                why = "missing terminator";
                this.mDone = true;
                break;
            }
            if ((node.mOption || node.mRepeat) && this.mLast != null && this.mLast.mLieu > 0 && pos == this.mPos) {
                this.mMatch.reset(e);
            } else {
                this.mMatch.leave(e);
                ++count;
            }
            if (this.mLast != null) {
                if (local) {
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - eat delimiter now ]");
                    }
                    this.mPos = this.mMatchPos + (this.mLast.embedded() ? this.mInst.getOtd().mSlots[this.mLast.mSlot].mLength : this.mLast.mData.length);
                    this.mDone = false;
                    Delim last = this.mLast;
                    this.mLast = null;
                    if (!node.isArray() || last.mType != 0) continue;
                    break;
                }
                this.mDone = true;
                break;
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - end of data, stop now ]");
            }
            this.mDone = true;
            break;
        } while (node.mRepeat);
        this.mReason = why;
        return count;
    }

    private int parseGroup(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count) {
        boolean might;
        if (node.isSimple()) {
            throw new IllegalArgumentException("simple node");
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ parse group, count=" + count + ", order=" + node.mOrder + (must ? ", must" : "") + " ]");
        }
        if (this.mDone) {
            if (node.mOption || node.mRepeat) {
                return count;
            }
            if (must) {
                this.fail(node, "end of parent");
            }
            return 0;
        }
        if (node.mLevel != null) {
            level = node.mLevel;
        }
        if (node.isSimple() || node.mSub.length == 0) {
            throw new RuntimeException("NYI: childless group not handled");
        }
        boolean ordered = node.mOrder == 0;
        boolean bl = might = must && !node.mOption && !node.mRepeat;
        block0: do {
            if (count == node.mMaxOcc) {
                if (this.mDebug == null) break;
                this.mDebug.println("[ - reached max occurs ]");
                break;
            }
            int pos = this.mPos;
            int e = this.mMatch.enter(node.mChild, node.mRepeat ? count : -1, pos);
            if (ordered) {
                for (int i = 0; i < node.mSub.length; ++i) {
                    if (this.parseNode(node.mSub[i], might, level, stack, 0, ordered) >= 0) continue;
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    this.mDone = false;
                    break block0;
                }
            } else {
                int subs = node.mSub.length;
                int over = -1;
                boolean[] complete = new boolean[subs];
                int[] occurs = new int[subs];
                boolean go = true;
                while (go) {
                    go = false;
                    over = -1;
                    for (int i = 0; i < node.mSub.length; ++i) {
                        if (complete[i]) continue;
                        Nodes.Node subNode = this.mNodes.get(node.mSub[i]);
                        int subCount = this.parseNode(node.mSub[i], false, level, stack, occurs[i], ordered);
                        if (subCount > 0) {
                            int n = i;
                            occurs[n] = occurs[n] + subCount;
                            go = true;
                            if (subNode.mRepeat && occurs[i] != subNode.mMaxOcc) continue;
                            complete[i] = true;
                            --subs;
                            continue;
                        }
                        if (subNode.mRepeat || subNode.mOption) continue;
                        over = i;
                    }
                }
                if (this.mDebug != null) {
                    this.mDebug.println("[ - finished cycles, subs=" + subs + ", over=" + over + "]");
                    for (int i = 0; i < node.mSub.length; ++i) {
                        this.mDebug.println("[ -- C" + i + ": count=" + occurs[i] + (complete[i] ? ", complete" : "") + "]");
                    }
                }
                if (over >= 0) {
                    if (this.mDebug != null) {
                        this.mDebug.println("[ - incomplete child " + over + " ]");
                    }
                    if (this.parseNode(node.mSub[over], might, level, stack, occurs[over], true) >= 0) {
                        throw new RuntimeException("bug: re-parse okay!?");
                    }
                    this.mMatch.reset(e);
                    this.mPos = pos;
                    this.mDone = false;
                    break;
                }
            }
            if (node.mRepeat && pos == this.mPos) {
                this.mMatch.reset(e);
                this.mDone = false;
                break;
            }
            this.mMatch.leave(e);
            ++count;
        } while (node.mRepeat);
        return count;
    }

    private int parseChoice(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count) {
        if (node.isSimple()) {
            throw new IllegalArgumentException("simple node");
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ parse choice ]");
        }
        if (this.mDone) {
            if (node.mOption || node.mRepeat) {
                return 0;
            }
            if (must) {
                this.fail(node, "end of parent");
            }
            return -1;
        }
        if (node.mLevel != null) {
            level = node.mLevel;
        }
        if (node.isSimple() || node.mSub.length == 0) {
            throw new RuntimeException("NYI: childless choice not handled");
        }
        boolean might = must && !node.mOption && !node.mRepeat;
        String why = null;
        do {
            if (count == node.mMaxOcc) {
                if (this.mDebug == null) break;
                this.mDebug.println("[ - reached max occurs ]");
                break;
            }
            int e = this.mMatch.enter(node.mChild, node.mRepeat ? count : -1, this.mPos);
            int found = -1;
            for (int i = 0; found < 0 && i < node.mSub.length; ++i) {
                found = this.parseNode(node.mSub[i], might && i == node.mSub.length - 1, level, stack, 0, true);
            }
            if (found < 0) {
                this.mMatch.reset(e);
                why = "no alternative matched";
                break;
            }
            this.mMatch.leave(e);
            ++count;
        } while (node.mRepeat);
        this.mReason = why;
        return count;
    }

    public int parseNode(Nodes.Node node, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count, boolean ordered) {
        int result = 0;
        if (this.mDebug != null) {
            this.mDebug.println("[ parse '" + node.mName + "', pos=" + this.mPos + ", end=" + this.mEnd + (must ? ", mandatory " : "") + " ]");
        }
        switch (node.mType) {
            case 0: {
                result = this.parseChoice(node, must, level, stack, count);
                break;
            }
            case 1: 
            case 2: {
                result = node.isSimple() ? this.parseSingleDelim(node, must, level, stack, count) : this.parseMultiDelim(node, must, level, stack, count);
                break;
            }
            case 3: {
                result = this.parseFixed(node, must, level, stack, count);
                break;
            }
            case 4: {
                result = this.parseGroup(node, must, level, stack, count);
                break;
            }
            case 5: {
                result = 1;
                break;
            }
            default: {
                throw new RuntimeException("unknown node type " + node.mType);
            }
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ - parse: result=" + result + " ]");
        }
        if (result <= 0 && ordered && !node.mOption && !node.mRepeat) {
            if (must) {
                this.fail(node, "failed node: " + this.mReason);
            }
            return -1;
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ - parse: '" + node.mName + "' " + ", done=" + this.mDone + ", pos=" + this.mPos + ", end=" + this.mEnd + ", last=" + (this.mLast == null ? "EOD" : Misc.printable((byte[])this.mLast.mData)) + " ]");
        }
        return result;
    }

    public int parseNode(int desc, boolean must, OtdDelim.DelimLevel level, OtdDelim.DelimStack stack, int count, boolean ordered) {
        if (this.mDebug != null) {
            this.mDebug.println("[ parse #" + desc + " ]");
        }
        if (stack == null) {
            throw new NullPointerException("no delim stack");
        }
        int res = this.parseNode(this.mNodes.get(desc), must, level, stack, count, ordered);
        if (this.mDebug != null) {
            this.mDebug.println("[ - for #" + desc + ": count=" + res + " ]");
        }
        return res;
    }

    public OtdDelim.OtdDelimInst getOtdDelimInst() {
        return this.mInst;
    }

    public static void main(String[] args) {
        try {
            System.out.println("[ start ]");
            File encoderBase = new File(System.getProperty("ENCODER_SHAREDLIBRARY"));
            File xsdFile = new File(encoderBase, "custom/xsdextension/ud1sample.xsd");
            QName rootElementName = new QName("http://xml.netbeans.org/schema/ud1sample", "root");
            Nodes nodes = NodesFactory.loadFromXSD(xsdFile, rootElementName);
            OtdDelim.OtdDelimInst inst = nodes.getDelim().new OtdDelim.OtdDelimInst();
            Parse parse = new Parse(inst, nodes);
            if (args.length == 0) {
                byte[] data = Misc.str2bytes((String)"a,b|0123456789abcde0123456789");
                parse.setDebugStream(System.out);
                SimpleContentHandler handler = new SimpleContentHandler(true);
                StringCoder decoder = CoderFactory.getCoder((String)"iso-8859-1");
                parse.parse(0, (ContentHandler)handler, decoder, data);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    byte[] data = Misc.str2bytes((String)args[i]);
                    System.out.println();
                    System.out.println("Input data = " + Misc.printable((byte[])data));
                    parse.parse(0, (ContentHandler)new SimpleContentHandler(true), CoderFactory.getCoder((String)"iso-8859-1"), data);
                }
            }
            System.out.println("[ ready ]");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static class SimpleContentHandler
    implements ContentHandler {
        private final boolean mDoPrint;
        int mIndent = 0;
        boolean mHasChar = false;
        boolean mIsOpen = false;

        SimpleContentHandler(boolean doPrint) {
            this.mDoPrint = doPrint;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            if (!this.mDoPrint) {
                return;
            }
            System.out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }

        public void endDocument() throws SAXException {
            if (!this.mDoPrint) {
                return;
            }
            System.out.println();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.mDoPrint) {
                return;
            }
            System.out.println();
            if (this.mIsOpen) {
                ++this.mIndent;
            }
            this.printIndent();
            System.out.print("<" + localName + " xmlns=\"" + uri + "\"");
            for (int i = 0; i < atts.getLength(); ++i) {
                System.out.print(" " + atts.getQName(i));
                System.out.print("=\"");
                System.out.print(atts.getValue(i));
                System.out.print("\"");
            }
            System.out.print(">");
            this.mHasChar = false;
            this.mIsOpen = true;
        }

        public final void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.mDoPrint) {
                return;
            }
            if (this.mHasChar) {
                System.out.print("</" + localName + ">");
                this.mHasChar = false;
            } else {
                System.out.println();
                --this.mIndent;
                this.printIndent();
                System.out.print("</" + localName + ">");
            }
            this.mIsOpen = false;
        }

        public final void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.mDoPrint) {
                return;
            }
            String chars = new String(ch, start, length);
            chars = chars.replace("&", "&amp;");
            System.out.print(chars);
            if (chars.length() > 0) {
                this.mHasChar = true;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        private void printIndent() {
            for (int i = 0; i < this.mIndent; ++i) {
                System.out.print("    ");
            }
        }
    }

    private static class Ud1Location
    implements OtdLocation {
        long mOffset = -1L;

        public Ud1Location(long offset) {
            this.mOffset = offset;
        }

        public String text() {
            return this.mOffset < 0L ? "unknown offset" : "byte offset " + this.mOffset;
        }

        public OtdLocation from() {
            return null;
        }

        public Object getProperty(String name) {
            if ("offset".equals(name) && this.mOffset >= 0L) {
                return new Long(this.mOffset);
            }
            return null;
        }
    }
}

