/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom;

import com.sun.encoder.DataNature;
import com.sun.encoder.Encoder;
import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.EncoderProperties;
import com.sun.encoder.EncoderProvider;
import com.sun.encoder.EncoderType;
import com.sun.encoder.MetaRef;
import com.sun.encoder.custom.CustomEncoder;
import com.sun.encoder.custom.appinfo.NodeProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

public class CustomEncoderProvider
implements EncoderProvider {
    private EncoderType mEncoderType;

    public String getIdentification() {
        return "customencoder-1.0";
    }

    public Encoder newEncoder(MetaRef metaRef, URIResolver uriResolver) throws EncoderConfigurationException {
        return this.newEncoder(metaRef, uriResolver, new EncoderProperties());
    }

    public Map newEncoders(Set metaRefs, URIResolver uriResolver) throws EncoderConfigurationException {
        return this.newEncoders(metaRefs, uriResolver, new EncoderProperties());
    }

    public String[] getAliases() {
        return null;
    }

    public DataNature getDataNature() {
        return DataNature.BYTE_BASED;
    }

    public Encoder newEncoder(MetaRef metaRef, URIResolver uriResolver, EncoderProperties properties) throws EncoderConfigurationException {
        CustomEncoder encoder = new CustomEncoder(this.mEncoderType, properties);
        encoder.setMeta(metaRef);
        return encoder;
    }

    public Map newEncoders(Set metaRefs, URIResolver uriResolver, EncoderProperties properties) throws EncoderConfigurationException {
        if (metaRefs == null || metaRefs.isEmpty()) {
            throw new EncoderConfigurationException("No metadata references.");
        }
        HashSet<String> pathSet = new HashSet<String>();
        HashSet<URL> urlSet = new HashSet<URL>();
        ArrayList<SchemaDocument> xmlObjectList = new ArrayList<SchemaDocument>();
        try {
            XmlOptions options = new XmlOptions();
            options.put((Object)"COMPILE_DOWNLOAD_URLS", (Object)Boolean.TRUE);
            for (MetaRef metaRef : metaRefs) {
                if (metaRef.getURL() != null) {
                    if (urlSet.contains(metaRef.getURL())) continue;
                    xmlObjectList.add(SchemaDocument.Factory.parse((URL)metaRef.getURL(), (XmlOptions)options));
                    urlSet.add(metaRef.getURL());
                    continue;
                }
                if (pathSet.contains(metaRef.getPath())) continue;
                xmlObjectList.add(SchemaDocument.Factory.parse((File)new File(metaRef.getPath())));
                pathSet.add(metaRef.getPath());
            }
            XmlObject[] xmlObjects = xmlObjectList.toArray(new XmlObject[0]);
            SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)NodeProperties.class.getClassLoader());
            SchemaTypeSystem schemaTS = urlSet.size() > 0 ? XmlBeans.compileXsd((XmlObject[])xmlObjects, (SchemaTypeLoader)typeLoader, (XmlOptions)options) : XmlBeans.compileXsd((XmlObject[])xmlObjects, (SchemaTypeLoader)typeLoader, null);
            typeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{typeLoader, schemaTS});
            HashMap<MetaRef, CustomEncoder> encoderMap = new HashMap<MetaRef, CustomEncoder>();
            for (MetaRef metaRef : metaRefs) {
                QName qName = metaRef.getRootElemName();
                if (qName == null) {
                    throw new EncoderConfigurationException("Root element name cannot be null. path='" + metaRef.getPath() + "'");
                }
                SchemaGlobalElement element = typeLoader.findElement(metaRef.getRootElemName());
                if (element == null) {
                    throw new EncoderConfigurationException("Unable to find global element '" + metaRef.getRootElemName() + "'");
                }
                CustomEncoder encoder = new CustomEncoder(this.mEncoderType, properties);
                encoder.setMeta(element);
                encoderMap.put(metaRef, encoder);
            }
            return encoderMap;
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public void setType(EncoderType encoderType) {
        this.mEncoderType = encoderType;
    }
}

