# # -*-makefile -*-
#
#   Creation Date: <1999/03/28 04:20:31 samuel>
#   Time-stamp: <2001/08/25 23:14:46 samuel>
#   
#	<Makefile.dist>
#	
#	Some extra rules to simplify building from source-only
#	trees (e.g. the MOL bitkeeper tree or a rsynced copy)
#   
#   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
#   
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation
#

SOURCETREE_BUILD = yes

ifdef INCLUDE_ST_RULES
NEW_VERSION	= $(shell scripts/version.pl sinclude/version.h).$(shell expr $(PATCH_LEVEL) + 1)

FULLTAR 	= mol-$(VERSION)

####################################################################
# Host/rsync modules of the mac-side binary distribution
####################################################################

RSYNC_HOST	= zorn.theophys.kth.se
RSYNC_LIBMOD	= libmol
RSYNC_LIBMOD_RW = libmol-rw

LIBIMPORT_DIR	= libimport/
EXTRA_BIN_FILES	 = pci_roms/*.nw pci_roms/*.pcirom nvram/nvram.dist startboing
EXTRA_BIN_FILES_ = $(shell if [ -d $(LIBIMPORT_DIR) ] ; then \
			cd $(LIBIMPORT_DIR); find . $(foreach x,  \
			$(EXTRA_BIN_FILES), -path "./$(x)" -o) -false ; fi )

copybinfiles: dummy
	@if [ -d $(LIBIMPORT_DIR) ] ; then \
		echo "--- Copying binary files from $(LIBIMPORT_DIR) to $(MOL_LIB_DIR) ---" ; \
		$(foreach x, $(EXTRA_BIN_FILES_), cp $(LIBIMPORT_DIR)/$(x) $(MOL_LIB_DIR)/$(x) ; ) \
		cp $(LIBIMPORT_DIR)/images/*.im $(MOL_LIB_DIR)/images/ ; \
	fi

deletemacfiles: dummy
	cd $(MOL_LIB_DIR) ; rm -f $(EXTRA_BIN_FILES)
	cd $(MOL_LIB_DIR)/images/ ; rm -f *.im


####################################################################
# Targets for downloading the binary files
####################################################################

libimport: import2 copybinfiles

import2: dummy
	rsync -avz --delete $(RSYNC_HOST)::$(RSYNC_LIBMOD)/ $(LIBIMPORT_DIR)
	@echo "======================================================" > $(LIBIMPORT_DIR)/README
	@echo "  IMPORTANT: DON'T EDIT ANY FILES IN THIS DIRECTORY" >> $(LIBIMPORT_DIR)/README
	@echo "======================================================" >> $(LIBIMPORT_DIR)/README
	@echo " Modify the files in ../mollib/ instead" >> $(LIBIMPORT_DIR)/README
	@echo >> $(LIBIMPORT_DIR)/README

libimport_clean: dummy
	$(RM) -r $(LIBIMPORT_DIR)

libexport: clean
	@if [ ! -f $(MOL_LIB_DIR)/pci_roms/osi_video.nw ] ; then \
		echo "====== This tree does not contain any binary files! ====" ; \
		exit 1; \
	fi
	rsync -avz --exclude-from=.exclude --exclude-from=.libexclude --delete \
		--delete-excluded mollib/ $(RSYNC_HOST)::$(RSYNC_LIBMOD_RW)/


####################################################################
# Distribution targets
####################################################################

dist:	archive rpm dist_ok_warning

dist_ok_warning: dummy
	@echo
	@echo "++++ Don't forget 'make dist_ok' ++++"
	@echo

dist_ok: dummy
	@bk citool
	@read -p "Proceed [y/N]? " A ; [ "$$A" == 'y' -o "$$A" == "Y" ] \
		|| (echo "*** Aborting ***" && false ) ;
	@bk tag "mol-$(VERSION)"
	@bk edit patchlevel.h ; true
	@echo "New patch level: " $(shell expr $(PATCH_LEVEL) + 1)
	@echo "#define PATCH_LEVEL   " $(shell expr $(PATCH_LEVEL) + 1) > patchlevel.h
	@bk ci -u -y"Starting on mol-$(NEW_VERSION)" patchlevel.h
	@bk commit -q

archive: dummy
	@echo '*** ONLY THE CHECKED-IN CHANGESETS ARE INCLUDED (!) ***'
	@echo
	@echo '--- ARCHIVE $(VERSION) ---'
	@echo
	sleep 1
	rm -rf /tmp/molbuild
	mkdir /tmp/molbuild
	bk export ./ /tmp/molbuild/$(FULLTAR)
	cp -a libimport /tmp/molbuild/$(FULLTAR)/libimport ; true
	cd /tmp/molbuild/$(FULLTAR) ; make libimport copybinfiles libimport_clean
	cd /tmp/molbuild ; $(TAR) -hzcf /tmp/$(FULLTAR).tgz $(FULLTAR)
	rm -rf /tmp/molbuild

endif
