/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDAppearance;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.util.BitFlagHelper;

public abstract class PDVariableText
extends PDField {
    public static final int FLAG_MULTILINE = 4096;
    public static final int FLAG_PASSWORD = 8192;
    public static final int FLAG_FILE_SELECT = 0x100000;
    public static final int FLAG_DO_NOT_SPELL_CHECK = 0x400000;
    public static final int FLAG_DO_NOT_SCROLL = 0x800000;
    public static final int FLAG_COMB = 0x1000000;
    public static final int FLAG_RICH_TEXT = 0x2000000;
    private COSString da;
    private PDAppearance appearance;
    public static final int QUADDING_LEFT = 0;
    public static final int QUADDING_CENTERED = 1;
    public static final int QUADDING_RIGHT = 2;

    public PDVariableText(PDAcroForm theAcroForm) {
        super(theAcroForm);
    }

    public PDVariableText(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
        this.da = (COSString)field.getDictionaryObject(COSName.getPDFName("DA"));
    }

    public void setValue(String value) throws IOException {
        COSString fieldValue = new COSString(value);
        this.getDictionary().setItem(COSName.getPDFName("V"), (COSBase)fieldValue);
        if (this.appearance == null) {
            this.appearance = new PDAppearance(this.getAcroForm(), this);
        }
        this.appearance.setAppearanceValue(value);
    }

    public String getValue() throws IOException {
        return this.getDictionary().getString("V");
    }

    public boolean isMultiline() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 4096);
    }

    public void setMultiline(boolean multiline) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 4096, multiline);
    }

    public boolean isPassword() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 8192);
    }

    public void setPassword(boolean password) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 8192, password);
    }

    public boolean isFileSelect() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x100000);
    }

    public void setFileSelect(boolean fileSelect) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x100000, fileSelect);
    }

    public boolean doNotSpellCheck() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x400000);
    }

    public void setDoNotSpellCheck(boolean doNotSpellCheck) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x400000, doNotSpellCheck);
    }

    public boolean doNotScroll() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x800000);
    }

    public void setDoNotScroll(boolean doNotScroll) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x800000, doNotScroll);
    }

    public boolean shouldComb() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x1000000);
    }

    public void setComb(boolean comb) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x1000000, comb);
    }

    public boolean isRichText() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x2000000);
    }

    public void setRichText(boolean richText) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x2000000, richText);
    }

    protected COSString getDefaultAppearance() {
        return this.da;
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getDictionary().getDictionaryObject(COSName.getPDFName("Q"));
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.getDictionary().setItem(COSName.getPDFName("Q"), (COSBase)new COSInteger(q));
    }
}

