/* SubwindowModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet;

import java.util.HashSet;
import java.util.Set;

/**
 *
 */
public class SubwindowModel {
    
    //
    private boolean isVisible;

    //
    private boolean isCollapsed;
    
    //
    private Set<SubwindowModelListener> listeners;
    
    //
    public SubwindowModel(boolean visible, boolean collapsed) {
        isVisible = visible;
        isCollapsed = collapsed;
        listeners = new HashSet<SubwindowModelListener>();
    }
    
    public boolean isVisible() {
        return isVisible;
    }
    
    public boolean isCollapsed() {
        return isCollapsed;
    }
    
    public void setVisible(boolean visible) {
        if (isVisible != visible) {
            isVisible = visible;
            fireVisibleStateChanged();
        }
    }
    
    public void setCollapsed(boolean collapsed) {
        if (isCollapsed != collapsed) {
            isCollapsed = collapsed;
            fireCollapsedStateChanged();
        }
    }
    
    public void addSubwindowModelListener(SubwindowModelListener listener) {
        listeners.add(listener);
    }
    
    public void removeSubwindowModelListener(SubwindowModelListener listener) {
        listeners.remove(listener);
    }
    
    private void fireVisibleStateChanged() {
        for (SubwindowModelListener listener : listeners) {
            listener.visibleStateChanged();
        }
    }

    private void fireCollapsedStateChanged() {
        for (SubwindowModelListener listener : listeners) {
            listener.collapsedStateChanged();
        }
    }
    
}
