/* ExportGraphImage.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import be.ugent.caagt.swirl.actions.FileSaveAction;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.gui.FileFilters;
import org.grinvin.io.graphs.EmbeddingSaver;
import org.grinvin.io.graphs.GraphSaver;
import org.grinvin.list.graphs.GraphList;
import org.grinvin.list.graphs.GraphListElement;

import org.jdom.Element;
import org.jdom.output.XMLOutputter;

/**
 * Exports a graph as an image
 */
public class ExportGraphImage extends FileSaveAction implements ListSelectionListener {
   // TODO: factor out code in common with ExportGraph, is 
   //       identical except for saveFile and filter used
    
    //
    private final ListSelectionModel selectionModel;
    //
    private final GraphList graphList;

    //
    public ExportGraphImage(Window parent, GraphList graphList, ListSelectionModel selectionModel) {
        super(parent, FileFilters.SVG_FILTER);
        this.graphList = graphList;
        this.selectionModel = selectionModel;
        selectionModel.addListSelectionListener(this);
        int index = selectionModel.getMinSelectionIndex();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex());
    }

    protected void saveFile(File file) {
        try {
            int index = selectionModel.getMinSelectionIndex();
            GraphListElement gle = graphList.get(index);

            GraphBundleView bundle = gle.getBundle();

            //XSL Transform
            String xsltFile = "/org/grinvin/io/graph2svg.xslt";
            Element root = new Element("root");
            root.addContent(EmbeddingSaver.toElement(bundle.getEmbedding(0)));
            root.addContent(GraphSaver.toElement(bundle.getGraph()));

            Source xmlSource = new StreamSource(new StringReader(new XMLOutputter().outputString(root)));
            Source xsltSource = new StreamSource(ExportGraphImage.class.getResourceAsStream(xsltFile));
            Writer writer = new StringWriter();
            Result result = new StreamResult(writer);

            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            /*
            trans.setParameter("linefactor", linefactor);
             */
            //trans.setParameter("scale", 100);
            //trans.setParameter("width", 300);
            //trans.setParameter("height", 300);
            /*
            trans.setParameter("x", x);
            trans.setParameter("y", y);
            trans.setParameter("radius", radius*0.01);
             */
            trans.transform(xmlSource, result);

            OutputStream out = new FileOutputStream(file);
            out.write(writer.toString().getBytes());
            out.close();

        } catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException("Saving graph bundle failed:" + e);
        } catch (FileNotFoundException e) {
            throw new RuntimeException("Saving graph bundle failed:" + e);
        } catch (IOException e) {
            throw new RuntimeException("Saving graph bundle failed:" + e);
        }
    }

    /**
     * Alert the user that a file with the chosen name already exists.
     * @return true if the user allows the file to be overwritten.
     */
    protected boolean showFileExistsDialog(File file) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.grinvin.list.actions.resources");

        return JOptionPane.showConfirmDialog(
                parent,
                MessageFormat.format(bundle.getString("File.overwrite.message"), file.getName()),
                bundle.getString("File.overwrite.title"),
                JOptionPane.YES_NO_CANCEL_OPTION) == JOptionPane.YES_OPTION;
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = selectionModel.getMinSelectionIndex();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex());
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        int index = selectionModel.getMinSelectionIndex();
        if (index >= 0 && index == selectionModel.getMaxSelectionIndex()) {
            super.actionPerformed(e);
        }
    }
}
