/* InvariantComputerFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants;

import org.grinvin.factories.FactoryParameterException;

/**
 * An object that satisfies this interface can be used to create an invariant computer. 
 * To have this factory create an invariant computer, first obtain the corresponding
 * invariant factory, set its parameters and then call {@link #createInvariantComputer}
 * using this invariant factory as an argument.
 */
public interface InvariantComputerFactory {
    
    /**
     * Creates and returns an invariant computer for the parameter values
     * as stored with the given invariant factory.
     * @param invariantFactory Invariant factory with the same id as 
     * returned form {@link #getInvariantId}.
     */
    public InvariantComputer createInvariantComputer (InvariantFactory invariantFactory) 
        throws FactoryParameterException;
    
    /**
     * Return the universally unique identifier for this object. 
     * For most invariant 
     * computer factories this is the fully qualified class name
     * of the implementation class.
     */
    public String getId();
    
    /**
     * Return the version of this invariant computer factory.
     */
    public String getVersion ();
    
    /**
     * Return the generic identifier of the (parametrized) invariant which is
     * computed by this object.
     */
    public String getInvariantId();
}
