package com.ibm.bsf.util;

import java.io.*;

/**
 * An <code>IndentWriter</code> object behaves the same as a
 * <code>PrintWriter</code> object, with the additional capability
 * of being able to print strings that are prepended with a specified
 * amount of spaces.
 *
 * @author Matthew J. Duftler
 */
public class IndentWriter extends PrintWriter
{
  /**
   * Forwards its arguments to the <code>PrintWriter</code> constructor
   * with the same signature.
   */
  public IndentWriter(OutputStream out)
  {
    super(out);
  }

  /**
   * Forwards its arguments to the <code>PrintWriter</code> constructor
   * with the same signature.
   */
  public IndentWriter(OutputStream out, boolean autoFlush)
  {
    super(out, autoFlush);
  }

  /**
   * Forwards its arguments to the <code>PrintWriter</code> constructor
   * with the same signature.
   */
  public IndentWriter(Writer out)
  {
    super(out);
  }

  /**
   * Forwards its arguments to the <code>PrintWriter</code> constructor
   * with the same signature.
   */
  public IndentWriter(Writer out, boolean autoFlush)
  {
    super(out, autoFlush);
  }

  /**
   * Print the text (indented the specified amount) without inserting a linefeed.
   *
   * @param numberOfSpaces the number of spaces to indent the text.
   * @param text the text to print.
   */
  public void print(int numberOfSpaces, String text)
  {
    super.print(StringUtils.getChars(numberOfSpaces, ' ') + text);
  }

  /**
   * Print the text (indented the specified amount) and insert a linefeed.
   *
   * @param numberOfSpaces the number of spaces to indent the text.
   * @param text the text to print.
   */
  public void println(int numberOfSpaces, String text)
  {
    super.println(StringUtils.getChars(numberOfSpaces, ' ') + text);
  }
}