// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 * 	 
 *           Copyright 1995 Matthias Ettrich
 *           Copyright 1995-2000 The LyX Team.
 *
 * ====================================================== */

#ifndef TEXTUTILS_H
#define TEXTUTILS_H

#include <cctype>

///
#ifdef I18N
inline
bool IsNewlineChar(wchar_t c) {
#else
inline
bool IsNewlineChar(char c) {
#endif
	return (c == LyXParagraph::META_NEWLINE);
}


///
#ifdef I18N
inline
bool IsSeparatorChar(wchar_t c) {
#else
inline
bool IsSeparatorChar(char c) {
#endif
	return (c == ' ');
}


///
#ifdef I18N
inline
bool IsHfillChar(wchar_t c) {
#else
inline
bool IsHfillChar(char c) {
#endif
	return (c == LyXParagraph::META_HFILL);
}


///
#ifdef I18N
inline
bool IsInsetChar(wchar_t c) {
#else
inline
bool IsInsetChar(char c) {
#endif
	return (c == LyXParagraph::META_INSET);
}


#ifndef NEW_INSETS
///
#ifdef I18N
inline
bool IsFloatChar(wchar_t c) {
#else
inline
bool IsFloatChar(char c) {
#endif
	return (c == LyXParagraph::META_FOOTNOTE
		|| c == LyXParagraph::META_MARGIN
		|| c == LyXParagraph::META_FIG
		|| c == LyXParagraph::META_TAB
		|| c == LyXParagraph::META_ALGORITHM
		|| c == LyXParagraph::META_WIDE_FIG
		|| c == LyXParagraph::META_WIDE_TAB);
}
#endif


///
#ifdef I18N
inline bool IsLineSeparatorChar(wchar_t c) {
#else
inline
bool IsLineSeparatorChar(char c) {
#endif
	return (c == ' ');
}


///
#ifdef I18N
inline bool IsKommaChar(wchar_t c) {
#else
inline
bool IsKommaChar(char c) {
#endif
	return (c == ',' 
		|| c == '('
		|| c == ')'
		|| c == '['
		|| c == ']'
		|| c == '{'
		|| c == '}'
		|| c == ';'
		|| c == '.'
		|| c == ':'
		|| c == '-'
		|| c == '?'
		|| c == '!'
		|| c == '&'
		|| c == '@'
		|| c == '+'
		|| c == '-'
		|| c == '~'
		|| c == '#'
		|| c == '%'
		|| c == '^'
		|| c == '/' 
		|| c == '\\'
		|| c == LyXParagraph::META_NEWLINE
		);
}


///
#ifdef I18N
inline bool IsLetterChar(wchar_t c) {
#else
inline
bool IsLetterChar(unsigned char c) {
#endif
	return ((c >= 'A' && c <= 'Z')
		|| (c >= 'a' && c <= 'z')
		|| (c >= 192)); // in iso-8859-x these are accented chars
}


///
#ifdef I18N
inline bool IsPrintable(wchar_t c) {
#else
inline
bool IsPrintable(unsigned char c) {
#endif
	return (c >= ' ');
}


///
/*#ifdef I18N
inline
bool IsPrintableNonspace(unsigned wchar_t c) {
#else  */
inline
bool IsPrintableNonspace(unsigned char c) {
//#endif
	return (c > ' ');
}


/// Word is not IsSeparator or IsKomma or IsHfill or IsFloat or IsInset. 
/*#ifdef I18N
inline
bool IsWordChar(unsigned wchar_t c) {
#else     */
inline
bool IsWordChar(unsigned char c) {
//#endif
	return !( IsSeparatorChar( c )
		  || IsKommaChar( c )
		  || IsHfillChar( c )
#ifndef NEW_INSETS
		  || IsFloatChar( c )
#endif
		  || IsInsetChar( c ));
}


///
#ifdef I18N
inline
bool IsLetterCharOrDigit(wchar_t ch)
{
#else
inline
bool IsLetterCharOrDigit(char ch)
{
#endif
	return IsLetterChar(ch) || isdigit(ch);
}
#endif
