/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 * 	 
 *	    Copyright 1995 Matthias Ettrich
 *          Copyright 1995-2000 The LyX Team.
 *
 * ====================================================== */

#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "insetlabel.h"
#include "support/LOstream.h"
#include "lyx_gui_misc.h"     //askForText
#include "support/lstrings.h" //frontStrip, strip
#include "lyxtext.h"
#include "buffer.h"

using std::ostream;
using std::vector;
using std::pair;

/* Label. Used to insert a label automatically */


InsetLabel::InsetLabel(InsetCommandParams const & p)
	: InsetCommand(p)
{}


vector<string> const InsetLabel::getLabelList() const
{
	return vector<string>(1,getContents());
}


void InsetLabel::Edit(BufferView * bv, int, int, unsigned int)
{
	if (bv->buffer()->isReadonly()) {
		WarnReadonly(bv->buffer()->fileName());
		return;
	}

	pair<bool, string> result = askForText(_("Enter label:"), getContents());
	if (result.first) {
		string new_contents = frontStrip(strip(result.second));
		if (!new_contents.empty() &&
		    getContents() != new_contents) {
			bv->buffer()->markDirty();
			bool flag = bv->ChangeRefsIfUnique(getContents(),
							   new_contents);
			setContents(new_contents);
			bv->text->RedoParagraph(bv);
			if (flag) {
				bv->redraw();
				bv->fitCursor(getLyXText(bv));
			} else
				bv->update(BufferView::SELECT|BufferView::FITCUR|BufferView::CHANGE);
		}
	}
}


int InsetLabel::Latex(Buffer const *, ostream & os,
		      bool /*fragile*/, bool /*fs*/) const
{
	os << escape(getCommand());
	return 0;
}

int InsetLabel::Ascii(Buffer const *, ostream & os, int) const
{
	os << "<" << getContents()  << ">";
	return 0;
}


int InsetLabel::Linuxdoc(Buffer const *, ostream & os) const
{
	os << "<label id=\"" << getContents() << "\" >";
	return 0;
}


int InsetLabel::DocBook(Buffer const *, ostream & os) const
{
	os << "<anchor id=\"" << getContents() << "\" ></anchor>";
	return 0;
}


// This function escapes 8-bit characters and other problematic characters
// It's exactly the same code as in insetref.C.
string const InsetLabel::escape(string const & lab) const {
	char hexdigit[16] = { '0', '1', '2', '3', '4', '5', '6', '7',
			      '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
	string enc;
	for (string::size_type i= 0; i < lab.length(); ++i) {
		unsigned char c = lab[i];
		if (c >= 128 || c == '=' || c == '%') {
			enc += '=';
			enc += hexdigit[c >> 4];
			enc += hexdigit[c & 15];
		} else {
#ifdef I18N
			enc += (char)c;
#else		
			enc += c;
#endif			
		}
	}
	return enc;
}
