/*
    KSocrat
    Version 3.2.1, 17 July 2004
    (C) 2000-2004 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <klocale.h>
#include <qframe.h>
#include <qlayout.h>
#include "sconfigure.h"

void  SConfigure::initDialog(){
  QFrame *page = makeMainWidget();
  QVBoxLayout *bxDialog = new QVBoxLayout(page, 0, spacingHint());
  
  gbConfigure= new QGroupBox(page,"gbConfigure");
  gbConfigure->setTitle(i18n("Dictionary location"));
  gbConfigure->setColumnLayout(0, Qt::Vertical);
  bxDialog->addWidget(gbConfigure);

  QGridLayout *gdPaths = new QGridLayout(gbConfigure->layout());

  edEnRuPath= new QLineEdit(gbConfigure,"edEnRuPath");
  gdPaths->addWidget(edEnRuPath, 1, 0);

  btBrowse1= new QPushButton(gbConfigure,"btBrowse1");
  btBrowse1->setText(i18n("&Browse..."));
  gdPaths->addWidget(btBrowse1, 1, 1);

  lbEnRu= new QLabel(gbConfigure,"lbEnRu");
  lbEnRu->setText(i18n("English/Russian dictionary filename"));
  gdPaths->addWidget(lbEnRu, 0, 0);

  edRuEnPath= new QLineEdit(gbConfigure,"edRuEnPath");
  gdPaths->addWidget(edRuEnPath, 3, 0);

  btBrowse2= new QPushButton(gbConfigure,"btBrowse2");
  btBrowse2->setText(i18n("Bro&wse..."));
  gdPaths->addWidget(btBrowse2, 3, 1);

  lbRuEn= new QLabel(gbConfigure,"NoName");
  lbRuEn->setText(i18n("Russian/English dictionary filename"));
  gdPaths->addWidget(lbRuEn, 2, 0);

  QHBoxLayout *bxFontNHist = new QHBoxLayout(0, 0, spacingHint());
  bxDialog->addLayout(bxFontNHist);

  gbFont= new QGroupBox(2, Qt::Horizontal, page, "gbFont");
  gbFont->setTitle(i18n("Font"));
  bxFontNHist->addWidget(gbFont);

  lbFont= new QLabel(gbFont,"lbFont");
  lbFont->setText(i18n("Font for application interface"));

  btFont= new QPushButton(gbFont,"btFont");
  btFont->setText(i18n("&Font..."));

  bxDialog->addStretch(1);

  QHBoxLayout *bxMiscOptions = new QHBoxLayout(0, 0, spacingHint());
  bxDialog->addLayout(bxMiscOptions);
  
  cbHideOnStartUp= new QCheckBox(page,"cbHideonStartUp");
  cbHideOnStartUp->setText(i18n("Hide to system tray on start-up"));
  bxMiscOptions->addWidget(cbHideOnStartUp);

  btClrHist= new QPushButton(page,"btClrHist");
  btClrHist->setText(i18n("Clear history"));
  bxMiscOptions->addWidget(btClrHist);
}
