/***************************************************************************
                          pulsescreen.cpp  -  description
                             -------------------
    begin                : Sat Feb 2 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pulsescreen.h"

void PulseScreen::paintScreen(QPainter *p, QWidget *repaintTarget, paintHelpers *ph, const setiparse& s) {
	ph->clearScreen(p);
	ph->drawMainHeader(p,"Signal detected: Pulse");
	
	pls = s.getPulse();
	graph = plotPulse(pls);
	p->drawPixmap(10,85,graph);
	int pw = graph.width();
	p->flush();
  usleep(800000);

	QString qtmp;
	p->setFont(ph->mediumFont);
	p->setPen(ph->lcarsLila);
	ph->sound->playBeep1();
	p->drawText(pw+30,120,"Displaying signal characteristics");
	p->flush();

	p->setPen(ph->lcarsOrange);
	usleep(800000);
	qtmp.sprintf("Detected with a chirprate of %.3f Hz",pls.chirpRate);
	ph->sound->playBeep2();
	p->drawText(pw+30,150,qtmp);
	p->flush();

	usleep(400000);
	qtmp.sprintf("Signal strength: %.3f",pls.power);
	ph->sound->playBeep2();
	p->drawText(pw+30,175,qtmp);
	p->flush();

	usleep(400000);
	qtmp.sprintf("Pulse period: %.3f s",pls.period);
	ph->sound->playBeep2();
	p->drawText(pw+30,200,qtmp);
	p->flush();

  usleep(400000);
	qtmp.sprintf("Signal length: %d",pls.fftLen);
	ph->sound->playBeep2();
	p->drawText(pw+30,225,qtmp);
	p->flush();

	usleep(400000);
	qtmp = "Data segment ";
	qtmp = qtmp + s.getWu_name().c_str();
	qtmp = qtmp + " will be saved for further analysis.";
	ph->sound->playBeep2();
	p->drawText(10,340,qtmp);
	p->flush();

	
	usleep(800000);
	p->setFont(ph->headerfont);
	QFontMetrics fm(ph->headerfont);
	double art=pls.score/10;
	//qtmp.sprintf("Signal artificial with a probability of %.3f %%",art);
	qtmp.sprintf("Signal quality index is %.3f",art);
	int border = (1024- fm.width(qtmp))/2;
	ph->sound->playBeep2();
	p->drawText(border,650,qtmp,23);
	qtmp.sprintf("%.3f",art);
	int fromLeft = 1024-(border+fm.width(qtmp));
	for (int i = 0; i <= 12; i++) {
		if (i % 2 == 0) {
			p->setPen(ph->lcarsOrange);
			p->drawText( fromLeft,650,qtmp );
		}
		else {
			p->setPen(Qt::black);
			p->fillRect(fromLeft,600,1024-fromLeft,100,Qt::black);
		}
		p->flush();
		usleep(800000);
	}
}

QPixmap PulseScreen::plotPulse(Pulse p) {
    QPixmap tmp(p.dataLen,200);
		//cout << "datlen " << p.dataLen << endl;
		tmp.fill(Qt::black);

		double max = 0;
		for (int i = 0; i < p.dataLen; i++) {
     	if (p.data[i] > max) { max = p.data[i]; }
		}
		//cout << "Max is " << max << endl;		

		QColor redcol(255,0,0);
		QPainter pnt(&tmp);

		double factor = 199 / max;
		int prevHeight = (int) (p.data[0] * factor);
		int height;
		pnt.setPen(QPen(redcol));
		//cout << "Draw pulse" << endl;
		for (int i = 0; i < p.dataLen; i++) {
   		height = (int) (p.data[i]*factor);
			pnt.drawLine(i*1,199-prevHeight,i*1,199-height);
			pnt.drawLine(i*1,199-height,(i*1)+1,199-height);
			prevHeight=height;
		}
		return tmp;
}

