/***************************************************************************
                          painthelpers.cpp  -  description
                             -------------------
    begin                : Thu Jan 3 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "painthelpers.h"

#include <iostream>

#include "skymap.xpm"


paintHelpers::paintHelpers(const configuration *conf) {
	//init vars:
	lcarsOrange = QColor(220,200,0);
	lcarsLila = QColor(90,0,230);
	black = QColor(0,0,0);
	white = QColor(255,255,255);
	lgray = QColor(200,200,200);
	dgray = QColor(50,50,50);
	
	if (conf->isOverrideHead()) {
		headerfont = conf->getHeadF();
	}
	else {
		headerfont = QFont( "Helvetica", 32, QFont::Bold);
	}

	if (conf->isOverrideBig()) {
		mediumFont = conf->getBigF();
	}
	else {
		mediumFont = QFont( "Helvetica", 18);
	}

	if (conf->isOverrideSmall()) {
  	smallFont = conf->getSmallF();
	}	
	else {
		smallFont  = QFont( "Helvetica", 14);
  }
	sound = new SoundBox();
	
  skymap=QPixmap((const char**)skymap_xpm);
  cout << "heleo ";
}

paintHelpers::~paintHelpers() {
	delete sound;
}

void paintHelpers::drawMainHeader(QPainter *pr, QString head) {
	drawMainHeader(pr,head,lcarsOrange);
}

void paintHelpers::drawMainHeader(QPainter *pr, QString head, QColor col) {
	  pr->setPen(col);
    pr->setBrush(QBrush(col));
	  pr->setFont(headerfont);
    QFontMetrics Metrics=pr->fontMetrics();

	  pr->drawChord(0,0,35,35,4320,-2880);
		pr->fillRect(17,0,2,35,QBrush(col));

		int sw = Metrics.width(head);
		
    //25 --- 27
		pr->fillRect(27,0,1024-60-sw,35,QBrush(col));
		pr->drawText( 1024-25-sw, 30, head );
		
	  pr->fillRect(1005,0,2,35,QBrush(col));
    pr->drawChord(989,0,35,35,4320,2880);
		
}

void paintHelpers::drawBottomLine(QPainter *pr, QString bl) {
	  pr->setPen(lcarsOrange);
    pr->setBrush(QBrush(lcarsOrange));
	  pr->setFont(headerfont);
    QFontMetrics Metrics=pr->fontMetrics();


	  pr->drawChord(0,10,35,35,4320,-2880);
		pr->fillRect(17,10,2,35,QBrush(lcarsOrange));

		int sw = Metrics.width(bl);

		pr->fillRect(25,10,1024-35-45-sw,35,QBrush(lcarsOrange));		
		pr->drawText( 1024-45-sw, 30, bl );
		
	  pr->fillRect(1005,10,2,35,QBrush(lcarsOrange));
    pr->drawChord(989,10,35,35,4320,2880);
		
		//pr->fillRect(1024-50,10,40,40,QBrush(lcarsOrange));
}


void paintHelpers::drawSkymap(QPainter *pr) {
	//skymap=QPixmap((const char**)skymap_xpm);
	pr->drawPixmap(25,75,skymap);
}


/*  12.01.2002: replaced the C sprintf() function with QString::sprintf */
void paintHelpers::skymapData(int i, QPainter *p, setiparse *s) {
	QString tmp;
	p->setPen(QPen(lcarsOrange));
	if ( i > 20) { i-=20; }
	switch(i) {
  		case 2:
			p->setPen(QPen(lcarsLila));
			sound->playBeep1();
			p->drawText(10,620,QString("Declination ranges:"));
			break;	
		case 3:
			sound->playBeep2();
			p->drawText(10,645,DEC2String(s->getWu_StartDec())+" - "+DEC2String(s ->getWu_EndDec()));
			break;
		case 5:
			p->setPen(QPen(lcarsLila));
			sound->playBeep1();
			p->drawText(10,675,QString("Right ascension ranges:"));
			break;
		case 6:
			sound->playBeep2();
			p->drawText(10,700,RA2String(s->getWu_StartRa())+" - "+RA2String(s ->getWu_EndRa()));
			break;
  		case 8:
			p->setPen(QPen(lcarsLila));
			sound->playBeep1();
			p->drawText(10,730,QString("Scanning parameters"));
			break;	
		case 9:
			tmp.sprintf("Scanning with an angle rate of %.5f",s->getWu_AngleRange());
			sound->playBeep2();
			p->drawText(10,755,tmp);
			break;

//next line
		case 10:
			tmp.sprintf("Scanning with a sample rate of %.3f Hz",s->getWu_SubbandSampleRate());
			sound->playBeep2();
			p->drawText(512,620,QString(tmp));
			break;
		case 12:
			p->setPen(QPen(lcarsLila));
			sound->playBeep1();
			p->drawText(512,650,QString("Subband information:"));
			break;
		case 13:
			tmp.sprintf("Scanning subband number %.3d",s->getWu_SubbandNumber());
			sound->playBeep2();
			p->drawText(512,675,QString(tmp));
			break;
		case 14:
			tmp.sprintf("Subband base frequency: %.5f GHz",s->getWu_SubbandBase()/1e9);
			sound->playBeep2();
			p->drawText(512,700,QString(tmp));
			break;
  		case 15:
			tmp.sprintf("Subband center frequency: %.5f GHz",s->getWu_SubbandCenter()/1e9);
			sound->playBeep2();
			p->drawText(512,725,QString(tmp));
			break;
		case 20:
			p->fillRect(9,591,492,176,QBrush(black));
		 	p->fillRect(511,591,492,176,QBrush(black));
		 	break;
		default:
			break;
	}
}

/** Converts the RA Value (hours) to hh mm ss);
  * This is the convertRAToString(double ra) routine from
	* Gordon Machels Ksetiwatch.
*/
QString paintHelpers::RA2String(double ra) {
  int h, m, s;
	QString val;

	h = static_cast<int>(ra);
	m = static_cast<int>((ra - h)*60);
	s = static_cast<int>((ra - h)*3600 - m*60);
	val.sprintf("%2d hr %02d min %02d s", h, m, s);

	return(val);
}

/** Converts the DEC Value  to deg ' '');
  * This is the convertDecToString(double ra) routine from
	* Gordon Machels Ksetiwatch.
*/
QString paintHelpers::DEC2String(double dec)
{
	int d, m, s;
	QString val;

	d = static_cast<int>(dec);
	m = static_cast<int>((dec - d)*60);
	s = static_cast<int>((dec - d)*3600 - m*60);
	val.sprintf("%2d deg %02d' %02d''", d, m, s);

	return(val);
}

void paintHelpers::clearScreen(QPainter *pr) {
    pr->setPen(black);
    pr->fillRect(0,0,1024,768,QBrush(black));
}
