/*********************************************************************
 *
 *	Copyright (C) 1999 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * The program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Template Place, Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * PROJECT:      Utilities
 * MODULE:       IntHashtable Test
 * FILE:         TestIntHashtable.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name     Date           Description
 *      ----     ----           -----------
 *      NF       1/9/99         Initial version
 *
 * DESCRIPTION:
 *      Implements test-wrapper for the IntHashtable class.
 *
 ********************************************************************/

package com.bluemarsh.util.test;

import com.bluemarsh.util.IntHashtable;

/**
 * Test-wrapper for the IntHashtable class.
 *
 * @author  Nathan Fiedler
 * @version 1.0  1/9/99
 */
public class TestIntHashtable {

    /**
     * Main method, tests the IntHashtable class.
     *
     * @param  args  command-line string arguments
     */
    public static void main( String[] args ) {
        IntHashtable table = new IntHashtable();
        if ( table.isEmpty() ) {
            System.out.println( "Table is empty, good" );
        } else {
            System.out.println( "Table is not empty, bad" );
        }
        System.out.println( "Inserting elements from 0-99..." );
        for ( int i = 0; i < 100; i++ ) {
            table.put( i, new Integer( i ) );
        }
        if ( table.isEmpty() ) {
            System.out.println( "Table is empty, bad" );
        } else {
            System.out.println( "Table is not empty, good" );
        }
        System.out.println( "Table size = " + table.size() );
        System.out.println( "Retrieving all elements from 0-99..." );
        for ( int i = 0; i < 100; i++ ) {
            System.out.print( table.get( i ) + ", " );
        }
        System.out.println();
        System.out.println( "Removing every 5th element..." );
        for ( int i = 4; i < 100; i += 5 ) {
            table.remove( i );
        }
        System.out.println( "Table size = " + table.size() );
        System.out.println( "Retrieving all remaining elements..." );
        for ( int i = 0; i < 100; i++ ) {
            Object o = table.get( i );
            if ( o != null ) {
                System.out.print( o + ", " );
            }
        }
        System.out.println();
        if ( table.isEmpty() ) {
            System.out.println( "Table is empty, bad" );
        } else {
            System.out.println( "Table is not empty, good" );
        }
        IntHashtable clone = (IntHashtable)table.clone();
        System.out.println( "Retrieving all of clone's elements..." );
        for ( int i = 0; i < 100; i++ ) {
            Object o = table.get( i );
            if ( o != null ) {
                System.out.print( o + ", " );
            }
        }
        System.out.println();
        table.clear();
        clone.clear();
        if ( table.isEmpty() ) {
            System.out.println( "Table is empty, good" );
        } else {
            System.out.println( "Table is not empty, bad" );
        }
    } // main
} // TestIntHashtable
