/*********************************************************************
 *
 *	Copyright (C) 1999 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:     Utilities
 * MODULE:      Resource Pool Instantiator Interface
 * FILE:        ResourceInstantiator.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      10/22/99        Initial version
 *
 * DESCRIPTION:
 *      Defines the resource pool instantiator interface.
 *
 * $Id: ResourceInstantiator.java,v 1.2 2000/06/29 07:17:37 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util;

/**
 * Interface that defines the resource pool instantiator, used
 * when creating new resource objects in a resource pool.
 *
 * @author  Nathan Fiedler
 * @version 1.0  10/22/99
 * @see ResourcePool
 */
public interface ResourceInstantiator {

    /**
     * Instantiates and initializes a resource object.
     *
     * @return  Newly created and prepared resource object.
     */
    public Object instantiateResource();
} // ResourceInstantiator
