/* This file was generated by SableCC (http://www.sablecc.org/). */

package com.bluemarsh.jswat.parser.unicodepreprocessor.lexer;

import java.io.*;
import java.util.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.SUB; break;
                                case 1: state = State.SUB; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(int line, int pos) { return new TEvenBackslash(line, pos); }
    Token new1(String text, int line, int pos) { return new TUnicodeEscape(text, line, pos); }
    Token new2(String text, int line, int pos) { return new TErroneousEscape(text, line, pos); }
    Token new3(String text, int line, int pos) { return new TSub(text, line, pos); }
    Token new4(String text, int line, int pos) { return new TRawInputCharacter(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 25, 1}, {26, 26, 2}, {27, 91, 1}, {92, 92, 3}, {93, 65535, 1}, },
            {},
            {},
            {{92, 92, 4}, {117, 117, 5}, },
            {},
            {{48, 57, 6}, {65, 70, 7}, {97, 102, 8}, {117, 117, 5}, },
            {{48, 57, 9}, {65, 70, 10}, {97, 102, 11}, },
            {{48, 102, -8}, },
            {{48, 102, -8}, },
            {{48, 57, 12}, {65, 70, 13}, {97, 102, 14}, },
            {{48, 102, -11}, },
            {{48, 102, -11}, },
            {{48, 57, 15}, {65, 70, 16}, {97, 102, 17}, },
            {{48, 102, -14}, },
            {{48, 102, -14}, },
            {},
            {},
            {},
        }
        { // SUB
            {{0, 25, 1}, {26, 26, 2}, {27, 91, 1}, {92, 92, 3}, {93, 65535, 1}, },
            {},
            {},
            {{92, 92, 4}, {117, 117, 5}, },
            {},
            {{48, 57, 6}, {65, 70, 7}, {97, 102, 8}, {117, 117, 5}, },
            {{48, 57, 9}, {65, 70, 10}, {97, 102, 11}, },
            {{48, 102, -8}, },
            {{48, 102, -8}, },
            {{48, 57, 12}, {65, 70, 13}, {97, 102, 14}, },
            {{48, 102, -11}, },
            {{48, 102, -11}, },
            {{48, 57, 15}, {65, 70, 16}, {97, 102, 17}, },
            {{48, 102, -14}, },
            {{48, 102, -14}, },
            {},
            {},
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 4, 3, 4, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, },
        // SUB
        {-1, 4, 3, 4, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State SUB = new State(1);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
