/*********************************************************************
 *
 *      Copyright (C) 1999-2001 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      JSwat Requests
 * FILE:        LineNotFoundException.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      05/31/99        Initial version
 *      nf      08/15/01        Moved to breakpoint package
 *
 * DESCRIPTION:
 *      This file defines the exception for invalid line numbers.
 *
 ********************************************************************/

package com.bluemarsh.jswat.breakpoint;

/**
 * LineNotFoundException is thrown when the user gives an invalid
 * line number.
 *
 * @author  Nathan Fiedler
 */
public class LineNotFoundException extends Exception {

    /**
     * Constructs a LineNotFoundException with no message.
     */
    public LineNotFoundException() {
        super();
    } // LineNotFoundException

    /**
     * Constructs a LineNotFoundException with the given message.
     *
     * @param  s  Message.
     */
    public LineNotFoundException(String s) {
        super(s);
    } // LineNotFoundException
} // LineNotFoundException
