/*
 * Decompiled with CFR 0.152.
 */
package smr.JavaDeps;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import smr.JavaDeps.DepTable;
import smr.JavaDeps.Java;
import smr.JavaDeps.ParseException;
import smr.JavaDeps.TargetNode;
import smr.util.InvalidOptionException;
import smr.util.ParameterEnumeration;
import smr.util.ParseOptions;

public class JavaDeps {
    static String lineSeparator = System.getProperty("line.separator");
    static String version = "JavaDeps version 2.0.2";
    static String usage = "Usage: jdeps [options] [srcfile ... | -f file]" + lineSeparator + "For a list of options, use --help";
    static String copyright = "Copyright 1997,1998 Steve M. Robbins";
    static String bugs = "Please report bugs to <steve@nyongwa.montreal.qc.ca>";
    static String url = "http://www.cs.mcgill.ca/~stever/software/JavaDeps";
    static String buildCommand = "$(JAVACOMPILE)";
    static String headerBuildCommand = "$(JAVAHEADER)";
    static boolean buildStubs;
    static String classVariable;
    static String destDir;
    static boolean emitComments;
    static boolean noBuildCommands;
    static boolean beVerbose;
    static boolean enableDebugging;

    static void warning(String string) {
        System.err.println("JavaDeps warning: " + string);
    }

    static void fatalError(String string) {
        System.err.println(string);
        System.err.println();
        System.err.println(bugs);
        System.exit(1);
    }

    static void printVersion() {
        System.err.println(version);
        System.err.println(copyright);
        System.err.println("See " + url + " for updates.");
        System.err.println();
        System.err.println(bugs);
    }

    static void printHelp() {
        System.err.println(version);
        System.err.println(usage);
        System.err.println();
        System.err.println("  -b CMD, --build=CMD\tCommand used in build rules [" + buildCommand + "]");
        System.err.println("  -C VARNAME, --classvar=VARNAME");
        System.err.println("\t\t\tMakefile variable for classes [" + classVariable + "]");
        System.err.println("  -d DIR, --dir=DIR\tDirectory for class files");
        System.err.println("\t\t\tThis must be the same as in the javac command");
        System.err.println("  --debug\t\tEnable debugging");
        System.err.println("  -f FILE\t\tRead list of source files from FILE,");
        System.err.println("\t\t\trather than from the command line");
        System.err.println("  -h, --help\t\tShow this help text, then exit");
        System.err.println("  -n\t\t\tDo not emit build commands");
        System.err.println("  --native\t\tOutput commands to build header files");
        System.err.println("  --native=stubs\tOutput commands to build both headers and stubs");
        System.err.println("  --silent\t\tDo not emit comments");
        System.err.println("  -v, --verbose\t\tBe verbose");
        System.err.println("  --version\t\tShow version, then exit");
        System.err.println();
        System.err.println(bugs);
    }

    static void message(String string) {
        if (beVerbose) {
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        ParameterEnumeration parameterEnumeration;
        Object object3;
        ParseOptions parseOptions = null;
        String[] stringArray2 = new String[]{"debug", "help", "native", "silent", "version", "verbose"};
        String[] stringArray3 = new String[]{"build", "classvar", "dir"};
        try {
            parseOptions = new ParseOptions(stringArray, "hnv", "bCdf", stringArray2, stringArray3);
        }
        catch (InvalidOptionException invalidOptionException) {
            System.err.println(invalidOptionException.getMessage());
            System.exit(1);
        }
        enableDebugging = parseOptions.seenOption("debug");
        if (parseOptions.seenOption('h') || parseOptions.seenOption("help")) {
            JavaDeps.printHelp();
            System.exit(0);
        } else if (parseOptions.seenOption("version")) {
            JavaDeps.printVersion();
            System.exit(0);
        }
        noBuildCommands = parseOptions.seenOption('n');
        emitComments = !parseOptions.seenOption("silent");
        beVerbose = parseOptions.seenOption('v') || parseOptions.seenOption("verbose");
        buildCommand = parseOptions.getOptionArgument('b', buildCommand);
        buildCommand = parseOptions.getOptionArgument("build", buildCommand);
        if (parseOptions.seenOption("native")) {
            if ("stubs".equalsIgnoreCase(parseOptions.getOptionArgument("native"))) {
                buildStubs = true;
            }
        } else {
            headerBuildCommand = null;
        }
        classVariable = parseOptions.getOptionArgument('C', classVariable);
        classVariable = parseOptions.getOptionArgument("classvar", classVariable);
        destDir = parseOptions.getOptionArgument('d', destDir);
        destDir = parseOptions.getOptionArgument("dir", destDir);
        if (parseOptions.seenOption('f')) {
            try {
                object3 = new FileInputStream(parseOptions.getOptionArgument('f'));
                parameterEnumeration = new ParameterEnumeration((InputStream)object3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                parameterEnumeration = null;
                System.err.println(fileNotFoundException.getMessage());
                System.exit(1);
            }
        } else {
            parameterEnumeration = new ParameterEnumeration(parseOptions.getRemainingArgs());
        }
        if (!parameterEnumeration.hasMoreElements()) {
            JavaDeps.fatalError(usage);
        }
        if (noBuildCommands) {
            buildCommand = null;
        }
        object3 = new DepTable(destDir);
        Java java = null;
        boolean bl = true;
        while (parameterEnumeration.hasMoreElements()) {
            object2 = (String)parameterEnumeration.nextElement();
            JavaDeps.message("Processing file " + (String)object2);
            try {
                object = new FileInputStream((String)object2);
                ((DepTable)object3).startFile((String)object2);
                if (java == null) {
                    java = new Java((InputStream)object);
                    java.setTable((DepTable)object3);
                } else {
                    Java.ReInit((InputStream)object);
                }
                Java.CompilationUnit();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Can not find file: " + (String)object2);
                bl = false;
            }
            catch (ParseException parseException) {
                System.err.println("Parse error in file " + (String)object2 + ":");
                System.err.println(parseException.getMessage());
                bl = false;
            }
            System.runFinalization();
            System.gc();
        }
        if (bl) {
            Object object4;
            JavaDeps.message("Successful parse; writing output");
            object2 = ((DepTable)object3).g.getComponents();
            while (object2.hasMoreElements()) {
                object = (Vector)object2.nextElement();
                if (((Vector)object).size() == 1) {
                    JavaDeps.emitSimpleBuildRule((TargetNode)((Vector)object).firstElement());
                    continue;
                }
                JavaDeps.emitCompoundBuildRule((Vector)object);
            }
            System.out.print(String.valueOf(classVariable) + " =");
            object = ((DepTable)object3).g.nodes();
            while (object.hasMoreElements()) {
                object4 = (TargetNode)object.nextElement();
                if (((TargetNode)object4).type != 3) continue;
                System.out.print(" \\" + lineSeparator + "\t" + ((TargetNode)object4).targetName);
            }
            System.out.println();
            if (headerBuildCommand != null) {
                System.out.println("HEADERS =");
                object4 = ((DepTable)object3).g.nodes();
                while (object4.hasMoreElements()) {
                    TargetNode targetNode = (TargetNode)object4.nextElement();
                    if (targetNode.type != 4 && targetNode.type != 5) continue;
                    System.out.print(" \\" + lineSeparator + "\t" + targetNode.targetName);
                }
                System.out.println();
                return;
            }
        } else {
            System.err.println("Errors encountered; no output");
        }
    }

    static void emitRule(String string, String string2, String string3, String string4) {
        System.out.println(String.valueOf(string) + ": " + string2);
        if (string3 != null) {
            System.out.println("\t" + string3 + " " + string4);
        }
        System.out.println();
    }

    static void emitSimpleBuildRule(TargetNode targetNode) {
        switch (targetNode.type) {
            case 3: {
                String string = targetNode.neighbours(2);
                String string2 = targetNode.neighbours(3);
                JavaDeps.emitRule(targetNode.targetName, string, buildCommand, string);
                if (string2.equals("")) break;
                JavaDeps.emitRule(targetNode.targetName, string2, null, null);
                return;
            }
            case 4: {
                String string = targetNode.neighbours(3);
                int n = targetNode.targetName.indexOf(46);
                String string3 = targetNode.targetName.substring(0, n).replace('_', '.');
                JavaDeps.emitRule(targetNode.targetName, string, headerBuildCommand, string3);
                return;
            }
            case 5: {
                if (!buildStubs) break;
                String string = targetNode.neighbours(3);
                int n = targetNode.targetName.indexOf(46);
                String string4 = targetNode.targetName.substring(0, n).replace('_', '.');
                JavaDeps.emitRule(targetNode.targetName, string, String.valueOf(headerBuildCommand) + " -stubs", string4);
                return;
            }
            default: {
                JavaDeps.warning("uknown node in dependency graph");
            }
            case 1: 
            case 2: 
        }
    }

    static void emitCompoundBuildRule(Vector vector) {
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = "";
        String string2 = "";
        String string3 = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (TargetNode)enumeration.nextElement();
            hashtable.put(((TargetNode)object).targetName, object);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            TargetNode targetNode = (TargetNode)object.nextElement();
            if (targetNode.type != 3) {
                JavaDeps.warning("non-CLASS node in compound rule");
                continue;
            }
            string = String.valueOf(string) + targetNode.targetName + " ";
            Enumeration enumeration2 = targetNode.neighbours();
            while (enumeration2.hasMoreElements()) {
                TargetNode targetNode2 = (TargetNode)enumeration2.nextElement();
                if (targetNode2.targetName == null || hashtable.get(targetNode2.targetName) != null) continue;
                hashtable.put(targetNode2.targetName, targetNode2);
                if (targetNode2.type == 2) {
                    string2 = String.valueOf(string2) + targetNode2.targetName + " ";
                    continue;
                }
                if (targetNode2.type != 3) continue;
                string3 = String.valueOf(string3) + targetNode2.targetName + " ";
            }
        }
        JavaDeps.emitRule(string, string2, buildCommand, string2);
        if (!string3.equals("")) {
            JavaDeps.emitRule(string, string3, null, null);
        }
    }

    static {
        classVariable = "CLASSES";
        destDir = null;
        emitComments = true;
    }
}

