/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Protocol;

public class ObjectStore
implements Protocol {
    final Application app;
    private Map objectMap;
    private long maximumLimit = 8L;
    private boolean requestPending = false;

    public ObjectStore(Application application) {
        this.app = application;
        this.objectMap = new HashMap();
    }

    public void put(ObjectReference objectReference) {
        long l;
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            this.objectMap.put(new Long(objectReference.uniqueID()), objectReference);
            l = this.objectMap.size();
        }
        if (l > this.maximumLimit && !this.requestPending) {
            this.app.signal("report-ids-in-use", null);
            this.requestPending = true;
        }
    }

    public void trim(List list) {
        Object object;
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Long)iterator.next();
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                if (this.objectMap.containsKey(object)) {
                    hashMap.put(object, this.objectMap.get(object));
                }
            }
        }
        this.maximumLimit = 2 * hashMap.size();
        object = this;
        synchronized (object) {
            this.objectMap = hashMap;
        }
        this.requestPending = false;
    }

    public ObjectReference get(Object object) {
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            ObjectReference objectReference = (ObjectReference)this.objectMap.get(object);
            return objectReference;
        }
    }
}

