/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.pdfbox.pdmodel.encryption.PublicKeyRecipient;

public class EncryptPKI {
    public static void main(String[] args) throws Exception {
        EncryptPKI e = new EncryptPKI();
        e.encrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encrypt(String[] args) throws Exception {
        if (args.length < 1) {
            EncryptPKI.usage();
        } else {
            AccessPermission ap = new AccessPermission();
            String infile = null;
            String outfile = null;
            String certfile = null;
            int keyLength = 48;
            PDDocument document = null;
            try {
                for (int i = 0; i < args.length; ++i) {
                    String key = args[i];
                    if (key.equals("-canAssemble")) {
                        ap.setCanAssembleDocument(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canExtractContent")) {
                        ap.setCanExtractContent(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canExtractForAccessibility")) {
                        ap.setCanExtractForAccessibility(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canFillInForm")) {
                        ap.setCanFillInForm(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canModify")) {
                        ap.setCanModify(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canModifyAnnotations")) {
                        ap.setCanModifyAnnotations(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canPrint")) {
                        ap.setCanPrint(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-canPrintDegraded")) {
                        ap.setCanPrintDegraded(args[++i].equalsIgnoreCase("true"));
                        continue;
                    }
                    if (key.equals("-keyLength")) {
                        try {
                            keyLength = Integer.parseInt(args[++i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new NumberFormatException("Error: -keyLength is not an integer '" + args[i] + "'");
                        }
                    }
                    if (infile == null) {
                        infile = key;
                        continue;
                    }
                    if (certfile == null) {
                        certfile = key;
                        continue;
                    }
                    if (outfile == null) {
                        outfile = key;
                        continue;
                    }
                    EncryptPKI.usage();
                }
                if (infile == null) {
                    EncryptPKI.usage();
                }
                if (certfile == null) {
                    EncryptPKI.usage();
                }
                if (outfile == null) {
                    outfile = infile;
                }
                if (!(document = PDDocument.load(infile)).isEncrypted()) {
                    PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
                    PublicKeyRecipient recip = new PublicKeyRecipient();
                    recip.setPermission(ap);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    FileInputStream inStream = new FileInputStream(certfile);
                    X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                    ((InputStream)inStream).close();
                    recip.setX509(certificate);
                    ppp.addRecipient(recip);
                    ppp.setEncryptionKeyLength(keyLength);
                    document.protect(ppp);
                    document.save(outfile);
                } else {
                    System.err.println("Error: Document is already encrypted.");
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java org.pdfbox.EncryptPKI [options] <inputfile> <certfile> [outputfile]");
        System.err.println("   -canAssemble <true|false>                Set the assemble permission");
        System.err.println("   -canExtractContent <true|false>          Set the extraction permission");
        System.err.println("   -canExtractForAccessibility <true|false> Set the extraction permission");
        System.err.println("   -canFillInForm <true|false>              Set the fill in form permission");
        System.err.println("   -canModify <true|false>                  Set the modify permission");
        System.err.println("   -canModifyAnnotations <true|false>       Set the modify annots permission");
        System.err.println("   -canPrint <true|false>                   Set the print permission");
        System.err.println("   -canPrintDegraded <true|false>           Set the print degraded permission");
        System.err.println("   -keyLength <length>                      The length of the key in bits(40)");
        System.err.println("\nNote: By default all permissions are set to true!");
        System.exit(1);
    }
}

