/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DFAOptimizer {
    public static boolean PRUNE_EBNF_EXIT_BRANCHES = true;
    public static boolean PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES = true;
    public static boolean COLLAPSE_ALL_PARALLEL_EDGES = true;
    public static boolean MERGE_STOP_STATES = true;
    protected Set visited;
    protected Grammar grammar;

    public void optimize() {
        int decisionNumber = 1;
        while (decisionNumber <= this.grammar.getNumberOfDecisions()) {
            DFA dfa = this.grammar.getLookaheadDFA(decisionNumber);
            this.optimize(dfa);
            ++decisionNumber;
        }
    }

    protected void optimize(DFA dfa) {
        if (dfa == null) {
            return;
        }
        if (PRUNE_EBNF_EXIT_BRANCHES) {
            this.visited.clear();
            int decisionType = dfa.getNFADecisionStartState().decisionStateType;
            if (dfa.isGreedy() && !dfa.isCyclic() && (decisionType == 3 || decisionType == 1)) {
                this.optimizeExitBranches(dfa.startState);
            }
        }
        if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && dfa.isTokensRuleDecision() && dfa.probe.stateToSyntacticallyAmbiguousTokensRuleAltsMap.size() > 0) {
            this.visited.clear();
            this.optimizeEOTBranches(dfa.startState);
        }
    }

    protected void optimizeExitBranches(DFAState d) {
        Integer sI = Utils.integer(d.stateNumber);
        if (this.visited.contains(sI)) {
            return;
        }
        this.visited.add(sI);
        int nAlts = d.dfa.getNumberOfAlts();
        int i = 0;
        while (i < d.getNumberOfTransitions()) {
            Transition edge = d.transition(i);
            DFAState edgeTarget = (DFAState)edge.target;
            if (edgeTarget.isAcceptState() && edgeTarget.getUniquelyPredictedAlt() == nAlts) {
                d.removeTransition(i);
                --i;
            }
            this.optimizeExitBranches(edgeTarget);
            ++i;
        }
    }

    protected void optimizeEOTBranches(DFAState d) {
        Integer sI = Utils.integer(d.stateNumber);
        if (this.visited.contains(sI)) {
            return;
        }
        this.visited.add(sI);
        int i = 0;
        while (i < d.getNumberOfTransitions()) {
            Transition edge = d.transition(i);
            DFAState edgeTarget = (DFAState)edge.target;
            if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && edgeTarget.isAcceptState() && d.getNumberOfTransitions() == 1 && edge.label.isAtom() && edge.label.getAtom() == -2) {
                d.removeTransition(i);
                d.setAcceptState(true);
                d.cachedUniquelyPredicatedAlt = edgeTarget.getUniquelyPredictedAlt();
                --i;
            }
            this.optimizeEOTBranches(edgeTarget);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.visited = new HashSet();
    }

    public DFAOptimizer(Grammar grammar) {
        this.this();
        this.grammar = grammar;
    }
}

