/*
 * HPTalx
 * A PC<->HP48/49 communication program for Linux
 *
 * (C) 1999, 2000 by Bruno Barberi Gnecco
 *
 * rev 0.1:	Initial testing
 * rev 0.1.1:	Fixed some bugs
 * 		finished most commands
 *		Added preferences file
 * rev 0.2:	Fixed change_dir bug
 *		Improved preferences
 *		Added file editor support
 *		Added backup/restore memory
 *		Added rom update (49)
 * rev 1.0:	Added progress window in transfer
 *		Corrections due to pseudo terminals
 *		File type is now set in clist_data
 *		Fixed backup and restore
 *		Multiple file selection support
 *		Added un/select all
 * rev 1.0.1:	Fixed ls bug in refresh()
 *		Fixed port setup bug in setup()
 *		Fixed cancel transfer
 *		Fixed delete many files
 *		Fixed hp dir change in FILES
 *		Added timeout when connecting
 *		Fixed translation after transfer
 * rev 1.1.0:	Fixes to the "Unknown calc" bug
 *		Fixed backup bug
 *		Added unpack
 *		Added xmodem support


    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
/* missing:
- XMODEM in directories
- send_packet() check
*/
 
#include "hptalx.h"
#ifdef UPDATE_ROM
#include "hp49flash-0.2.4/upgrade_lib.h"
#endif
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <ctype.h>

#define BUFFERSIZE		256

Pref newpref;
Pref preferences;

void clear_kinput ( void ) {
	char c;
	while ( read( fileno(kermit), &c, 1 ) != -1 ) ;
}

static const char *k_transfer_file_switches[] = { "", "/BINARY", "/TEXT" };
static const char *x_transfer_file_switches[] = { " ", "-b", "-a" };
static int stoptransfer;
static void cancel_transfer ( GtkWidget *w, gpointer data ) {
	if ( preferences.protocol == KERMIT )
		fputc( 'Z', kermit );
	stoptransfer = 1;
}

void transfer ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE], status[BUFFERSIZE], *t;
	GtkWidget *dialog;
	GtkWidget *filelabel;
	GtkWidget *infolabel;
	GtkWidget *bar;
	GtkWidget *button;
	GtkCList *clist;
	GList *list;
	GtkAdjustment *adj;
	int f;

	if ( connected == OFFLINE )
		return;

	if ( preferences.protocol == KERMIT ) {
		clear_kinput();
		fprintf( kermit, "REMOTE HOST 3 TRANSIO\n" );
		wait_prompt();
	}
	else
		send_packet("E", "3 TRANSIO");

	set_status( "Transfering files..." );
	stoptransfer = 0;

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), "Uploading...");
	gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	/* filename */
	filelabel = gtk_label_new("Transfering:");
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), filelabel,
			FALSE, FALSE, 10);
	gtk_widget_show(filelabel);
	filelabel = gtk_label_new("file");
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), filelabel,
			FALSE, FALSE, 10);
	gtk_widget_show(filelabel);
	
	adj = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	bar = gtk_progress_bar_new_with_adjustment(adj);
	gtk_progress_set_format_string( GTK_PROGRESS(bar), "%p%% complete" );
	gtk_progress_set_show_text( GTK_PROGRESS(bar), TRUE );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), bar,
			FALSE, FALSE, 10);
	gtk_widget_show(bar);

	/* show status */
	infolabel = gtk_label_new("0% complete\n0 bytes sent\n0 CPS");
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), infolabel,
			FALSE, FALSE, 10);
	gtk_widget_show(infolabel);

	/* this will KILL the app. that's not the way to go, but, by now... */
	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(cancel_transfer), NULL);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
	gtk_box_pack_end(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_show(dialog);

	clist = ( whereami == PC ? GTK_CLIST(files_pc) : GTK_CLIST(files_hp) );
	for ( list = clist->selection; list; list = list->next ) {
		char filename[BUFFERSIZE];
		gtk_clist_get_text( clist, GPOINTER_TO_INT(list->data), 1, &t );
		if ( whereami == PC && GPOINTER_TO_INT(data) == 0 ) {
			if ( !strcmp( "Directory", (char *)gtk_clist_get_row_data(
					GTK_CLIST(files_pc), GPOINTER_TO_INT(list->data))) )
				continue;
			if ( preferences.protocol == KERMIT )
				fprintf( kermit, "send %s %s/%s\n", k_transfer_file_switches[ttype], 
						data_pc.current, t ); 
			else
				send_packet("P", t);
		}
		else if ( GPOINTER_TO_INT(data) == 0 ) {
			if ( preferences.protocol == KERMIT ) 
				fprintf( kermit, "get %s %s\n", k_transfer_file_switches[ttype], t );
			else
				send_packet("G", t);
		}

		gtk_label_set_text(GTK_LABEL(filelabel), t );

		if ( GPOINTER_TO_INT(data) == 0 ) { /* we want kermit transfer */
			/* read 'garbage' */
			do { 
				fgets( temp, BUFFERSIZE-1, kermit );
			} while ( !strstr( temp, "Length" ) );

			while (gtk_events_pending())
				gtk_main_iteration();

			fgets( temp, BUFFERSIZE-1, kermit );
			do {
				int bytes, percent, cps, plength;
			
				if ( stoptransfer == 1 )
					goto end;

				/* I think that if you are in a very slow computer
				the gtk_main_int may be slower than the comm and crash.
				But in programming heaven we all use Crays. */
				sscanf( temp, "%d%d%%%d%d", &bytes, &percent, &cps, &plength );
				if ( whereami == PC )
					gtk_progress_bar_update(GTK_PROGRESS_BAR(bar), 
							((float)percent)/100.0 );
				else {
					char *size;
					gtk_clist_get_text(GTK_CLIST(files_hp), 
							data_hp.last_file_row, 2, &size);
					gtk_progress_bar_update(GTK_PROGRESS_BAR(bar), 
						((float)bytes)/atof(size));
					percent = (int)(100.0*(float)bytes)/atof(size);
				}

				sprintf(status, "%d bytes sent\n%d CPS", bytes, cps );
				gtk_label_set_text(GTK_LABEL(infolabel), status);
				while (gtk_events_pending())
					gtk_main_iteration();

				while ( fgets( temp, BUFFERSIZE-1, kermit ) == NULL ) ;
			} while ( !strstr( temp, "[OK]" ) );
			wait_prompt();
		}
		else {
#ifdef decent_way
			int filed[2];
			
			if ( pipe(filed) ) {
				message_box( "Error", "In transfer: could not pipe!\n"
						"File not transferred");
				return;
			}
				
			if ( (f = fork()) == -1 ) {
				message_box( "Error", "In transfer: could not fork!\n"
						"File not transferred");
				return;
			}
			if ( f == 0 ) { 
				char device[15];
				int output[2];

				sprintf( device, "/dev/ttyS%d", preferences.port);
				if ( (output[0] = open( device, O_RDONLY )) < 0 ||
				     (output[1] = open( device, O_WRONLY )) < 0 ) {
					message_box( "Error", "Cannot open COM port.");
					_exit( EXIT_FAILURE );
				}

				close(STDERR_FILENO);
				dup(filed[1]);
				close(STDIN_FILENO);
				dup(output[0]);
				close(STDOUT_FILENO);
				dup(output[1]);

				setvbuf( stderr, NULL, _IONBF, 0 );
				
				if ( whereami == PC ) {
					if ( execlp("lsx", "lsx", x_transfer_file_switches[ttype], t, NULL) == -1 ) {
						message_box("Error", "Couldn't run lsx.\n"
							"Make sure you have it installed\n"
							"and it's in your path" );
					}
				}
				else {
					if ( execlp("lrx", "lrx", x_transfer_file_switches[ttype], t, NULL) == -1 ) {
						message_box("Error", "Couldn't run lrx.\n"
							"Make sure you have it installed\n"
							"and it's in your path" );
					}
				}
				_exit( EXIT_FAILURE );

			}
			else { /* parent */
				FILE *transfer;
				int packets, bytes;

				transfer = fdopen(filed[0], "r");

				if ( whereami == PC ) 
				do {
					fgets( temp, BUFFERSIZE-1, transfer );
					if ( strstr( temp, "sent" ) ) {
						if ( !(t = strchr( temp, ':' )) )
							continue;
						sscanf( t, "%d/%d", &packets, &bytes );

						sprintf(status, "%d kbytes sent\n", bytes );
						gtk_label_set_text(GTK_LABEL(infolabel), status);
					}
				} while ( !strstr( temp, "complete" ) && stoptransfer == 0 );
				
				else
				do {
					fgets( temp, BUFFERSIZE-1, transfer );
					if ( strstr( temp, "received" ) ) {
						if ( !(t = strchr( temp, ':' )) )
							continue;
						sscanf( t, "%d/%d", &packets, &bytes );

						sprintf(status, "%d kbytes sent\n", bytes );
						gtk_label_set_text(GTK_LABEL(infolabel), status);

					}
				} while ( !strstr( temp, "complete" ) && stoptransfer == 0 );
				
				if ( stoptransfer == 1 )
					kill( f, SIGINT );

				fclose( transfer );
			}
#else
			if ( fork() == 0 ) {
				if ( whereami == PC ) {
					if ( execlp("lsx", "lsx", x_transfer_file_switches[ttype], t, NULL) == -1 ) {
						message_box("Error", "Couldn't run lsx.\n"
							"Make sure you have it installed\n"
							"and it's in your path" );
					}
				}
				else {
					if ( execlp("lrx", "lrx", x_transfer_file_switches[ttype], t, NULL) == -1 ) {
						message_box("Error", "Couldn't run lrx.\n"
							"Make sure you have it installed\n"
							"and it's in your path" );
					}
				}
				_exit( EXIT_FAILURE );
			}
			else
				set_status("sending file");
#endif
		}
	}
end:
	if ( preferences.protocol == KERMIT )  {
		clear_kinput();
		fprintf( kermit, "REMOTE HOST 0 TRANSIO\n" );
		wait_prompt();
	} else
		send_packet( "E", "0 TRANSIO" );

	gtk_widget_destroy( dialog );
	refresh( w, GINT_TO_POINTER(BOTH) );
}

void move ( GtkWidget *w, gpointer data ) {
	if ( connected == OFFLINE )
		return;

	set_status( "Moving file..." );
	transfer( w, data );
	delete( w, data );
	set_status( "Done" );
	refresh( w, GINT_TO_POINTER(BOTH) );
}

void edit ( GtkWidget *w, gpointer data ) {
	pid_t pid;

	if ( whereami != PC ) {
		message_box("Error", "HP files can't be edited");
		return;
	}

	pid = fork();
	if ( pid == 0 ) {
		char temp[BUFFERSIZE];
		sprintf( temp, "%s/%s", data_pc.current, data_pc.filename );
		execlp( preferences.editor, preferences.editor, temp, NULL);
		_exit( EXIT_FAILURE );
	}
	else if ( pid < 0 )
		message_box( "Error", "Could not fork()." );
	else
		return;
}


void copy ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE];
	char *newname =	entry_popup( "Copy", "Destination directory and filename:\n " );

	if ( !newname )
		return;
	
	if ( whereami == PC ) {
		if ( !data_pc.filename )
			return;
		clear_kinput();
		fprintf( kermit, "copy %s %s\n", data_pc.filename, newname );
		fgets( temp, BUFFERSIZE-1, kermit );
		/* check if error. This can be avoided by using a file selector
		instead of this 'type here' */
		if ( strstr( temp, "Not found" ) ) {
			message_box( "Error", "Could not copy file." );
			while ( getchar() != '\a' )
				putchar( '\b' );
		}
	}
	else {
		if ( !data_hp.filename )
			return;
		/* FIXME: add error checking! */
		if ( preferences.protocol == KERMIT )
			fprintf( kermit, "REMOTE HOST %s %s OVER RCL SWAP EVAL SWAP STO\n",
				data_hp.filename, newname );
		else {
			sprintf( temp, "%s %s OVER RCL SWAP EVAL SWAP STO",
				data_hp.filename, newname );
			send_packet( "E", temp );
		}
	}

	refresh( w, GINT_TO_POINTER(whereami) );
}

void renamew ( GtkWidget *w, gpointer data ) {
	char *newname =	entry_popup( "Rename", "Type new filename: " );
	char temp[BUFFERSIZE];

	if ( !newname ) 
		return;

	if ( whereami == PC ) {
		if ( !data_pc.filename )
			return;
		fprintf( kermit, "rename %s %s\n", data_pc.filename, newname );
	}
	else {
		if ( !data_hp.filename )
			return;
		/* FIXME: add error checking! */
		if ( preferences.protocol == KERMIT )
			fprintf( kermit, "REMOTE HOST %s %s OVER RCL SWAP EVAL SWAP STO\n",
				data_hp.filename, newname );
		else {
			sprintf( temp, "REMOTE HOST %s %s OVER DUP RCL SWAP PURGE SWAP STO DROP",
				data_hp.filename, newname );
			send_packet( "E", temp );
		}
	}
	refresh( w, GINT_TO_POINTER(whereami) );
	free( newname );
}

void unpack ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE];

	if ( !data_pc.filename || whereami != PC )
		return;

	if ( strstr( data_pc.filename, ".zip" ) || 
	     strstr( data_pc.filename, ".ZIP" ) ) {
		sprintf( temp, "cd %s; unzip %s", data_pc.current, data_pc.filename );
		system( temp );
	}
	else if ( strstr( data_pc.filename, ".tgz" ) || 
		  strstr( data_pc.filename, ".TGZ" ) || 
		  strstr( data_pc.filename, ".tar.gz" ) || 
		  strstr( data_pc.filename, ".TAR.GZ" ) ) {
		sprintf( temp, "cd %s; tar zxvf %s", data_pc.current, data_pc.filename );
		system( temp );
	}
	else if ( strstr( data_pc.filename, ".tar.bz2" ) || 
		  strstr( data_pc.filename, ".TAR.BZ2" ) ) {
		sprintf( temp, "cd %s; tar yxvf %s", data_pc.current, data_pc.filename );
		system( temp );
	}
	else {
		set_status( "Unknown format" );
		return;
	}
	set_status( "Unpack successful" );
	refresh( w, GINT_TO_POINTER(PC) );
}


void delete ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE], *t;
	int remove;
	GtkCList *clist;
	GList *list;

	if ( panel == DIRS ) {
		remove_dir( w, data );
		return;
	}
	if ( whereami == PC ) {
		if ( !data_pc.filename )
			return;
	} 
	else
		if ( !data_hp.filename )
			return;
	
	clist = ( whereami == PC ? GTK_CLIST(files_pc) : GTK_CLIST(files_hp) );
	clear_kinput();
	for ( list = clist->selection; list; list = list->next ) {
		gtk_clist_get_text( clist, GPOINTER_TO_INT(list->data), 1, &t );

		sprintf( temp, "REALLY delete?\n%s", t );
		if ( preferences.delete_confirm != FALSE ) {
			remove = confirm( "Delete file", temp );
			if ( remove == CANCEL )
				continue;
		}
		
		if ( whereami == PC ) {
			fprintf( kermit, "delete %s\n", (char *)gtk_clist_get_row_data(
					GTK_CLIST(files_pc), GPOINTER_TO_INT(list->data)));
		}
		else {
			if ( preferences.protocol == KERMIT ) {
				clear_kinput();
				fprintf( kermit, "REMOTE HOST { %s } PURGE\n", data_hp.filename );
				wait_prompt();
			}
			else {
				sprintf( temp, "{ %s } PURGE", data_hp.filename );
				send_packet( "E", temp );
			}
		}
	}
	refresh( w, GINT_TO_POINTER(whereami) );
}

void select_all ( GtkWidget *w, gpointer data ) {
	gtk_clist_select_all(GTK_CLIST( whereami == PC ? files_pc : files_hp ));
}

void unselect_all ( GtkWidget *w, gpointer data ) {
	gtk_clist_select_all(GTK_CLIST( whereami == PC ? files_pc : files_hp ));
}

void choose_dir ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE];
	char *newdir = entry_popup( "Choose", "Type new directory.\n"
			"HP dir format: { HOME DIR SUBDIR }\n" );
	
	if ( !newdir )
		return;

	if ( (VPANED)GPOINTER_TO_INT(data) == PC ) {
		if ( chdir( newdir ) != 0 ) {
			message_box( "Not found", "The directory you typed\n"
				"either do not exist or\n"
				"can't be acessed." );
			return;
		}
		free( data_pc.current );
		data_pc.current = getcwd( NULL, 0 );
	}
	else if ( (VPANED)GPOINTER_TO_INT(data) == HP && 
			preferences.protocol == KERMIT ) {
		clear_kinput();
		fprintf( kermit, "REMOTE HOST %s EVAL\n", newdir );
		fgets( temp, BUFFERSIZE-1, kermit );
/* the error message is probably wrong */
		if ( strstr( temp, "No directories" ) ) {
			message_box( "Not found", "The directory you typed\n"
					"either do not exist or\n"
					"can't be acessed." );
			printf( "\n" ); /* as kermit leaves cd */
			return;
		}
	}
	else if ( (VPANED)GPOINTER_TO_INT(data) == HP && 
			preferences.protocol == XMODEM ) {
		sprintf( temp, "%s EVAL", newdir );
		send_packet( "E", temp );
		
/*** error checking */
	}
	refresh( w, GINT_TO_POINTER(data) );
}


void change_dir ( GtkWidget *w, gpointer data ) {
	if ( whereami == PC ) {
		if ( panel == FILES ) {
			if ( strcmp( "Directory", (char *)gtk_clist_get_row_data(
					GTK_CLIST(files_pc), data_pc.last_file_row ) ) )
				return;
		}
		chdir( panel == FILES ? data_pc.filename : data_pc.dir );
		free( data_pc.current );
		data_pc.current = getcwd( NULL, 0 );
	}
	else {
		if ( panel == FILES ) {
			if ( strcmp( "Directory", (char *)gtk_clist_get_row_data(
					GTK_CLIST(files_hp), data_hp.last_file_row ) ) )
				return;
		}
		if ( strstr( data_hp.dir, ".." ) && panel == DIRS ) {
			char *t;
			t = strchr( data_hp.current, '}' ) - 1;
			while ( isspace( *t ) ) t--;
			while ( !isspace( *t ) ) t--;
			*t++ = '}';
			*t = '\0';
			if ( preferences.protocol == KERMIT )
				fprintf( kermit, "remote host %s EVAL\n", data_hp.current );
			else {
				char temp[BUFFERSIZE];
				sprintf( temp, "%s EVAL", data_hp.current );
				send_packet( "E", temp );
			} 
		}
		else {
			char *t;
			t = strchr( data_hp.current, '}' );
			*t = '\0';
			if ( preferences.protocol == KERMIT )
				fprintf( kermit, "remote host %s %s } EVAL\n", data_hp.current,
					( panel == FILES ? data_hp.filename : data_hp.dir ) );
			else {
				char temp[BUFFERSIZE];
				sprintf( temp, "%s %s } EVAL", data_hp.current,
					( panel == FILES ? data_hp.filename : data_hp.dir ) );
				send_packet( "E", temp );
			}
		}
	}
	refresh( w, GINT_TO_POINTER(whereami) );
}

void create_dir ( GtkWidget *w, gpointer data ) {
	char *newdir = entry_popup("Create directory", "Type new directory name: " );
	
	if ( !newdir )
		return;

	if ( whereami == PC ) {
		if ( mkdir( newdir, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH ) != 0 )
			message_box( "Error", "Error creating directory" ); 
	}
	else {
		if ( preferences.protocol == KERMIT )
			fprintf( kermit, "REMOTE HOST %s CRDIR\n", newdir );
		else {
			char temp[BUFFERSIZE];
			sprintf( temp, "%s CRDIR", newdir );
			send_packet( "E", temp );
		}
	}
	refresh( w, GINT_TO_POINTER(whereami) );
	free( newdir );
}

void remove_dir ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE];

	if ( !data_pc.dir || strcmp( data_pc.dir, "." ) ||
			strcmp (data_pc.dir, ".." ) )
		return;
	
	if ( preferences.delete_confirm != FALSE ) {
		int remove = confirm("Delete directory", "REALLY delete directory\n"
				"and ALL its contents?" );
		if ( remove == CANCEL )
			return;
	}

	if ( whereami == PC ) {
		char message[BUFFERSIZE+150];
		int remove;

		sprintf( temp, "rm -rf %s/%s", data_pc.current, 
			(panel == FILES ? data_pc.filename : data_pc.dir) );
		sprintf( message, "This is a very delicate command\n"
				"which may erase your entire HD. Are you sure\n"
				"that this is the command that you want:\n%s\n",
				temp );
		remove = confirm( "Confirm", message );
		if ( remove != OK )
			return;
		system( temp );
	}
	else {
		if ( preferences.protocol == KERMIT )
			fprintf( kermit, "REMOTE HOST %s PGDIR\n", 
				(panel == FILES ? data_hp.filename : data_hp.dir) ); 
		else {
			sprintf( temp, "%s PGDIR\n", 
				(panel == FILES ? data_hp.filename : data_hp.dir) );
			send_packet( "E", temp );
		}
	}
	refresh( w, GINT_TO_POINTER(whereami) );
}


void command ( GtkWidget *w, gpointer data ) {
	char *com, temp[BUFFERSIZE];
	GString *output;
	
	if ( connected == OFFLINE )
		return;
	
	com = entry_popup( "Command", "Type the command here\n."
			"You cannot type a return character by now.\n"
			"Output will be presented to you,\n"
			"and stack will be cleared after.\n"
			"Please note that you must type the command in\n"
			"such a way that kermit will translate it to do\n"
			"what you want. This may be a bit tricky..." );

	if ( !com )
		return;

	output = g_string_new( "HP returned:\n" );

	set_status( "Sending command..." );
	if ( preferences.protocol == KERMIT ) {
		clear_kinput();
		fprintf( kermit, "REMOTE HOST %s\n", com );
	}
	else
		send_packet( "E", com );

	free(com);
	set_status( "Receiving output..." );
temp:
	message_box( "Wait box", "Please press OK when the calculator\n"
			"stops sending data." );

	if ( preferences.protocol == KERMIT ) {
		/* wait */
		while ( fgets( temp, BUFFERSIZE-1, kermit ) ) {
			if ( strstr( temp, "Kermit>" ) )
				break;
			g_string_append( output, (gchar *)temp);
		}
	}
	else {
		int size;
/*		while ( (com = get_stack(&size)) != NULL ) {
			g_string_append( output, (gchar *)temp);
			free( com );
		} */
	}

	/* show a box with all data */
	message_box( "Output", output->str );
	g_string_free( output, TRUE );
	if ( preferences.protocol == KERMIT ) {
		fprintf(kermit, "REMOTE HOST CLEAR\n" );
		clear_kinput();
	}
	else
		send_packet( "E", "CLEAR");

	set_status( "Done" );
}

#ifdef UPDATE_ROM
/* code of rom_upload is from Upgrade, by Mathias Bunte, and is in the
hp49flash-(VERSION) directory. */
void update_rom ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE];
	int update;
	
	if ( data_pc.filename == NULL ) {
		message_box("Error", "Please select the ROM file in the\n"
				"PC files panel");
		return;
	}
	update = confirm( "Update ROM", "Really update ROM?\n"
			"When uploading the ROM, HPTalx will freeze. Do not\n"
			"worry. You can keep track of upload looking in the\n"
			"calculator or, if you run HPTalx in a terminal,\n"
			"there will be output.\n\n" );

	if ( update != OK )
		return;
	sprintf( temp, "%s/%s", data_pc.current, data_pc.filename );
	rom_upload( temp, preferences.port );
}
#endif

void backup ( GtkWidget *w, gpointer data ) {
	char temp[BUFFERSIZE], *backupname;
	int bytes, percent, cps, plength;
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *button;

	if ( connected == OFFLINE )
		return;

	if ( preferences.protocol == XMODEM ) {
		message_box( "Error", "Backup using Xmodem\nis not support yet." );
		return;
	}
	set_status( "Backing up..." );
	backupname = entry_popup( "Name", "Backup file name:" );
	if ( !backupname )
		return;

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), "Backing up...");
	gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	/* show status */
	label = gtk_label_new("Turning clock off\n");
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
			FALSE, FALSE, 10);
	gtk_widget_show(label);

	/* this will KILL the app. that's not the way to go, but, by now... */
	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(cancel_transfer), NULL);
	gtk_box_pack_end(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_show(dialog);

	/* we should turn clock off */
	while (gtk_events_pending())
			gtk_main_iteration();
	clear_kinput();
	fprintf( kermit, "REMOTE HOST { -40 } CF\n" );
	wait_prompt();

	/* put name */
	gtk_label_set_text(GTK_LABEL(label), "Setting name");
	while (gtk_events_pending())
		gtk_main_iteration();
	fprintf( kermit, "REMOTE HOST :IO:%s\n", backupname );
	wait_prompt();

	/* get the closest to ARCHIVE we can */	
	fprintf( kermit, "REMOTE HOST { \\\\<< ARCHIVE SERVER \\\\>> }\n" );
	wait_prompt();
	/* run server */
	fprintf( kermit, "server\n" );
	message_box( "Backup", "Please press EVAL key.\n"
			"When done click OK on the computer." );
	do {
		fgets( temp, BUFFERSIZE-1, kermit );
	} while ( !strstr( temp, "Length") );

	fgets( temp, BUFFERSIZE-1, kermit );
	do {
		sscanf( temp, "%d%d%%%d%d", &bytes, &percent, &cps, &plength );
		sprintf( temp, "%d bytes received\n%d CPS\n", bytes, cps );
		gtk_label_set_text(GTK_LABEL(label), temp );
		while (gtk_events_pending())
			gtk_main_iteration();
 		while ( fgets( temp, BUFFERSIZE-1, kermit ) == NULL ) ;
	} while ( !strstr( temp, "[OK]" ) );

	gtk_label_set_text(GTK_LABEL(label), "Done..." );
	while (gtk_events_pending())
		gtk_main_iteration();
	gtk_widget_destroy( dialog );
	sprintf( temp, "Backup done.\nTotal size: %d bytes", bytes );
	message_box( "Backup", temp );
	/* send ctrl-c to get out of server mode in PC */
	fputc( '\003', kermit );
	refresh( w, GINT_TO_POINTER(PC) );
}

void restore ( GtkWidget *w, gpointer data ) {
	int res;
	char temp[BUFFERSIZE];
	char *file = strdup(data_pc.filename), *t;
	t = file;

	if ( preferences.protocol == XMODEM ) {
		message_box( "Error", "Restore using Xmodem\nis not support yet." );
		return;
	}
	if ( whereami != PC || (res = confirm( "Restore", "REALLY restore memory?\n"
			"This will erase current user memory.\n"
			"You must have enough free space for the download.\n"
			"As HP modifies the original filename, it may be impossible\n"
			"to perform the restore; the file will be uploaded, however\n"
			"and you can finish the operation manually." )) != OK
			|| data_pc.filename == NULL )
		return;

	transfer( w, data );
	set_status( "Restoring..." );
	while ( *t ) *t++ = toupper(*t);
	sleep(1);
	clear_kinput();
	fprintf( kermit, "REMOTE HOST '%s'\n", file );
	wait_prompt();
	clear_kinput();
	fprintf( kermit, "REMOTE HOST RCL\n" );
	wait_prompt();
	fprintf( kermit, "REMOTE HOST RESTORE\n" );
	message_box( "Restore", "Memory restored.\n"
			"Please set calculator in server mode again.\n" );
	clear_kinput();
	free( file );
	refresh( w, GINT_TO_POINTER(HP) );
}
