#!/usr/bin/perl -w                ## -*- cperl -*-

use strict;
use Xray::Scattering;

my $d = 3;
my $symb = Xray::Scattering->get_valence('F', -1);


printf "Cromer-Mann:      %s  %s  %s\n",
  $symb, $d, Xray::Scattering->get_f($symb, $d);
print join(" ", Xray::Scattering->get_coefficients($symb)), $/;

Xray::Scattering -> load('waaskirf');
printf "Waasmaier-Kirfel: %s  %s  %s\n",
  $symb, $d, Xray::Scattering->get_f($symb, $d);
print join(" ", Xray::Scattering->get_coefficients($symb)), $/;

Xray::Scattering -> load('none');
printf "None:             %s  %s  %s\n",
  $symb, $d, Xray::Scattering->get_f($symb, $d);
print join(" ", Xray::Scattering->get_coefficients($symb)), $/;
