## Time-stamp: <06/01/02 11:46:56 bruce>
######################################################################
##  This module is copyright (c) 2005-2006 Bruce Ravel
##  <ravel@phys.washington.edu>
##  http://cars9.uchicago.edu/~ravel/software/exafs/
##
## -------------------------------------------------------------------
##     All rights reserved. This program is free software; you can
##     redistribute it and/or modify it under the same terms as Perl
##     itself.
##
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     Artistic License for more details.
## -------------------------------------------------------------------
######################################################################
## $Id: CromerMann.pm,v 1.3 1999/06/11 22:19:59 bruce Exp $
######################################################################
## Code:

package Xray::Scattering::None;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT_OK = qw();
$VERSION = '0.01';

# Preloaded methods go here.

use strict;
use Storable;
use Chemistry::Elements qw(get_symbol);

use Ifeffit::FindFile;
use File::Spec;
my $data_dir = _identify_self();
my $dbfile = ($Ifeffit::FindFile::is_windows) ?
  Ifeffit::FindFile->find("other", "waaskirf_db") :
  File::Spec->catfile($data_dir, "waaskirf.db");
my $r_waaskirf = retrieve($dbfile);

sub _identify_self {
  my @caller = caller;
  use File::Basename qw(dirname);
  return dirname($caller[1]);
};

sub available {
  shift;
  my $sym = lc($_[0]);
  return ucfirst($sym);
};

sub get_f {
  shift;
  return 0;
};

sub get_coefficients {
  shift;
  my $sym = lc($_[0]);
  my @null = (0,0,0,0,0,0,0,0,0,0,0);
  return @null;
};



1;

__END__

=head1 NAME

Xray::Scattering::None - Fallback subclass for Thomspon scattering factors

=head1 SYNOPSIS

  use Xray::Scattering;
  Xray::Scattering->load('None');
  $fnot = Xray::Scattering->get_f($symb, $d);

=head1 DESCRIPTION

This module provides a fallback subclass for the Xray::Scattering methods.  It
provides all the methods of the real subclasses, but returns fallback values.


=head1 METHODS

=over 4

=item C<get_f>

Retruns 0.

=item C<get_coefficients>

returns an array of 11 zeros.

=item C<available>

Always returns the symbol itself.

=back



=head1 AUTHOR

  Bruce Ravel, bravel@anl.gov
  http://cars9.uchicago.edu/~ravel/software/exafs/

=cut
