/*
 * BackupPhases.java
 *
 * Created on December 24, 2003, 10:07 AM
 */

package com.sun.enterprise.config.backup.phase;

import com.sun.enterprise.config.backup.status.BackupStatus;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.StatusRegistry;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;

/**
 *
 * @author  sridatta
 */
public class BackupPhases extends PhasesBase {
    
    /** Creates a new instance of BackupPhases */
    public BackupPhases() {
    }
    
   /* public void assertStatusNotFailed(BackupStatus bs) {
        assertNotNull(bs);
        assertNotFailed(bs);
    }
    */
    
    public void assertStatusNotNull(BackupStatus bs) {
        if(bs == null) {
            LoggerHelper.info("null_status_in_backup");
            //should never happen
            BackupStatus bs1 = new BackupStatus();
            setStatusInRegistry(bs1);
            throw new BackupAbortException(
                "error_invoking_backup_null_status",
                LocalStringsHelper.getString(
                    "error_invoking_backup_null_status"));
        }
    }
    

    public void setAbsoluteBackupFileName(String absoluteTargetFile) {
        getStatus().setAbsoluteBackupFileName(absoluteTargetFile);
        LoggerHelper.fine("Target File for backup is " + absoluteTargetFile);
        
    }
    
    public BackupStatus getStatus() {
        return (BackupStatus)getStatusFromRegistry();
    }
    
    public void monitorBackupDir() {
        try {
            FactoryHelper.getBackupStorageMonitor().run();
        } catch(Exception e) {
            //log it
            LoggerHelper.warning("error_monitoring_backup_dir");
            LoggerHelper.fine("error_monitoring_backup_dir", e);
        }
    }
    
    public void setBackupFileSize(long size) {
          getStatus().setBackupFileSize(size);
    }
    
    public long backup() throws Exception {
        String[] srcDirs = getStatus().getDirectoriesToBackup();
              LoggerHelper.fine("Source Directory for backup is " 
                                + BackupHelper.ArrayToString(srcDirs));
             
              String absTargetFile = getStatus().getAbsoluteBackupFileName();
              //get the correct storage class
              BackupStorage backupStorage = FactoryHelper.getStorage();
              return backupStorage.backup(srcDirs, absTargetFile);
    }
    
    public void addStatusFile() {
        String absTargetFile = getStatus().getAbsoluteBackupFileName();
        //get the correct storage class
        BackupStorage backupStorage = FactoryHelper.getStorage();
        backupStorage.createStatusFile(absTargetFile, getStatus());
    }
        
}
