
import java.sql.*;


/**
 * test ResultSetMetaData.isReadonly, ResultSetMetaData.isNullable,
 *      ResultSetMetaData.isAutoIncrement
 *
 */
public class t0055
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;


      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         String           expectedNames[] = 
         {
            "TABLE_CAT",
            "TABLE_SCHEM",
            "TABLE_NAME",
            "TABLE_TYPE",
            "REMARKS"
         };
         String           types[] = {"TABLE"};
         DatabaseMetaData dbMetaData = cx.getMetaData();
         ResultSet        rs         = dbMetaData.getTables( null, "%", "t%", types);
         ResultSetMetaData rsMetaData = rs.getMetaData();

         if (rsMetaData.getColumnCount() != 5)
         {
            if (passed)
            {
               passed = false;
               System.out.println("Bad column count.  Should be 5, was "
                               + rsMetaData.getColumnCount());
            }
         }

         for(i=0; passed && i<expectedNames.length; i++)
         {
            if (! rsMetaData.getColumnName(i+1).equals(expectedNames[i]))
            {
               passed = false;
               System.out.println("Bad name for column " + (i+1) + ".  "
                                  + "Was " + rsMetaData.getColumnName(i+1)
                                  + ", expected " 
                                  + expectedNames[i]);
            }
         }
      }
      catch(java.sql.SQLException e)
      {
         passed = false;
         System.out.println("Exception caught.  " + e.getMessage());
         e.printStackTrace();
      }

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0055.\n");
      System.exit(passed ? 0 : 1);
   }
}

