//                                                                            
// Copyright 1998 CDS Networks, Inc., Medford Oregon                          
//                                                                            
// All rights reserved.                                                       
//                                                                            
// Redistribution and use in source and binary forms, with or without         
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright          
//    notice, this list of conditions and the following disclaimer.           
// 2. Redistributions in binary form must reproduce the above copyright       
//    notice, this list of conditions and the following disclaimer in the     
//    documentation and/or other materials provided with the distribution.    
// 3. All advertising materials mentioning features or use of this software   
//    must display the following acknowledgement:                             
//      This product includes software developed by CDS Networks, Inc.        
// 4. The name of CDS Networks, Inc.  may not be used to endorse or promote   
//    products derived from this software without specific prior              
//    written permission.                                                     
//                                                                            
// THIS SOFTWARE IS PROVIDED BY CDS NETWORKS, INC. ``AS IS'' AND              
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED.  IN NO EVENT SHALL CDS NETWORKS, INC. BE LIABLE            
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS    
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)      
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     
// SUCH DAMAGE.                                                               
//                                                                            



package com.internetcds.jdbc.tds;


import java.util.Vector;


/**
 * encapsulate the information from one row of a result set.
 *
 * @author Craig Spannring
 */
public class PacketRowResult extends PacketResult
{
   public static final String cvsVersion = "$Id: PacketRowResult.java,v 1.3 1998/11/22 01:41:53 cts Exp $";


   Vector   row         = null;
   int      columnCount = -1;


   public PacketRowResult(
      int columnCount_)
   {
      super(TdsDefinitions.TDS_ROW_TOKEN);

      columnCount = columnCount_;
      row         = new Vector();
      row.setSize(columnCount_);
   }

   
   /**
    * Sets the component at the specified index of this vector 
    * to be the specified object. The previous component at that
    * position is discarded. 
    *
    * <UL>Note-<\UL> Unlike the vector class this class starts 
    * the index with 1, not 0.
    *
    * @param obj    The object to store
    * @param index  Index to store the element at.  First element is at
    *               index 1
    */
   public void setElementAt(
      Object   obj,
      int      index)
      throws TdsException
   {
      if (index<1 || index>columnCount)
      {
         throw new TdsException("Bad index " + index);
      }

      row.setElementAt(obj, index-1);
   }



   /**
    * get an element at the specified index
    * <p>
    * <UL>Note-<\UL> Unlike the vector class this starts 
    * the index with 1, not 0.
    *
    * @param index  Index to get the element from.  First element is at
    *               index 1
    */
   public Object getElementAt(
      int      index)
      throws TdsException
   {
      if (index<1 || index>columnCount)
      {
         throw new TdsException("Bad index " + index);
      }

      return row.elementAt(index-1);
   }


}
