/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICDLI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateDataLineValueINI(char * name, char * data, int type
		, int trustlevel)

	Write new value into the currently opened INI file for writing.
	If type == 0, no type is appended.
	If trustlevel == 0, no trustlevel is appended.

	If type or trustlevel is non-zero, name must not contain
	type and/or trustlevel.

ob(ject): cfgCreateDataLineINI
su(bsystem): inifile/1
sh(ort description): Append a new line to the INI file opened for writing
lo(ng description): Appends a new line to the INI file currently opened
 for writing and formats the line uniformly.
pr(erequistes): \para{name} != NULL
fi(le): cfgicdli.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <stdio.h>
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICDLI.C 1.3 1999/12/13 02:22:17 ska Exp ska $";
#endif

int cfgCreateDataLineINI(const char * const name, const char * const data
	, int type, int trustlevel)
{	int ch;
	//char buf[4];

	DBG_ENTER("cfgCreateDataLineINI", Suppl_inifile1)
	DBG_ARGUMENTS( ("name=\"%s\", data=\"%s\", typ=%d, lvl=%d", name, data, type, trustlevel) )

	chkHeap
	if(!cfgi_ini)			DBG_RETURN_I( CFG_ERR_NOTOPEN)
	if(!name)				DBG_RETURN_I( CFG_ERR_ARG)

	CFGI_NXTLINE

	chkHeap
	fputs(name, cfgi_ini);
	putc(' ', cfgi_ini);

	/* add type */
	switch(CFG_TBASE(type)) {
	case CFG_TSTRING:	ch = '$'; break;
	case CFG_TINTEGER:	ch = '%'; break;
	case CFG_TBOOLEAN:	ch = '?'; break;
	default:			goto noType;
	}
	putc(ch, cfgi_ini);
	/* add expandable flag */
	if(CFG_TISEXPAND(type))
		putc('!', cfgi_ini);

noType:
	chkHeap
	/* add trustlevel */
	if(trustlevel && trustlevel != CFG_DEFAULT_TRUSTLEVEL) {
		if((unsigned)trustlevel > 255) {
			DBG_STRING("trustlevel exceeds maximum of 255 or is negative")
			trustlevel = 255;
		}
		/*
		itoa10(trustlevel, buf);
		putc('<', cfgi_ini);
		fputs(buf, cfgi_ini);
		putc('>', cfgi_ini);
		*/
		fprintf(cfgi_ini, "<%u>", trustlevel);
	}

	/* add data */
	chkHeap
	putc('=', cfgi_ini);
	if(data)	fputs(data, cfgi_ini);

	cfgi_nlwritten = 0;

	DBG_RETURN_I( CFG_ERR_NONE)
}
