/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.Util;
import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.gui.Bar;
import dguitar.gui.BarPanel;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursor;
import dguitar.gui.MusicCursorPosition;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;

public abstract class BarMTP
extends Bar {
    protected boolean addSilence;
    protected boolean addEONs;
    protected int fontAscent;
    protected int lastNumHLines;
    protected Color colorPrev = Color.BLACK;
    protected Color colorNext = Color.BLACK;
    protected GPMeasureTrackPair mtp;
    private GPDuration minDuration;
    public static final int MIN_WIDTH = 50;
    private int min_width;

    public BarMTP(DisplayOptions currentDisplayOptions, BarPanel BP) {
        super(currentDisplayOptions, BP);
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.mtp = null;
        this.addSilence = true;
        this.addEONs = true;
        this.min_width = 50;
        this.minDuration = GPDuration.SIXTY_FOURTH;
    }

    public MusicCursorPosition getMusicCursorPosition(MusicCursor musicCursor) {
        Point p = new Point(0, 1);
        MusicCursorPosition resp = new MusicCursorPosition();
        resp.setPoint(p);
        resp.setWidth(this.getWidth() + 2 * musicCursor.getLeftOffset());
        resp.setSongObject(this.mtp);
        resp.setGuiComponent(this);
        resp.setNumBeat(0);
        return resp;
    }

    public MusicCursorPosition snapX(int xx, MusicCursor musicCursor) {
        int minX = this.calculateMinX();
        int cx = 0;
        Point p = new Point();
        p.y = 2;
        MusicCursorPosition resp = new MusicCursorPosition();
        Iterator it = this.mtp.getBeats().iterator();
        int fix = musicCursor.getLeftOffset();
        boolean found = false;
        if (it != null) {
            int contBeat = 1;
            int x = xx + fix;
            while (!found && it.hasNext()) {
                GPBeat current = (GPBeat)it.next();
                int cw = this.calculateWidthOfBeat(current);
                int cx2 = cx + cw;
                boolean bl = found = cx + minX <= x && x <= cx2 + minX;
                if (found) {
                    resp.setSongObject(current);
                    resp.setNumBeat(contBeat);
                    resp.setGuiComponent(this);
                }
                p.x = cx + minX;
                resp.setPoint(p);
                resp.setWidth(cw);
                cx = cx2;
                ++contBeat;
            }
        }
        if (!found) {
            resp = this.getMusicCursorPosition(musicCursor);
        }
        return resp;
    }

    public MusicCursorPosition getMusicCursorPosition(int beat) {
        MusicCursorPosition MCP = new MusicCursorPosition();
        Point p = new Point();
        Iterator it = this.mtp.getBeats().iterator();
        if (it != null) {
            p.x = this.calculateMinX();
            GPBeat current = null;
            int cw = 0;
            int cont = 0;
            while (cont < beat && it.hasNext()) {
                current = (GPBeat)it.next();
                cw = this.calculateWidthOfBeat(current);
                p.x += cw;
                ++cont;
            }
            p.y = 1;
            MCP.setPoint(p);
            MCP.setSongObject(current);
            MCP.setNumBeat(cont);
            MCP.setWidth(cw);
        }
        return MCP;
    }

    public GPMeasureTrackPair getMeasureTrackPair() {
        return this.mtp;
    }

    public void setMeasureTrackPair(GPMeasureTrackPair m) {
        this.mtp = m;
    }

    public boolean hasBeats() {
        boolean resp = false;
        if (this.mtp != null) {
            resp = this.mtp.getBeats() != null;
        }
        return resp;
    }

    public List getBeats() {
        List aux = null;
        if (this.mtp != null) {
            aux = this.mtp.getBeats();
        }
        return aux;
    }

    protected int calculateWidthOfBeat(GPBeat beat) {
        int w = 0;
        if (beat != null) {
            GPDuration d = beat.getDuration();
            int dif = this.minDuration.getIndex() - d.getIndex();
            int fact = Util.pow2(dif);
            w = fact * this.getDisplayOptions().NS;
            if (beat.dottedNotes) {
                w += w / 2;
            }
        }
        return w;
    }

    protected int calculateWidth(List beats) {
        int w = 0;
        int i = 0;
        while (i < beats.size()) {
            GPBeat beat = (GPBeat)beats.get(i);
            w += this.calculateWidthOfBeat(beat);
            ++i;
        }
        return w;
    }

    protected int calculateWidth(int inc) {
        int w = inc;
        if (this.mtp != null) {
            List beats = this.mtp.getBeats();
            if (beats != null) {
                w += this.getDisplayOptions().NS / 2;
                w += this.calculateWidth(beats);
                w += this.getDisplayOptions().NS / 2;
            }
            if (w < this.min_width) {
                w = this.min_width;
            }
        }
        return w;
    }

    public final GPDuration minDurationOfBeats() {
        List Beats;
        GPDuration min = GPDuration.WHOLE;
        if (this.mtp != null && (Beats = this.mtp.getBeats()) != null) {
            int b = 0;
            while (b < Beats.size()) {
                GPBeat beat = (GPBeat)Beats.get(b);
                GPDuration d = beat.getDuration();
                if (d.compareTo(min) < 0) {
                    min = d;
                }
                ++b;
            }
        }
        return min;
    }

    protected abstract int calculateHeightOfString(int var1);

    protected abstract void paintRhythmHL(Graphics var1, int var2, int var3, int var4, GPBeat var5);

    protected abstract void paintNote(Graphics var1, int var2, int var3, GPNote var4);

    protected abstract void paintSilence(Graphics var1, int var2, GPBeat var3, int var4);

    protected abstract void paintEffects(Graphics var1, int var2, int var3, GPEffectsOnNote var4, int var5, GPBeat var6);

    protected final void paintRhythm(Graphics g, int x, int y, GPBeat beat, GPBeat prev, GPBeat next) {
        Color prevColor = g.getColor();
        GPDuration d = beat.getDuration();
        if (!d.equals(GPDuration.WHOLE)) {
            int lowest = this.getDisplayOptions().TopOffset + this.BP.H + 2 * this.getDisplayOptions().LS;
            int index = d.getIndex();
            int top = index == 1 ? lowest - this.getDisplayOptions().LS : y;
            Color rhythmColor = this.getDisplayOptions().rhythmColors.getColor(d);
            g.setColor(rhythmColor);
            if (beat.isNoteBeat()) {
                g.drawLine(x, top, x, lowest);
            }
            if (beat.dottedNotes) {
                g.drawRect(x + 2, lowest + 2, 1, 1);
            }
            if (index > 1) {
                GPDuration nd;
                int n;
                GPDuration pd;
                if (prev != null && !prev.isEmptyBeat() && (pd = prev.getDuration()).compareTo(GPDuration.EIGHTH) <= 0) {
                    n = GPDuration.EIGHTH.compareTo(d);
                    if (beat.isRestBeat()) {
                        if (d.compareTo(pd) > 0) {
                            this.lastNumHLines -= d.compareTo(pd);
                        }
                        n = this.lastNumHLines;
                    }
                    this.paintRhythmHL(g, x, lowest, n, prev);
                }
                if (next != null && !next.isEmptyBeat() && (nd = next.getDuration()).compareTo(GPDuration.EIGHTH) <= 0) {
                    n = GPDuration.EIGHTH.compareTo(d);
                    if (beat.isRestBeat()) {
                        n = this.lastNumHLines;
                    }
                    this.paintRhythmHL(g, x, lowest, n, null);
                    this.lastNumHLines = n;
                }
            }
        }
        g.setColor(prevColor);
    }

    protected final void paintBeat(Graphics g, int currentX, GPBeat beat, GPBeat prev, GPBeat next, PaintedBeatInfo I) {
        Color prevColor = g.getColor();
        boolean first = true;
        int s = 6;
        while (s >= 0) {
            boolean played = beat.isStringPlayed(s);
            if (played) {
                int y = this.calculateHeightOfString(s);
                if (first) {
                    this.paintRhythm(g, currentX, y, beat, prev, next);
                    first = false;
                }
                GPNote note = I.getGPNote();
                if (note.effects != null) {
                    this.paintEffects(g, currentX, y, note.effects, I.contEONs, beat);
                    ++I.contEONs;
                }
                Color beatColor = this.getDisplayOptions().fretColors.getColor(beat.getDuration());
                g.setColor(beatColor);
                this.paintNote(g, currentX, y, note);
            }
            --s;
        }
        g.setColor(prevColor);
    }

    protected final GPBeat nextBeat(List Beats, int b, int max) {
        GPBeat next = null;
        if (b + 1 < max) {
            next = (GPBeat)Beats.get(b + 1);
        }
        return next;
    }

    private final int calculateMinX() {
        int currentX = this.minx;
        currentX += this.getDisplayOptions().NS / 2;
        return currentX += this.getDisplayOptions().NS / 2;
    }

    protected final void paintMeasureTrackPair(Graphics g) {
        if (this.mtp != null) {
            Color prevColor = g.getColor();
            List Beats = this.mtp.getBeats();
            g.setFont(BarPanel.notesFont);
            this.fontAscent = g.getFontMetrics().getAscent();
            GPBeat prev = null;
            this.lastNumHLines = -1;
            int contSilences = 0;
            PaintedBeatInfo PBI = new PaintedBeatInfo();
            int currentX = this.calculateMinX();
            int max = Beats.size();
            int b = 0;
            while (b < max) {
                GPBeat beat = (GPBeat)Beats.get(b);
                GPBeat next = this.nextBeat(Beats, b, max);
                PBI.setNotes(beat.getNotes());
                if (!beat.isEmptyBeat()) {
                    currentX += this.calculateWidthOfBeat(prev);
                    if (beat.isRestBeat()) {
                        this.paintSilence(g, currentX, beat, contSilences);
                        this.paintRhythm(g, currentX, 0, beat, prev, next);
                        ++contSilences;
                    } else {
                        this.paintBeat(g, currentX, beat, prev, next, PBI);
                    }
                }
                prev = beat;
                ++b;
            }
            this.addSilence = false;
            this.addEONs = false;
            g.setColor(prevColor);
        }
    }

    protected void paintComponent(Graphics gg) {
        Graphics g = gg.create();
        super.paintComponent(g);
        if (this.mtp != null) {
            this.paintMeasureTrackPair(g);
        }
        g.dispose();
    }

    public void setMinDuration(GPDuration d) {
        if (d != null) {
            this.minDuration = d;
            this.min_width = 5;
        }
    }

    public void setMinWidth(int value) {
        this.min_width = value;
    }

    class PaintedBeatInfo {
        private List Notes = null;
        private int contNotes = 0;
        public int contEONs = 0;

        public void setNotes(List notes) {
            this.Notes = notes;
            this.contNotes = 0;
        }

        public GPNote getGPNote() {
            GPNote res = null;
            if (this.Notes != null) {
                res = (GPNote)this.Notes.get(this.contNotes);
                ++this.contNotes;
            }
            return res;
        }
    }
}

