/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.statistics;

import common.Util;
import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.codecs.guitarPro.statistics.GPStats;
import dguitar.codecs.guitarPro.statistics.GPStatsEffectsOnBeat;
import dguitar.codecs.guitarPro.statistics.GPStatsEffectsOnNote;
import java.util.List;

public class GPStatsMeasureTrackPair
extends GPStats {
    public int numChordDiagrams;
    public int numEffects;
    public int numMixTableChanges;
    private int numBeats;
    private int numNotes;
    private int numNoteEffects;
    private int measure;
    private int track;
    List beats;
    GPStatsEffectsOnBeat totalEffectsOnBeat;
    GPStatsEffectsOnNote totalEffectsOnNote;

    private void common() {
        this.numChordDiagrams = 0;
        this.numEffects = 0;
        this.numMixTableChanges = 0;
        this.numNotes = 0;
        this.numNoteEffects = 0;
        this.totalEffectsOnBeat = new GPStatsEffectsOnBeat();
        this.totalEffectsOnNote = new GPStatsEffectsOnNote();
    }

    public GPStatsMeasureTrackPair() {
        this.numBeats = 0;
        this.measure = -1;
        this.track = -1;
        this.common();
    }

    public GPStatsMeasureTrackPair(GPMeasureTrackPair MTP, int Measure, int Track2) {
        this.beats = MTP.getBeats();
        if (this.beats != null) {
            this.numBeats = this.beats.size();
            this.measure = Measure;
            this.track = Track2;
            this.common();
            int i = 0;
            while (i < this.numBeats) {
                List notes;
                GPBeat beat = (GPBeat)this.beats.get(i);
                if (beat.chordDiagram != null) {
                    ++this.numChordDiagrams;
                }
                if (beat.effects != null) {
                    ++this.numEffects;
                    GPStatsEffectsOnBeat EOBI = new GPStatsEffectsOnBeat(beat.effects);
                    this.totalEffectsOnBeat.add(EOBI);
                }
                if (beat.mixTableChange != null) {
                    ++this.numMixTableChanges;
                }
                if ((notes = beat.getNotes()) != null) {
                    this.numNotes += notes.size();
                    int n = 0;
                    while (n < notes.size()) {
                        GPNote Note = (GPNote)notes.get(n);
                        if (Note.effects != null) {
                            ++this.numNoteEffects;
                            GPStatsEffectsOnNote EONI = new GPStatsEffectsOnNote(Note.effects);
                            this.totalEffectsOnNote.add(EONI);
                        }
                        ++n;
                    }
                }
                ++i;
            }
        }
    }

    public void add(GPStatsMeasureTrackPair a) {
        if (a != null) {
            this.numBeats += a.numBeats;
            this.numNotes += a.numNotes;
            this.numNoteEffects += a.numNoteEffects;
            this.numChordDiagrams += a.numChordDiagrams;
            this.numEffects += a.numEffects;
            this.numMixTableChanges += a.numMixTableChanges;
            if (this.totalEffectsOnBeat != null) {
                this.totalEffectsOnBeat.add(a.totalEffectsOnBeat);
            }
            if (this.totalEffectsOnNote != null) {
                this.totalEffectsOnNote.add(a.totalEffectsOnNote);
            }
        }
    }

    public boolean nonZero() {
        boolean condA;
        boolean bl = condA = this.numChordDiagrams != 0 || this.numEffects != 0;
        return condA || this.numMixTableChanges != 0 || this.numNoteEffects != 0;
    }

    public String toString() {
        String res = "";
        String aux = "beats";
        if (this.measure >= 0) {
            res = String.valueOf(res) + Util.tabs(level) + "Measure: " + this.measure + "\n";
        }
        if (this.track >= 0) {
            res = String.valueOf(res) + Util.tabs(level) + "Track: " + this.track + "\n";
        }
        res = String.valueOf(res) + Util.tabs(++level) + this.numBeats + " " + aux + "\n";
        res = String.valueOf(res) + this.stringFor(this.numChordDiagrams, "ChordDiagrams", this.numBeats, aux);
        res = String.valueOf(res) + this.stringFor(this.numEffects, "Effects", this.numBeats, aux);
        if (this.numEffects > 0) {
            ++level;
            res = String.valueOf(res) + this.totalEffectsOnBeat.toString();
            --level;
        }
        if (this.numNoteEffects > 0) {
            ++level;
            res = String.valueOf(res) + this.totalEffectsOnNote.toString();
            --level;
        }
        res = String.valueOf(res) + this.stringFor(this.numMixTableChanges, "MixTableChanges", this.numBeats, aux);
        --level;
        return res;
    }
}

