/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.SwingWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileLoader {
    public int sizeLoader;
    public int BUFFER = 512;
    public boolean success = false;
    public String errorCode = "NO ERROR";
    public byte[] resp = null;
    private File file;
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;

    public FileLoader(String fileName) {
        this.file = new File(fileName);
        if (this.file != null && this.file.isFile()) {
            this.sizeLoader = this.lengthOfTask = (int)this.file.length();
        } else {
            this.errorCode = "FILE OBJECT COULD NOT BE CREATED";
        }
    }

    public FileLoader(File userFile) {
        this.file = userFile;
        if (this.file != null && this.file.isFile()) {
            this.sizeLoader = this.lengthOfTask = (int)this.file.length();
        } else {
            this.errorCode = "FILE OBJECT COULD NOT BE CREATED";
        }
    }

    public void loadFile() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Loader respB = null;
                FileLoader.this.current = 0;
                FileLoader.this.done = false;
                FileLoader.this.canceled = false;
                FileLoader.this.statMessage = null;
                respB = new Loader(FileLoader.this.file);
                return respB;
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return this.statMessage;
    }

    class Loader {
        String errorStr;

        public Loader(File file) {
            byte[] mem = null;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    long size = file.length();
                    if (size > 0L) {
                        int leyo;
                        mem = new byte[FileLoader.this.BUFFER];
                        FileLoader.this.resp = new byte[(int)size];
                        int j = 0;
                        do {
                            if ((leyo = fis.read(mem)) <= 0) continue;
                            int i = 0;
                            while (i < leyo && !FileLoader.this.canceled) {
                                FileLoader.this.resp[j] = mem[i];
                                FileLoader.this.current = ++j;
                                FileLoader.this.statMessage = "Loading byte " + j + "/" + size;
                                ++i;
                            }
                        } while (leyo > 0);
                        if (!FileLoader.this.canceled) {
                            FileLoader.this.done = true;
                            FileLoader.this.current = FileLoader.this.lengthOfTask;
                        }
                    }
                }
                catch (IOException e) {
                    this.errorStr = e.toString();
                    FileLoader.this.success = false;
                }
            }
            finally {
                try {
                    fis.close();
                    FileLoader.this.success = true;
                }
                catch (IOException e) {
                    this.errorStr = e.toString();
                }
            }
        }
    }
}

