/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FlattenedObject;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeFunction
extends ScriptableObject
implements Function {
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final boolean printSource = false;
    protected String[] names;
    protected short argCount;
    protected short version;
    protected String source;
    public NativeFunction[] nestedFunctions;
    public int debug_level = -1;
    public String debug_srcName;

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.getClassPrototype());
        nativeObject.setParentScope(this.getParentScope());
        Object object = this.call(context, scriptable, nativeObject, objectArray);
        if (object != null && object != Undefined.instance && object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return nativeObject;
    }

    /*
     * Exception decompiling
     */
    public String decompile(int var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        functionObject.setPrototype(scriptable2);
        String[] stringArray = new String[]{""};
        ((NativeFunction)scriptable2).names = stringArray;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        if (string.equals("prototype")) {
            NativeObject nativeObject = new NativeObject();
            nativeObject.setPrototype(ScriptableObject.getObjectPrototype(this));
            int n = 7;
            nativeObject.defineProperty("constructor", this, 7);
            this.put(string, (Scriptable)this, (Object)nativeObject);
            return nativeObject;
        }
        if (string.equals("arguments")) {
            NativeCall nativeCall = this.getActivation(Context.getContext());
            return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
        }
        return Scriptable.NOT_FOUND;
    }

    private NativeCall getActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        while (nativeCall != null) {
            if (nativeCall.getFunctionObject() == this) {
                return nativeCall;
            }
            nativeCall = nativeCall.caller;
        }
        return null;
    }

    public String getClassName() {
        return "Function";
    }

    protected Scriptable getClassPrototype() {
        Object object = this.get("prototype", (Scriptable)this);
        if (object == null || !(object instanceof Scriptable) || object == Undefined.instance) {
            object = ScriptableObject.getClassPrototype(this, "Object");
        }
        return (Scriptable)object;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("prototype") || string.equals("arguments") || super.has(string, scriptable);
    }

    public boolean hasInstance(Scriptable scriptable) {
        FlattenedObject flattenedObject = new FlattenedObject(this);
        Object object = flattenedObject.getProperty("prototype");
        if (object instanceof FlattenedObject && (object = ((FlattenedObject)object).getObject()) != Undefined.instance) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        Object[] objectArray = new Object[]{this.names[0]};
        String string = ScriptRuntime.getMessage("msg.instanceof.bad.prototype", objectArray);
        throw NativeGlobal.constructError(Context.getContext(), "TypeError", string, scriptable);
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - 1) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ScriptRuntime.toString(objectArray[n2]));
            ++n2;
        }
        String string = n == 0 ? "" : ScriptRuntime.toString(objectArray[n2]);
        String string2 = "function (" + stringBuffer.toString() + ") {" + string + "}";
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        if (string3 == null) {
            string3 = "<eval'ed string>";
            nArray[0] = 1;
        }
        Object object = context.getSecurityDomainForStackDepth(4);
        Scriptable scriptable = context.ctorScope;
        if (scriptable == null) {
            scriptable = function;
        }
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        int n3 = context.getOptimizationLevel();
        context.setOptimizationLevel(-1);
        NativeFunction nativeFunction = (NativeFunction)context.compileFunction(scriptable2, string2, string3, nArray[0], object);
        context.setOptimizationLevel(n3);
        if (nativeFunction.names == null) {
            nativeFunction.names = new String[1];
        }
        nativeFunction.names[0] = "anonymous";
        nativeFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable2));
        nativeFunction.setParentScope(scriptable2);
        return nativeFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object jsFunction_apply(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2;
        Scriptable scriptable2;
        if (objectArray.length != 2) {
            return NativeFunction.jsFunction_call(context, scriptable, objectArray, function);
        }
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        Scriptable scriptable3 = scriptable2 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        if (objectArray.length > 1) {
            if (!(objectArray[1] instanceof NativeArray) && !(objectArray[1] instanceof Arguments)) throw NativeGlobal.constructError(context, "TypeError", ScriptRuntime.getMessage("msg.arg.isnt.array", null), scriptable);
            objectArray2 = context.getElements((Scriptable)objectArray[1]);
            return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
        } else {
            objectArray2 = new Object[]{};
        }
        return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
    }

    public static Object jsFunction_call(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (objectArray.length == 0) {
            Scriptable scriptable2 = ScriptRuntime.toObject(function, object);
            Scriptable scriptable3 = scriptable2.getParentScope();
            return ScriptRuntime.call(context, object, scriptable3, ScriptRuntime.emptyArgs, scriptable3);
        }
        Scriptable scriptable4 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return ScriptRuntime.call(context, object, scriptable4, objectArray2, scriptable4);
    }

    public static Object jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (!(object instanceof NativeFunction)) {
            Object[] objectArray2 = new Object[]{"toString"};
            String string = Context.getMessage("msg.incompat.call", objectArray2);
            throw NativeGlobal.constructError(context, "TypeError", string, function);
        }
        int n = 0;
        if (objectArray.length > 0) {
            n = (int)ScriptRuntime.toNumber(objectArray[0]);
        }
        return ((NativeFunction)object).decompile(n, true, false);
    }

    public int jsGet_arity() {
        return this.argCount;
    }

    public int jsGet_length() {
        Context context = Context.getContext();
        if (context != null && context.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.getActivation(context);
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    public String jsGet_name() {
        Context context;
        if (this.names == null) {
            return "";
        }
        if (this.names[0].equals("anonymous") && (context = Context.getCurrentContext()) != null && context.getLanguageVersion() == 120) {
            return "";
        }
        return this.names[0];
    }

    private boolean nextIs(int n, int n2) {
        if (n + 1 < this.source.length()) {
            return this.source.charAt(n + 1) == n2;
        }
        return false;
    }
}

