/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.P4HandlerAdapter;

public class P4Change
extends P4Base {
    protected String emptyChangeList = null;

    public void execute() throws BuildException {
        if (this.emptyChangeList == null) {
            this.emptyChangeList = this.getEmptyChangeList();
        }
        final Project project = this.project;
        P4HandlerAdapter p4HandlerAdapter = new P4HandlerAdapter(){

            public void process(String string) {
                if (P4Change.this.util.match("/Change/", string)) {
                    string = P4Change.this.util.substitute("s/[^0-9]//g", string);
                    int n = Integer.parseInt(string);
                    P4Change.this.log("Change Number is " + n, 2);
                    project.setProperty("p4.change", "" + n);
                } else if (P4Change.this.util.match("/error/", string)) {
                    throw new BuildException("Perforce Error, check client settings and/or server");
                }
            }
        };
        p4HandlerAdapter.setOutput(this.emptyChangeList);
        this.execP4Command("change -i", p4HandlerAdapter);
    }

    public String getEmptyChangeList() throws BuildException {
        final StringBuffer stringBuffer = new StringBuffer();
        this.execP4Command("change -o", new P4HandlerAdapter(){

            public void process(String string) {
                if (!P4Change.this.util.match("/^#/", string)) {
                    if (P4Change.this.util.match("/error/", string)) {
                        P4Change.this.log("Client Error", 3);
                        throw new BuildException("Perforce Error, check client settings and/or server");
                    }
                    if (P4Change.this.util.match("/<enter description here>/", string)) {
                        string = P4Change.this.util.substitute("s/<enter description here>/AutoSubmit By Ant/", string);
                    } else if (P4Change.this.util.match("/\\/\\//", string)) {
                        return;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
            }
        });
        return stringBuffer.toString();
    }
}

