/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.Path;

public class CSharp
extends MatchingTask {
    protected static final String csc_exe_name = "csc";
    protected static final String csc_file_ext = "cs";
    protected static final String csc_file_pattern = "**/*.cs";
    protected String _references;
    protected Path _referenceFiles;
    protected static final String DEFAULT_REFERENCE_LIST = "System.dll;System.Drawing.dll;System.Data.dll;System.Diagnostics.dll;System.DirectoryServices.dll;System.IO.dll;System.Management.dll;System.Messaging.dll;System.Net.dll;System.Runtime.Remoting.dll;System.Runtime.Serialization.Formatters.Soap.dll;System.Security.dll;System.ServiceProcess.dll;System.Text.RegularExpressions.dll;System.Timers.dll;System.Web.dll;System.Web.Services.dll;System.WinForms.dll;System.XML.dll;System.XML.Serialization.dll;Microsoft.ComServices.dll;";
    protected boolean _includeDefaultReferences;
    protected boolean _optimize;
    protected boolean _incremental;
    protected boolean _debug;
    protected File _docFile;
    private int _warnLevel;
    protected boolean _unsafe;
    protected String _mainClass;
    protected String _extraOptions;
    private File _srcDir;
    private File _destDir;
    protected String _targetType;
    protected File _win32icon;
    String _definitions;
    String _additionalModules;
    protected String _outputFile;
    protected boolean _failOnError;

    public CSharp() {
        this.Clear();
        this.setIncludes(csc_file_pattern);
    }

    public void setReferences(String string) {
        this._references = string;
    }

    protected String getReferencesParameter() {
        if (this.notEmpty(this._references)) {
            return "/reference:" + this._references;
        }
        return null;
    }

    public void setReferenceFiles(Path path) {
        if (this._referenceFiles == null) {
            this._referenceFiles = new Path(((Task)this).project);
        }
        this._referenceFiles.append(path);
    }

    protected String getReferenceFilesParameter() {
        if (this._references == null) {
            return null;
        }
        String string = this._references.toString();
        if (string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("/reference:");
        stringBuffer.append(string);
        return new String(stringBuffer);
    }

    protected String getDefaultReferenceParameter() {
        if (this._includeDefaultReferences) {
            StringBuffer stringBuffer = new StringBuffer("/reference:");
            stringBuffer.append(DEFAULT_REFERENCE_LIST);
            return new String(stringBuffer);
        }
        return null;
    }

    public void setIncludeDefaultReferences(boolean bl) {
        this._includeDefaultReferences = bl;
    }

    public boolean getIncludeDefaultReferences() {
        return this._includeDefaultReferences;
    }

    protected String getIncludeDefaultReferencesParameter() {
        return "/nostdlib" + (this._includeDefaultReferences ? "-" : "+");
    }

    public void setOptimize(boolean bl) {
        this._optimize = bl;
    }

    public boolean getOptimize() {
        return this._optimize;
    }

    protected String getOptimizeParameter() {
        return "/optimize" + (this._optimize ? "+" : "-");
    }

    public void setIncremental(boolean bl) {
        this._incremental = bl;
    }

    public boolean getIncremental() {
        return this._incremental;
    }

    protected String getIncrementalParameter() {
        return "/incremental" + (this._incremental ? "+" : "-");
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return "/debug" + (this._debug ? "+" : "-");
    }

    public void setDocFile(String string) {
        this._docFile = ((Task)this).project.resolveFile(string);
    }

    protected String getDocFileParameter() {
        if (this._docFile != null) {
            return "/doc:" + this._docFile.toString();
        }
        return null;
    }

    public void setWarnLevel(int n) {
        this._warnLevel = n;
    }

    public int getWarnLevel() {
        return this._warnLevel;
    }

    protected String getWarnLevelParameter() {
        return "/warn:" + this._warnLevel;
    }

    public void setUnsafe(boolean bl) {
        this._unsafe = bl;
    }

    public boolean getUnsafe() {
        return this._unsafe;
    }

    protected String getUnsafeParameter() {
        return this._unsafe ? "/unsafe" : null;
    }

    public void setMainClass(String string) {
        this._mainClass = string;
    }

    public String getMainClass() {
        return this._mainClass;
    }

    protected String getMainClassParameter() {
        if (this._mainClass != null && this._mainClass.length() != 0) {
            return "/main:" + this._mainClass;
        }
        return null;
    }

    public void setExtraOptions(String string) {
        this._extraOptions = string;
    }

    public String getExtraOptions() {
        return this._extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this._extraOptions != null && this._extraOptions.length() != 0) {
            return this._extraOptions;
        }
        return null;
    }

    public void setSrcDir(String string) {
        this._srcDir = ((Task)this).project.resolveFile(string);
    }

    public void setDestDir(String string) {
        this._destDir = ((Task)this).project.resolveFile(string);
    }

    public void setTargetType(String string) throws BuildException {
        if (!((string = string.toLowerCase()).equals("exe") || string.equals("library") || string.equals("module") || string.equals("winexe"))) {
            throw new BuildException("targetType " + string + " is not a valid type");
        }
        this._targetType = string;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (this.notEmpty(this._targetType)) {
            return "/target:" + this._targetType;
        }
        return null;
    }

    public void setWin32Icon(String string) {
        this._win32icon = ((Task)this).project.resolveFile(string);
    }

    protected String getWin32IconParameter() {
        if (this._win32icon != null) {
            return "/win32icon:" + this._win32icon.toString();
        }
        return null;
    }

    public void setDefinitions(String string) {
        this._definitions = string;
    }

    protected String getDefinitionsParameter() {
        if (this.notEmpty(this._definitions)) {
            return "/define:" + this._definitions;
        }
        return null;
    }

    public void setAdditionalModules(String string) {
        this._additionalModules = string;
    }

    protected String getAdditionalModulesParameter() {
        if (this.notEmpty(this._additionalModules)) {
            return "/addmodule:" + this._additionalModules;
        }
        return null;
    }

    public void setOutputFile(String string) {
        this._outputFile = string;
    }

    protected String getOutputFileParameter() {
        if (this.notEmpty(this._outputFile)) {
            File file = ((Task)this).project.resolveFile(this._outputFile);
            return "/out:" + file.toString();
        }
        return null;
    }

    public void setFailOnError(boolean bl) {
        this._failOnError = bl;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    public void Clear() {
        this._targetType = null;
        this._win32icon = null;
        this._srcDir = null;
        this._destDir = null;
        this._mainClass = null;
        this._unsafe = false;
        this._warnLevel = 3;
        this._docFile = null;
        this._incremental = false;
        this._optimize = false;
        this._debug = true;
        this._references = null;
        this._failOnError = true;
        this._definitions = null;
        this._additionalModules = null;
        this._includeDefaultReferences = true;
        this._extraOptions = null;
    }

    protected boolean notEmpty(String string) {
        return string != null && string.length() != 0;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = ((Task)this).project.resolveFile(".");
        }
        NetCommand netCommand = new NetCommand((Task)this, "CSC", csc_exe_name);
        netCommand.setFailOnError(this.getFailFailOnError());
        netCommand.setTraceCommandLine(true);
        netCommand.addArgument("/nologo");
        netCommand.addArgument(this.getAdditionalModulesParameter());
        netCommand.addArgument(this.getDefinitionsParameter());
        netCommand.addArgument(this.getDebugParameter());
        netCommand.addArgument(this.getDocFileParameter());
        netCommand.addArgument(this.getIncrementalParameter());
        netCommand.addArgument(this.getMainClassParameter());
        netCommand.addArgument(this.getOptimizeParameter());
        netCommand.addArgument(this.getReferencesParameter());
        netCommand.addArgument(this.getTargetTypeParameter());
        netCommand.addArgument(this.getUnsafeParameter());
        netCommand.addArgument(this.getWarnLevelParameter());
        netCommand.addArgument(this.getWin32IconParameter());
        netCommand.addArgument(this.getOutputFileParameter());
        netCommand.addArgument(this.getIncludeDefaultReferencesParameter());
        netCommand.addArgument(this.getDefaultReferenceParameter());
        netCommand.addArgument(this.getExtraOptionsParameter());
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this._srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        this.log("compiling " + stringArray.length + " file" + (stringArray.length == 1 ? "" : "s"));
        String string = directoryScanner.getBasedir().toString();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            string2 = string + File.separator + string2;
            netCommand.addArgument(string2);
            ++n;
        }
        netCommand.runCommand();
    }
}

