/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCUpdate
extends ClearCase {
    private boolean m_Graphical = false;
    private boolean m_Overwrite = false;
    private boolean m_Rename = false;
    private boolean m_Ctime = false;
    private boolean m_Ptime = false;
    private String m_Log = null;
    public static final String FLAG_GRAPHICAL = "-graphical";
    public static final String FLAG_LOG = "-log";
    public static final String FLAG_OVERWRITE = "-overwrite";
    public static final String FLAG_NOVERWRITE = "-noverwrite";
    public static final String FLAG_RENAME = "-rename";
    public static final String FLAG_CURRENTTIME = "-ctime";
    public static final String FLAG_PRESERVETIME = "-ptime";

    public void execute() throws BuildException {
        Commandline commandline = new Commandline();
        Project project = this.getProject();
        int n = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(project.getBaseDir().getPath());
        }
        commandline.setExecutable(this.getClearToolCommand());
        commandline.createArgument().setValue("update");
        this.checkOptions(commandline);
        System.out.println(commandline.toString());
        n = this.run(commandline);
        if (n != 0) {
            String string = "Failed executing: " + commandline.toString();
            throw new BuildException(string, this.location);
        }
    }

    private void checkOptions(Commandline commandline) {
        if (this.getGraphical()) {
            commandline.createArgument().setValue(FLAG_GRAPHICAL);
        } else {
            if (this.getOverwrite()) {
                commandline.createArgument().setValue(FLAG_OVERWRITE);
            } else if (this.getRename()) {
                commandline.createArgument().setValue(FLAG_RENAME);
            } else {
                commandline.createArgument().setValue(FLAG_NOVERWRITE);
            }
            if (this.getCurrentTime()) {
                commandline.createArgument().setValue(FLAG_CURRENTTIME);
            } else if (this.getPreserveTime()) {
                commandline.createArgument().setValue(FLAG_PRESERVETIME);
            }
            this.getLogCommand(commandline);
        }
        commandline.createArgument().setValue(this.getViewPath());
    }

    public void setGraphical(boolean bl) {
        this.m_Graphical = bl;
    }

    public boolean getGraphical() {
        return this.m_Graphical;
    }

    public void setOverwrite(boolean bl) {
        this.m_Overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.m_Overwrite;
    }

    public void setRename(boolean bl) {
        this.m_Rename = bl;
    }

    public boolean getRename() {
        return this.m_Rename;
    }

    public void setCurrentTime(boolean bl) {
        this.m_Ctime = bl;
    }

    public boolean getCurrentTime() {
        return this.m_Ctime;
    }

    public void setPreserveTime(boolean bl) {
        this.m_Ptime = bl;
    }

    public boolean getPreserveTime() {
        return this.m_Ptime;
    }

    public void setLog(String string) {
        this.m_Log = string;
    }

    public String getLog() {
        return this.m_Log;
    }

    private void getLogCommand(Commandline commandline) {
        if (this.getLog() == null) {
            return;
        }
        commandline.createArgument().setValue(FLAG_LOG);
        commandline.createArgument().setValue(this.getLog());
    }
}

