/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import sun.tools.native2ascii.Main;

public class Native2Ascii
extends MatchingTask {
    private boolean reverse = false;
    private String encoding = null;
    private File srcDir = null;
    private File destDir = null;
    private String extension = null;
    private Mapper mapper;

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSrc(File file) {
        this.srcDir = file;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public void setExt(String string) {
        this.extension = string;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper", ((Task)this).location);
        }
        this.mapper = new Mapper(((Task)this).project);
        return this.mapper;
    }

    public void execute() throws BuildException {
        Object var1_1 = null;
        DirectoryScanner directoryScanner = null;
        if (this.srcDir == null) {
            this.srcDir = ((Task)this).project.resolveFile(".");
        }
        if (this.destDir == null) {
            throw new BuildException("The dest attribute must be set.");
        }
        if (this.srcDir.equals(this.destDir) && this.extension == null && this.mapper == null) {
            throw new BuildException("The ext attribute or a mapper must be set if src and dest dirs are the same.");
        }
        Object object = null;
        object = this.mapper == null ? (this.extension == null ? new IdentityMapper() : new ExtMapper()) : this.mapper.getImplementation();
        directoryScanner = this.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        stringArray = sourceFileScanner.restrict(stringArray, this.srcDir, this.destDir, object);
        int n = stringArray.length;
        if (n == 0) {
            return;
        }
        String string = "Converting " + n + " file" + (n != 1 ? "s" : "") + " from ";
        this.log(string + this.srcDir + " to " + this.destDir);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.convert(stringArray[n2], object.mapFileName(stringArray[n2])[0]);
            ++n2;
        }
    }

    private void convert(String string, String string2) throws BuildException {
        File file;
        Commandline commandline = new Commandline();
        if (this.reverse) {
            commandline.createArgument().setValue("-reverse");
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        File file2 = new File(this.srcDir, string);
        File file3 = new File(this.destDir, string2);
        commandline.createArgument().setFile(file2);
        commandline.createArgument().setFile(file3);
        if (file2.equals(file3)) {
            throw new BuildException("file " + file2 + " would overwrite its self");
        }
        String string3 = file3.getParent();
        if (string3 != null && !(file = new File(string3)).exists() && !file.mkdirs()) {
            throw new BuildException("cannot create parent directory " + string3);
        }
        this.log("converting " + string, 3);
        file = new Main();
        if (!file.convert(commandline.getArguments())) {
            throw new BuildException("conversion failed");
        }
    }

    private class ExtMapper
    implements FileNameMapper {
        private ExtMapper() {
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                return new String[]{string.substring(0, n) + Native2Ascii.this.extension};
            }
            return new String[]{string + Native2Ascii.this.extension};
        }
    }
}

