/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Filter
extends Task {
    private String token;
    private String value;
    private File filtersFile;

    public void setToken(String string) {
        this.token = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setFiltersfile(File file) {
        this.filtersFile = file;
    }

    public void execute() throws BuildException {
        boolean bl;
        boolean bl2 = this.filtersFile != null && this.token == null && this.value == null;
        boolean bl3 = bl = this.filtersFile == null && this.token != null && this.value != null;
        if (!bl2 && !bl) {
            throw new BuildException("both token and value parameters, or only a filtersFile parameter is required", this.location);
        }
        if (bl) {
            this.project.addFilter(this.token, this.value);
        }
        if (bl2) {
            this.readFilters();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readFilters() throws BuildException {
        this.log("Reading filters from " + this.filtersFile, 3);
        FileInputStream fileInputStream = null;
        try {
            try {
                Properties properties = new Properties();
                fileInputStream = new FileInputStream(this.filtersFile);
                properties.load(fileInputStream);
                Project project = this.getProject();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    project.addFilter(string, string2);
                }
            }
            catch (Exception exception) {
                throw new BuildException("Could not read filters from file: " + this.filtersFile);
            }
            Object var8_8 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }
}

