/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;

public class PDFResources
extends PDFObject {
    protected Hashtable fonts = new Hashtable();
    protected Vector xObjects = null;
    protected Vector patterns = new Vector();
    protected Vector shadings = new Vector();

    public PDFResources(int n) {
        super(n);
    }

    public void addFont(PDFFont pDFFont) {
        this.fonts.put(pDFFont.getName(), pDFFont);
    }

    public void addPattern(PDFPattern pDFPattern) {
        this.patterns.addElement(pDFPattern);
    }

    public void addShading(PDFShading pDFShading) {
        this.shadings.addElement(pDFShading);
    }

    public void setXObjects(Vector vector) {
        this.xObjects = vector;
    }

    public byte[] toPDF() {
        int n;
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.number) + " " + this.generation + " obj\n<< \n");
        if (!this.fonts.isEmpty()) {
            stringBuffer.append("/Font << ");
            object2 = this.fonts.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                stringBuffer.append("/" + (String)object + " " + ((PDFFont)this.fonts.get(object)).referencePDF() + " ");
            }
            stringBuffer.append(">> \n");
        }
        object2 = null;
        if (!this.shadings.isEmpty()) {
            stringBuffer.append("/Shading << ");
            int n2 = 0;
            while (n2 < this.shadings.size()) {
                object2 = (PDFShading)this.shadings.elementAt(n2);
                stringBuffer.append("/" + ((PDFShading)object2).getName() + " " + ((PDFObject)object2).referencePDF() + " ");
                ++n2;
            }
            stringBuffer.append(">> \n");
        }
        object2 = null;
        object = null;
        if (!this.patterns.isEmpty()) {
            stringBuffer.append("/Pattern << ");
            n = 0;
            while (n < this.patterns.size()) {
                object = (PDFPattern)this.patterns.elementAt(n);
                stringBuffer.append("/" + ((PDFPattern)object).getName() + " " + ((PDFObject)object).referencePDF() + " ");
                ++n;
            }
            stringBuffer.append(">> \n");
        }
        object = null;
        stringBuffer.append("/ProcSet [ /PDF /ImageC /Text ] ");
        if (!this.xObjects.isEmpty()) {
            stringBuffer = stringBuffer.append("/XObject <<");
            n = 1;
            while (n <= this.xObjects.size()) {
                stringBuffer = stringBuffer.append("/Im" + n + " " + ((PDFXObject)this.xObjects.elementAt(n - 1)).referencePDF() + " \n");
                ++n;
            }
            stringBuffer = stringBuffer.append(" >>\n");
        }
        stringBuffer = stringBuffer.append(">> \nendobj\n");
        return stringBuffer.toString().getBytes();
    }
}

