/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.TextState;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.Hyphenator;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.PageNumberInlineArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.CodePointMapping;

public class LineArea
extends Area {
    protected int lineHeight;
    protected int halfLeading;
    protected int nominalFontSize;
    protected int nominalGlyphHeight;
    protected int allocationHeight;
    protected int startIndent;
    protected int endIndent;
    private int placementOffset;
    private FontState currentFontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    int vAlign;
    protected int hyphenate;
    protected char hyphenationChar;
    protected int hyphenationPushCharacterCount;
    protected int hyphenationRemainCharacterCount;
    protected String language;
    protected String country;
    protected int finalWidth = 0;
    protected int embeddedLinkStart = 0;
    protected static final int NOTHING = 0;
    protected static final int WHITESPACE = 1;
    protected static final int TEXT = 2;
    protected int prev = 0;
    protected int spaceWidth = 0;
    protected Vector pendingAreas = new Vector();
    protected int pendingWidth = 0;
    protected boolean prevUlState = false;
    protected boolean prevOlState = false;
    protected boolean prevLTState = false;

    public LineArea(FontState fontState, int n, int n2, int n3, int n4, int n5, LineArea lineArea) {
        super(fontState);
        this.currentFontState = fontState;
        this.lineHeight = n;
        this.nominalFontSize = fontState.getFontSize();
        this.nominalGlyphHeight = fontState.getAscender() - fontState.getDescender();
        this.placementOffset = fontState.getAscender();
        this.contentRectangleWidth = n3 - n4 - n5;
        this.fontState = fontState;
        this.allocationHeight = this.nominalGlyphHeight;
        this.halfLeading = this.lineHeight - this.allocationHeight;
        this.startIndent = n4;
        this.endIndent = n5;
        if (lineArea != null) {
            Enumeration enumeration = lineArea.pendingAreas.elements();
            while (enumeration.hasMoreElements()) {
                this.pendingAreas.addElement(enumeration.nextElement());
            }
            this.pendingWidth = lineArea.getPendingWidth();
        }
    }

    public int addCharacter(char c, LinkSet linkSet, boolean bl) {
        WordArea wordArea = null;
        int n = this.getContentWidth() - this.getCurrentXPosition();
        int n2 = this.currentFontState.width(c);
        if (n2 > n) {
            return 1;
        }
        if (Character.isSpaceChar(c) && this.whiteSpaceCollapse == 1) {
            return 0;
        }
        wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new Character(c).toString(), n2);
        wordArea.setYOffset(this.placementOffset);
        wordArea.setUnderlined(bl);
        this.pendingAreas.addElement(wordArea);
        if (Character.isSpaceChar(c)) {
            this.spaceWidth = n2;
            this.prev = 1;
        } else {
            this.pendingWidth += n2;
            this.prev = 2;
        }
        return 0;
    }

    public void addInlineArea(Area area) {
        this.addPending();
        this.addChild(area);
        this.prev = 2;
        this.finalWidth += area.getContentWidth();
    }

    public void addInlineSpace(InlineSpace inlineSpace, int n) {
        this.addChild(inlineSpace);
        this.finalWidth += n;
    }

    public void addLeader(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = this.getContentWidth() - this.getCurrentXPosition();
        if (n10 <= n3 || n10 <= n4) {
            n9 = n10;
        } else if (n10 > n3 && n10 > n4) {
            n9 = n4;
        } else if (n3 > n4 && n3 < n10) {
            n9 = n3;
        }
        switch (n) {
            case 1: {
                int n11 = this.whiteSpaceCollapse;
                this.changeWhiteSpaceCollapse(2);
                this.pendingAreas.addElement(this.buildSimpleLeader(32, n9));
                this.changeWhiteSpaceCollapse(n11);
                break;
            }
            case 2: {
                LeaderArea leaderArea = new LeaderArea(this.fontState, this.red, this.green, this.blue, "", n9, n, n6, n5);
                leaderArea.setYOffset(this.placementOffset);
                this.pendingAreas.addElement(leaderArea);
                break;
            }
            case 3: {
                int n12;
                if (n7 < this.currentFontState.width(46)) {
                    n7 = 0;
                }
                if (n7 == 0) {
                    this.pendingAreas.addElement(this.buildSimpleLeader(46, n9));
                    break;
                }
                if (n8 == 2 && (n12 = this.getLeaderAlignIndent(n9, n7)) != 0) {
                    this.pendingAreas.addElement(new InlineSpace(n12, false));
                    this.pendingWidth += n12;
                    n9 -= n12;
                }
                InlineSpace inlineSpace = new InlineSpace(n7 - this.currentFontState.width(46), false);
                WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String("."), this.currentFontState.width(46));
                wordArea.setYOffset(this.placementOffset);
                int n13 = (int)Math.floor((double)n9 / (double)n7);
                int n14 = 0;
                while (n14 < n13) {
                    this.pendingAreas.addElement(wordArea);
                    this.pendingAreas.addElement(inlineSpace);
                    ++n14;
                }
                this.pendingAreas.addElement(new InlineSpace(n9 - n13 * n7));
                break;
            }
            case 4: {
                MessageHandler.errorln("leader-pattern=\"use-content\" not supported by this version of Fop");
                return;
            }
        }
        this.pendingWidth += n9;
        this.prev = 2;
    }

    public int addPageNumberCitation(String string, LinkSet linkSet) {
        int n = this.currentFontState.width(32) * 3;
        PageNumberInlineArea pageNumberInlineArea = new PageNumberInlineArea(this.currentFontState, this.red, this.green, this.blue, string, n);
        pageNumberInlineArea.setYOffset(this.placementOffset);
        this.pendingAreas.addElement(pageNumberInlineArea);
        this.pendingWidth += n;
        this.prev = 2;
        return -1;
    }

    public void addPending() {
        if (this.spaceWidth > 0) {
            this.addChild(new InlineSpace(this.spaceWidth));
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        Enumeration enumeration = this.pendingAreas.elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.addChild(box);
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new Vector();
    }

    public int addText(char[] cArray, int n, int n2, LinkSet linkSet, TextState textState) {
        if (n == -1) {
            return -1;
        }
        boolean bl = false;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        char[] cArray2 = new char[cArray.length];
        int n6 = 0;
        while (n6 < cArray.length) {
            cArray2[n6] = cArray[n6];
            ++n6;
        }
        int n7 = n;
        while (n7 < n2) {
            int n8 = cArray2[n7];
            if (n8 > 127) {
                int n9 = CodePointMapping.map[n8];
                if (n9 != 0) {
                    n8 = cArray2[n7] = n9;
                } else {
                    MessageHandler.error("ch" + n8 + "?");
                    cArray2[n7] = 35;
                    n8 = 35;
                }
            }
            int n10 = this.currentFontState.width(n8);
            if (n8 == 32 || n8 == 10 || n8 == 13 || n8 == 9) {
                if (this.prev == 1) {
                    if (this.whiteSpaceCollapse == 2) {
                        if (n8 == 32) {
                            this.spaceWidth += this.currentFontState.width(32);
                        } else {
                            if (n8 == 10) {
                                return n7;
                            }
                            if (n8 == 9) {
                                this.spaceWidth += 8 * this.currentFontState.width(32);
                            }
                        }
                    }
                } else if (this.prev == 2) {
                    Rectangle rectangle;
                    Box box;
                    if (this.spaceWidth > 0) {
                        InlineSpace inlineSpace = new InlineSpace(this.spaceWidth);
                        if (this.prevUlState) {
                            inlineSpace.setUnderlined(textState.getUnderlined());
                        }
                        if (this.prevOlState) {
                            inlineSpace.setOverlined(textState.getOverlined());
                        }
                        if (this.prevLTState) {
                            inlineSpace.setLineThrough(textState.getLineThrough());
                        }
                        this.addChild(inlineSpace);
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                    }
                    Enumeration enumeration = this.pendingAreas.elements();
                    while (enumeration.hasMoreElements()) {
                        box = (Box)enumeration.nextElement();
                        if (box instanceof InlineArea && linkSet != null) {
                            rectangle = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                            linkSet.addRect(rectangle, this);
                        }
                        this.addChild(box);
                    }
                    this.finalWidth += this.pendingWidth;
                    this.pendingWidth = 0;
                    this.pendingAreas = new Vector();
                    if (n4 > 0) {
                        box = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray2, n3, n4), n5);
                        ((InlineArea)box).setYOffset(this.placementOffset);
                        ((WordArea)box).setUnderlined(textState.getUnderlined());
                        this.prevUlState = textState.getUnderlined();
                        ((InlineArea)box).setOverlined(textState.getOverlined());
                        this.prevOlState = textState.getOverlined();
                        ((InlineArea)box).setLineThrough(textState.getLineThrough());
                        this.prevLTState = textState.getLineThrough();
                        ((InlineArea)box).setVerticalAlign(this.vAlign);
                        this.addChild(box);
                        if (linkSet != null) {
                            rectangle = new Rectangle(this.finalWidth, 0, ((Area)box).getContentWidth(), this.fontState.getFontSize());
                            linkSet.addRect(rectangle, this);
                        }
                        this.finalWidth += n5;
                        n5 = 0;
                    }
                    this.prev = 1;
                    this.embeddedLinkStart = 0;
                    this.spaceWidth = this.currentFontState.width(32);
                    if (this.whiteSpaceCollapse == 2) {
                        if (n8 == 10) {
                            return n7;
                        }
                        if (n8 == 9) {
                            this.spaceWidth = this.currentFontState.width(32);
                        }
                    }
                } else if (this.whiteSpaceCollapse == 2) {
                    this.prev = 1;
                    this.spaceWidth = this.currentFontState.width(32);
                } else {
                    ++n;
                }
            } else {
                if (this.prev == 1) {
                    n5 = n10;
                    if (this.finalWidth + this.spaceWidth + n5 > this.getContentWidth()) {
                        if (bl) {
                            MessageHandler.error(">");
                        }
                        if (this.wrapOption == 1) {
                            return n7;
                        }
                    }
                    this.prev = 2;
                    n3 = n7;
                    n4 = 1;
                } else if (this.prev == 2) {
                    ++n4;
                    n5 += n10;
                } else {
                    this.prev = 2;
                    n3 = n7;
                    n4 = 1;
                    n5 = n10;
                }
                if (this.finalWidth + this.spaceWidth + this.pendingWidth + n5 > this.getContentWidth()) {
                    if (n3 == n) {
                        bl = true;
                        if (this.finalWidth > 0) {
                            return n3;
                        }
                    } else if (this.wrapOption == 1) {
                        if (this.hyphenate == 1) {
                            return this.doHyphenation(cArray2, n7, n3, this.getContentWidth() - (this.finalWidth + this.spaceWidth + this.pendingWidth));
                        }
                        return n3;
                    }
                }
            }
            ++n7;
        }
        if (this.prev == 2) {
            if (this.spaceWidth > 0) {
                InlineSpace inlineSpace = new InlineSpace(this.spaceWidth);
                if (this.prevUlState) {
                    inlineSpace.setUnderlined(textState.getUnderlined());
                }
                if (this.prevOlState) {
                    inlineSpace.setOverlined(textState.getOverlined());
                }
                if (this.prevLTState) {
                    inlineSpace.setLineThrough(textState.getLineThrough());
                }
                this.pendingAreas.addElement(inlineSpace);
                this.pendingWidth += this.spaceWidth;
                this.spaceWidth = 0;
            }
            WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray2, n3, n4), n5);
            wordArea.setYOffset(this.placementOffset);
            wordArea.setUnderlined(textState.getUnderlined());
            this.prevUlState = textState.getUnderlined();
            wordArea.setOverlined(textState.getOverlined());
            this.prevOlState = textState.getOverlined();
            wordArea.setLineThrough(textState.getLineThrough());
            this.prevLTState = textState.getLineThrough();
            wordArea.setVerticalAlign(this.vAlign);
            if (linkSet != null) {
                Rectangle rectangle = new Rectangle(this.finalWidth + this.spaceWidth + this.embeddedLinkStart, this.spaceWidth, wordArea.getContentWidth(), this.fontState.getFontSize());
                linkSet.addRect(rectangle, this);
            }
            this.embeddedLinkStart += n5;
            this.pendingAreas.addElement(wordArea);
            this.pendingWidth += n5;
            n5 = 0;
        }
        if (bl) {
            MessageHandler.error(">");
        }
        return -1;
    }

    private void addWord(char c, StringBuffer stringBuffer) {
        WordArea wordArea;
        String string = stringBuffer.toString();
        int n = this.currentFontState.width(c);
        if (c == ' ') {
            this.addChild(new InlineSpace(n));
        } else {
            wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new Character(c).toString(), 1);
            wordArea.setYOffset(this.placementOffset);
            this.addChild(wordArea);
        }
        int n2 = this.getWordWidth(string);
        wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, string, string.length());
        wordArea.setYOffset(this.placementOffset);
        this.addChild(wordArea);
        this.finalWidth += n + n2;
    }

    public void align(int n) {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.endIndent += n2;
                break;
            }
            case 2: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.startIndent += n2;
                break;
            }
            case 1: {
                n2 = (this.getContentWidth() - this.finalWidth) / 2;
                this.startIndent += n2;
                this.endIndent += n2;
                break;
            }
            case 4: {
                InlineSpace inlineSpace;
                Object object;
                Vector<InlineSpace> vector = new Vector<InlineSpace>();
                int n3 = 0;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Box)enumeration.nextElement();
                    if (!(object instanceof InlineSpace) || !(inlineSpace = (InlineSpace)object).getResizeable()) continue;
                    vector.addElement(inlineSpace);
                    ++n3;
                }
                n2 = n3 > 0 ? (this.getContentWidth() - this.finalWidth) / n3 : 0;
                object = vector.elements();
                while (object.hasMoreElements()) {
                    inlineSpace = (InlineSpace)object.nextElement();
                    int n4 = inlineSpace.getSize();
                    inlineSpace.setSize(n4 + n2);
                }
                break;
            }
        }
    }

    private InlineArea buildSimpleLeader(int n, int n2) {
        int n3 = (int)Math.floor(n2 / this.currentFontState.width(n));
        char[] cArray = new char[n3];
        char c = (char)n;
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = c;
            ++n4;
        }
        WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray), n2);
        wordArea.setYOffset(this.placementOffset);
        return wordArea;
    }

    public void changeColor(float f, float f2, float f3) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    public void changeFont(FontState fontState) {
        this.currentFontState = fontState;
    }

    public void changeHyphenation(String string, String string2, int n, char c, int n2, int n3) {
        this.language = string;
        this.country = string2;
        this.hyphenate = n;
        this.hyphenationChar = c;
        this.hyphenationPushCharacterCount = n2;
        this.hyphenationRemainCharacterCount = n3;
    }

    public void changeVerticalAlign(int n) {
        this.vAlign = n;
    }

    public void changeWhiteSpaceCollapse(int n) {
        this.whiteSpaceCollapse = n;
    }

    public void changeWrapOption(int n) {
        this.wrapOption = n;
    }

    public int doHyphenation(char[] cArray, int n, int n2, int n3) {
        Hyphenation hyphenation;
        char c;
        String string;
        if (this.language.equalsIgnoreCase("none")) {
            MessageHandler.errorln("if property 'hyphenate' is used, a language must be specified");
            return n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        char c2 = ' ';
        int n4 = this.currentFontState.width(this.hyphenationChar);
        n3 -= n4;
        if (cArray[n2] == '\"' || cArray[n2] == '\'') {
            stringBuffer.append(cArray[n2]);
            string = this.getHyphenationWord(cArray, n2 + 1);
        } else {
            string = this.getHyphenationWord(cArray, n2);
        }
        if (this.getWordWidth(string) < n3 && ((c = cArray[n2 + string.length()]) == '-' || c == '/')) {
            stringBuffer2 = new StringBuffer(string);
            stringBuffer2 = stringBuffer2.append(c);
            string = this.getHyphenationWord(cArray, n2 + string.length() + 1);
            n3 -= this.getWordWidth(string) + this.currentFontState.width(c);
        }
        if ((hyphenation = Hyphenator.hyphenate(this.language, this.country, string, this.hyphenationRemainCharacterCount, this.hyphenationPushCharacterCount)) == null && stringBuffer2 == null) {
            if (stringBuffer.length() > 0) {
                return n2 - 1;
            }
            return n2;
        }
        if (hyphenation == null && stringBuffer2 != null) {
            stringBuffer.append((Object)stringBuffer2);
            this.addWord(c2, stringBuffer);
            return n2 + stringBuffer.length();
        }
        if (hyphenation != null && stringBuffer2 == null) {
            int n5 = this.getFinalHyphenationPoint(hyphenation, n3);
            if (n5 != -1) {
                stringBuffer.append(hyphenation.getPreHyphenText(n5));
                stringBuffer.append(this.hyphenationChar);
                this.addWord(c2, stringBuffer);
                return n2 + stringBuffer.length() - 1;
            }
        } else if (hyphenation != null && stringBuffer2 != null) {
            int n6 = this.getFinalHyphenationPoint(hyphenation, n3);
            if (n6 != -1) {
                stringBuffer.append((Object)stringBuffer2.append(hyphenation.getPreHyphenText(n6)));
                stringBuffer.append(this.hyphenationChar);
                this.addWord(c2, stringBuffer);
                return n2 + stringBuffer.length() - 1;
            }
            stringBuffer.append((Object)stringBuffer2);
            this.addWord(c2, stringBuffer);
            return n2 + stringBuffer.length();
        }
        return n2;
    }

    private int getCurrentXPosition() {
        return this.finalWidth + this.spaceWidth + this.startIndent + this.pendingWidth;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    private int getFinalHyphenationPoint(Hyphenation hyphenation, int n) {
        int[] nArray = hyphenation.getHyphenationPoints();
        int n2 = nArray.length;
        int n3 = -1;
        String string = "";
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            string = hyphenation.getPreHyphenText(n4);
            if (this.getWordWidth(string) > n) break;
            n3 = n4++;
        }
        return n3;
    }

    public int getHeight() {
        return this.allocationHeight;
    }

    private String getHyphenationWord(char[] cArray, int n) {
        boolean bl = false;
        int n2 = 0;
        char[] cArray2 = new char[100];
        while (!bl && n + n2 < cArray.length) {
            char c = cArray[n + n2];
            if (Character.isLetter(c)) {
                cArray2[n2] = c;
                ++n2;
                continue;
            }
            bl = true;
        }
        return new String(cArray2, 0, n2);
    }

    private int getLeaderAlignIndent(int n, int n2) {
        double d = this.getCurrentXPosition();
        double d2 = Math.ceil(d / (double)n2);
        double d3 = (double)n2 * d2 - d;
        return (int)d3;
    }

    public Vector getPendingAreas() {
        return this.pendingAreas;
    }

    public int getPendingWidth() {
        return this.pendingWidth;
    }

    public int getPlacementOffset() {
        return this.placementOffset;
    }

    public int getRemainingWidth() {
        return this.getContentWidth() - this.getCurrentXPosition();
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    private int getWordWidth(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while (n3 < n) {
            n2 += this.currentFontState.width(cArray[n3]);
            ++n3;
        }
        return n2;
    }

    public boolean isEmpty() {
        return (this.pendingAreas.size() > 0 || this.children.size() > 0) ^ true;
    }

    public void render(Renderer renderer) {
        renderer.renderLineArea(this);
    }

    public void setLinkSet(LinkSet linkSet) {
    }

    public void setPendingAreas(Vector vector) {
        this.pendingAreas = vector;
    }

    public void setPendingWidth(int n) {
        this.pendingWidth = n;
    }

    public void verticalAlign() {
        int n = -this.placementOffset;
        int n2 = this.allocationHeight;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            int n4;
            Box box = (Box)enumeration.nextElement();
            if (!(box instanceof InlineArea)) continue;
            InlineArea inlineArea = (InlineArea)box;
            if (inlineArea instanceof WordArea) {
                inlineArea.setYOffset(this.placementOffset);
            }
            if (inlineArea.getHeight() > n2) {
                n2 = inlineArea.getHeight();
            }
            if ((n4 = inlineArea.getVerticalAlign()) == 4) {
                n3 = this.fontState.getAscender();
                inlineArea.setYOffset((int)((double)this.placementOffset - (double)n3 / 3.0));
                continue;
            }
            if (n4 != 3) continue;
            n3 = this.fontState.getAscender();
            inlineArea.setYOffset((int)((double)this.placementOffset + (double)n3 / 3.0));
        }
        this.allocationHeight = n2;
    }
}

