/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.SVGImage;
import org.apache.fop.image.analyser.AbstractImageReader;
import org.apache.fop.svg.SVGDriver;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SVGReader
extends AbstractImageReader {
    public String getMimeType() {
        return "image/svg-xml";
    }

    protected boolean loadImage() {
        try {
            SVGDriver sVGDriver = new SVGDriver();
            sVGDriver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            sVGDriver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            XMLReader xMLReader = SVGImage.createParser();
            sVGDriver.buildSVGTree(xMLReader, new InputSource(this.imageStream));
            SVGDocument sVGDocument = sVGDriver.getSVGDocument();
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            this.width = (int)sVGSVGElement.getWidth().getBaseVal().getValue() * 1000;
            this.height = (int)sVGSVGElement.getHeight().getBaseVal().getValue() * 1000;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean verifySignature(BufferedInputStream bufferedInputStream) throws IOException {
        this.imageStream = bufferedInputStream;
        return this.loadImage();
    }
}

