/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml.scanner;

import java.io.IOException;
import java.io.Reader;
import org.apache.batik.util.XMLUtilities;
import org.apache.batik.xml.scanner.AbstractScanner;
import org.apache.batik.xml.scanner.LexicalException;
import org.apache.batik.xml.scanner.LexicalUnits;

public class DocumentScanner
extends AbstractScanner {
    public static final int DTD_DECLARATIONS_CONTEXT = 1;
    public static final int DQUOTED_ATTRIBUTE_CONTEXT = 2;
    public static final int SQUOTED_ATTRIBUTE_CONTEXT = 3;
    public static final int DQUOTED_ENTITY_VALUE_CONTEXT = 4;
    public static final int SQUOTED_ENTITY_VALUE_CONTEXT = 5;
    public static final int ELEMENT_DECLARATION_CONTEXT = 6;
    public static final int ENTITY_CONTEXT = 7;
    public static final int NOTATION_CONTEXT = 8;
    public static final int ATTLIST_CONTEXT = 9;
    public static final int DOCUMENT_START_CONTEXT = 10;
    public static final int TOP_LEVEL_CONTEXT = 11;
    public static final int PI_CONTEXT = 12;
    public static final int START_TAG_CONTEXT = 13;
    public static final int DOCTYPE_CONTEXT = 14;
    public static final int XML_DECL_CONTEXT = 15;
    public static final int CONTENT_CONTEXT = 16;
    public static final int CDATA_SECTION_CONTEXT = 17;
    public static final int END_TAG_CONTEXT = 18;
    public static final int NOTATION_TYPE_CONTEXT = 19;
    public static final int ENUMERATION_CONTEXT = 20;
    protected int context = 10;
    protected int depth;
    protected boolean piEndRead;
    protected boolean cdataEndRead;
    protected boolean inDTD;
    protected char stringDelimiter;

    public DocumentScanner(Reader reader) throws LexicalException {
        super(reader);
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setContext(int n) {
        this.context = n;
    }

    public int getContext() {
        return this.context;
    }

    public char getStringDelimiter() {
        return this.stringDelimiter;
    }

    public char[] currentValue() {
        if (this.value == null) {
            this.value = LexicalUnits.VALUES[this.type];
            if (this.value == null) {
                int n = this.inputBuffer.contentSize();
                if (this.buffer.length < n) {
                    this.buffer = new char[n];
                }
                this.inputBuffer.readContent(this.buffer);
                int n2 = this.inputBuffer.current();
                int n3 = n2 == -1 ? 0 : 1;
                switch (this.type) {
                    case 14: 
                    case 15: 
                    case 23: 
                    case 28: {
                        ++n3;
                        break;
                    }
                    case 5: {
                        n3 += 2;
                        break;
                    }
                    case 7: {
                        n3 += 3;
                        break;
                    }
                    case 13: {
                        if (!this.lastFragment) break;
                        ++n3;
                        break;
                    }
                    case 16: {
                        if (!this.cdataEndRead) break;
                        n3 += 3;
                    }
                }
                this.value = new char[n - n3];
                int n4 = 0;
                while (n4 < this.value.length) {
                    this.value[n4] = this.buffer[n4];
                    ++n4;
                }
            }
        }
        return this.value;
    }

    public int next() throws LexicalException {
        return this.next(this.context);
    }

    public int next(int n) throws LexicalException {
        this.lastFragment = false;
        try {
            this.inputBuffer.unsetMark();
            this.inputBuffer.setMark();
            this.value = null;
            switch (n) {
                case 10: {
                    return this.nextInDocumentStart();
                }
                case 11: {
                    return this.nextInTopLevel();
                }
                case 12: {
                    return this.nextInPI();
                }
                case 13: {
                    return this.nextInStartTag();
                }
                case 2: {
                    return this.nextInAttributeValue('\"');
                }
                case 3: {
                    return this.nextInAttributeValue('\'');
                }
                case 16: {
                    return this.nextInContent();
                }
                case 18: {
                    return this.nextInEndTag();
                }
                case 17: {
                    return this.nextInCDATASection();
                }
                case 15: {
                    return this.nextInXMLDecl();
                }
                case 14: {
                    return this.nextInDoctype();
                }
                case 1: {
                    return this.nextInDTDDeclarations();
                }
                case 6: {
                    return this.nextInElementDeclaration();
                }
                case 9: {
                    return this.nextInAttList();
                }
                case 8: {
                    return this.nextInNotation();
                }
                case 7: {
                    return this.nextInEntity();
                }
                case 4: {
                    return this.nextInEntityValue('\"');
                }
                case 5: {
                    return this.nextInEntityValue('\'');
                }
                case 19: {
                    return this.nextInNotationType();
                }
                case 20: {
                    return this.nextInEnumeration();
                }
            }
            throw new RuntimeException("Internal error: Invalid Context");
        }
        catch (IOException iOException) {
            throw this.createException(iOException.getLocalizedMessage());
        }
    }

    protected int nextInElementDeclaration() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                this.inputBuffer.next();
                this.context = 1;
                this.type = 10;
                return 10;
            }
            case 37: {
                this.inputBuffer.next();
                this.readName(28);
                if (this.inputBuffer.current() != 59) {
                    throw this.createException("parameter.entity");
                }
                this.inputBuffer.next();
                return this.type;
            }
            case 69: {
                return this.readIdentifier("MPTY", 35, 11);
            }
            case 65: {
                return this.readIdentifier("NY", 36, 11);
            }
            case 63: {
                this.inputBuffer.next();
                this.type = 37;
                return 37;
            }
            case 43: {
                this.inputBuffer.next();
                this.type = 38;
                return 38;
            }
            case 42: {
                this.inputBuffer.next();
                this.type = 39;
                return 39;
            }
            case 40: {
                this.inputBuffer.next();
                this.type = 40;
                return 40;
            }
            case 41: {
                this.inputBuffer.next();
                this.type = 41;
                return 41;
            }
            case 124: {
                this.inputBuffer.next();
                this.type = 42;
                return 42;
            }
            case 44: {
                this.inputBuffer.next();
                this.type = 43;
                return 43;
            }
            case 35: {
                return this.readIdentifier("PCDATA", 44, -1);
            }
        }
        return this.readName(11);
    }

    protected int nextInAttList() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                this.inputBuffer.next();
                this.context = 1;
                this.type = 10;
                return 10;
            }
            case 37: {
                this.readName(28);
                if (n != 59) {
                    throw this.createException("parameter.entity");
                }
                this.inputBuffer.next();
                return this.type;
            }
            case 67: {
                return this.readIdentifier("DATA", 45, 11);
            }
            case 73: {
                n = this.inputBuffer.next();
                if (n != 68) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 46;
                }
                if (n != 82) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 69) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 70) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 47;
                }
                if (n != 83) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 48;
                }
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                }
                this.type = 11;
                return 11;
            }
            case 78: {
                n = this.inputBuffer.next();
                switch (n) {
                    default: {
                        while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                        }
                        this.type = 11;
                        return 11;
                    }
                    case 79: {
                        this.context = 19;
                        return this.readIdentifier("TATION", 57, 11);
                    }
                    case 77: 
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 84) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 79) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 75) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 69) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 78) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 49;
                }
                if (n != 83) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 50;
                }
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                }
                this.type = 11;
                return 11;
            }
            case 69: {
                n = this.inputBuffer.next();
                if (n != 78) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 84) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 73) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                if (n != 84) {
                    while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                    }
                    this.type = 11;
                    return 11;
                }
                n = this.inputBuffer.next();
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                switch (n) {
                    case 89: {
                        n = this.inputBuffer.next();
                        if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                            return 51;
                        }
                        while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                        }
                        this.type = 11;
                        return 11;
                    }
                    case 73: {
                        n = this.inputBuffer.next();
                        if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                            return 11;
                        }
                        if (n != 69) {
                            while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                            }
                            this.type = 11;
                            return 11;
                        }
                        n = this.inputBuffer.next();
                        if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                            return 11;
                        }
                        if (n != 83) {
                            while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                            }
                            this.type = 11;
                            return 11;
                        }
                        return 52;
                    }
                }
                if (n == -1 || !XMLUtilities.isXMLNameCharacter((char)n)) {
                    return 11;
                }
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                }
                this.type = 11;
                return 11;
            }
            case 34: {
                this.stringDelimiter = (char)34;
                n = this.inputBuffer.next();
                if (n == -1) {
                    throw this.createException("eof");
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                if (n != 34 && n != 38) {
                    while ((n = this.inputBuffer.next()) != -1 && n != 34 && n != 38) {
                    }
                }
                switch (n) {
                    case 38: {
                        this.context = 2;
                        break;
                    }
                    case 34: {
                        this.lastFragment = true;
                        this.inputBuffer.next();
                        break;
                    }
                    default: {
                        throw this.createException("character");
                    }
                }
                this.type = 13;
                return 13;
            }
            case 39: {
                this.stringDelimiter = (char)39;
                n = this.inputBuffer.next();
                if (n == -1) {
                    throw this.createException("eof");
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                if (n != 39 && n != 38) {
                    while ((n = this.inputBuffer.next()) != -1 && n != 39 && n != 38) {
                    }
                }
                switch (n) {
                    case 38: {
                        this.context = 3;
                        break;
                    }
                    case 39: {
                        this.lastFragment = true;
                        this.inputBuffer.next();
                        break;
                    }
                    default: {
                        throw this.createException("character");
                    }
                }
                this.type = 13;
                return 13;
            }
            case 35: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 82: {
                        return this.readIdentifier("EQUIRED", 53, -1);
                    }
                    case 73: {
                        return this.readIdentifier("MPLIED", 54, -1);
                    }
                    case 70: {
                        return this.readIdentifier("IXED", 55, -1);
                    }
                }
                throw this.createException("character");
            }
            case 40: {
                this.inputBuffer.next();
                this.context = 20;
                this.type = 40;
                return 40;
            }
        }
        return this.readName(11);
    }

    protected int nextInNotationType() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 124: {
                this.inputBuffer.next();
                this.type = 42;
                return 42;
            }
            case 40: {
                this.inputBuffer.next();
                this.type = 40;
                return 40;
            }
            case 41: {
                this.inputBuffer.next();
                this.context = 9;
                this.type = 41;
                return 41;
            }
        }
        return this.readName(11);
    }

    protected int nextInEnumeration() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 124: {
                this.inputBuffer.next();
                this.type = 42;
                return 42;
            }
            case 41: {
                this.inputBuffer.next();
                this.context = 9;
                this.type = 41;
                return 41;
            }
        }
        return this.readNmtoken();
    }

    protected int nextInNotation() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                this.inputBuffer.next();
                this.context = 1;
                this.type = 10;
                return 10;
            }
            case 37: {
                this.readName(28);
                if (n != 59) {
                    throw this.createException("parameter.entity");
                }
                this.inputBuffer.next();
                return this.type;
            }
            case 83: {
                return this.readIdentifier("YSTEM", 24, 11);
            }
            case 80: {
                return this.readIdentifier("UBLIC", 25, 11);
            }
            case 34: {
                this.stringDelimiter = (char)34;
                return this.readString();
            }
            case 39: {
                this.stringDelimiter = (char)39;
                return this.readString();
            }
        }
        return this.readName(11);
    }

    protected int nextInEntity() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                this.inputBuffer.next();
                this.context = 1;
                this.type = 10;
                return 10;
            }
            case 37: {
                this.inputBuffer.next();
                this.type = 33;
                return 33;
            }
            case 83: {
                return this.readIdentifier("YSTEM", 24, 11);
            }
            case 80: {
                return this.readIdentifier("UBLIC", 25, 11);
            }
            case 78: {
                return this.readIdentifier("DATA", 34, 11);
            }
            case 34: {
                this.stringDelimiter = (char)34;
                n = this.inputBuffer.next();
                if (n == -1) {
                    throw this.createException("eof");
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                if (n != 34 && n != 38 && n != 37) {
                    while ((n = this.inputBuffer.next()) != -1 && n != 34 && n != 38 && n != 37) {
                    }
                }
                switch (n) {
                    default: {
                        throw this.createException("character");
                    }
                    case 37: 
                    case 38: {
                        this.context = 4;
                        break;
                    }
                    case 34: {
                        this.inputBuffer.next();
                        this.lastFragment = true;
                    }
                }
                this.type = 13;
                return 13;
            }
            case 39: {
                this.stringDelimiter = (char)39;
                n = this.inputBuffer.next();
                if (n == -1) {
                    throw this.createException("eof");
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                if (n != 39 && n != 38 && n != 37) {
                    while ((n = this.inputBuffer.next()) != -1 && n != 39 && n != 38 && n != 37) {
                    }
                }
                switch (n) {
                    default: {
                        throw this.createException("character");
                    }
                    case 37: 
                    case 38: {
                        this.context = 5;
                        break;
                    }
                    case 39: {
                        this.lastFragment = true;
                        this.inputBuffer.next();
                    }
                }
                this.type = 13;
                return 13;
            }
        }
        return this.readName(11);
    }

    protected int nextInEntityValue(char c) throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 38: {
                return this.readReference();
            }
            case 37: {
                this.inputBuffer.next();
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                this.readName(28);
                if (this.inputBuffer.current() != 59) {
                    throw this.createException("parameter.entity");
                }
                this.inputBuffer.next();
                return this.type;
            }
        }
        while (n != -1 && n != c && n != 38 && n != 37) {
            n = this.inputBuffer.next();
        }
        switch (n) {
            case -1: {
                throw this.createException("eof");
            }
            case 34: 
            case 39: {
                this.lastFragment = true;
                this.inputBuffer.next();
                this.context = 7;
            }
        }
        this.type = 13;
        return 13;
    }

    protected int nextInDocumentStart() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.context = 11;
                this.type = 1;
                return 1;
            }
            case 60: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 63: {
                        n = this.inputBuffer.next();
                        if (n == -1 || !XMLUtilities.isXMLNameFirstCharacter((char)n)) {
                            throw this.createException("pi.target");
                        }
                        this.inputBuffer.unsetMark();
                        this.inputBuffer.setMark();
                        this.context = 12;
                        int n2 = this.inputBuffer.next();
                        if (n2 == -1 || !XMLUtilities.isXMLNameCharacter((char)n2)) {
                            this.type = 3;
                            return 3;
                        }
                        int n3 = this.inputBuffer.next();
                        if (n3 == -1 || !XMLUtilities.isXMLNameCharacter((char)n3)) {
                            this.type = 3;
                            return 3;
                        }
                        int n4 = this.inputBuffer.next();
                        if (n4 != -1 && XMLUtilities.isXMLNameCharacter((char)n4)) {
                            while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
                            }
                            this.type = 3;
                            return 3;
                        }
                        if (n == 120 && n2 == 109 && n3 == 108) {
                            this.context = 15;
                            this.type = 4;
                            return 4;
                        }
                        if (!(n != 120 && n != 88 || n2 != 109 && n2 != 77 || n3 != 108 && n3 != 76)) {
                            throw this.createException("xml.reserved");
                        }
                        this.type = 3;
                        return 3;
                    }
                    case 33: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 45: {
                                return this.readComment();
                            }
                            case 68: {
                                this.context = 14;
                                return this.readIdentifier("OCTYPE", 8, -1);
                            }
                        }
                        throw this.createException("comment.or.doctype");
                    }
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                this.context = 13;
                ++this.depth;
                return this.readName(2);
            }
            case -1: {
                throw this.createException("eof");
            }
        }
        throw this.createException("character");
    }

    protected int nextInTopLevel() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 60: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 63: {
                        this.context = 12;
                        return this.readPIStart();
                    }
                    case 33: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 45: {
                                return this.readComment();
                            }
                            case 68: {
                                this.context = 14;
                                return this.readIdentifier("OCTYPE", 8, -1);
                            }
                        }
                        throw this.createException("character");
                    }
                }
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                this.context = 13;
                ++this.depth;
                return this.readName(2);
            }
            case -1: {
                this.type = 0;
                return 0;
            }
        }
        throw this.createException("character");
    }

    protected int nextInPI() throws IOException, LexicalException {
        if (this.piEndRead) {
            this.piEndRead = false;
            this.context = this.depth == 0 ? 11 : 16;
            this.type = 6;
            return 6;
        }
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 63: {
                n = this.inputBuffer.next();
                if (n != 62) {
                    throw this.createException("pi.end");
                }
                n = this.inputBuffer.next();
                this.context = this.inDTD ? 1 : (this.depth == 0 ? 11 : 16);
                this.type = 6;
                return 6;
            }
        }
        while ((n = this.inputBuffer.next()) != -1 && n != 63 || (n = this.inputBuffer.next()) != -1 && n != 62) {
        }
        n = this.inputBuffer.next();
        this.piEndRead = true;
        this.type = 5;
        return 5;
    }

    protected int nextInStartTag() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 47: {
                n = this.inputBuffer.next();
                if (n != 62) {
                    throw this.createException("tag.end");
                }
                n = this.inputBuffer.next();
                this.context = --this.depth == 0 ? 11 : 16;
                this.type = 9;
                return 9;
            }
            case 62: {
                n = this.inputBuffer.next();
                this.context = 16;
                this.type = 10;
                return 10;
            }
            case 61: {
                n = this.inputBuffer.next();
                this.type = 12;
                return 12;
            }
            case 34: {
                this.stringDelimiter = (char)34;
                n = this.inputBuffer.next();
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                block27: while (true) {
                    switch (n) {
                        case -1: 
                        case 34: 
                        case 38: 
                        case 60: {
                            break block27;
                        }
                        default: {
                            n = this.inputBuffer.next();
                            continue block27;
                        }
                    }
                    break;
                }
                switch (n) {
                    case 38: {
                        this.context = 2;
                        break;
                    }
                    case 34: {
                        this.lastFragment = true;
                        this.inputBuffer.next();
                        break;
                    }
                    case 60: {
                        throw this.createException("character");
                    }
                    case -1: {
                        throw this.createException("eof");
                    }
                }
                this.type = 13;
                return 13;
            }
            case 39: {
                this.stringDelimiter = (char)39;
                n = this.inputBuffer.next();
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                block28: while (true) {
                    switch (n) {
                        case -1: 
                        case 38: 
                        case 39: 
                        case 60: {
                            break block28;
                        }
                        default: {
                            n = this.inputBuffer.next();
                            continue block28;
                        }
                    }
                    break;
                }
                switch (n) {
                    case 38: {
                        this.context = 3;
                        break;
                    }
                    case 39: {
                        this.lastFragment = true;
                        this.inputBuffer.next();
                        break;
                    }
                    case 60: {
                        throw this.createException("character");
                    }
                    case -1: {
                        throw this.createException("eof");
                    }
                }
                this.type = 13;
                return 13;
            }
        }
        return this.readName(11);
    }

    protected int nextInAttributeValue(char c) throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        if (n == -1) {
            return 0;
        }
        if (n == 38) {
            return this.readReference();
        }
        block9: while (true) {
            switch (n) {
                case -1: 
                case 38: 
                case 60: {
                    break block9;
                }
                case 34: 
                case 39: {
                    if (n == c) break block9;
                }
                default: {
                    n = this.inputBuffer.next();
                    continue block9;
                }
            }
            break;
        }
        switch (n) {
            case -1: {
                break;
            }
            case 60: {
                throw this.createException("character");
            }
            case 34: 
            case 39: {
                this.lastFragment = true;
                this.inputBuffer.next();
                this.context = this.inDTD ? 9 : 13;
            }
        }
        this.type = 13;
        return 13;
    }

    protected int nextInContent() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case -1: {
                this.type = 0;
                return 0;
            }
            case 38: {
                return this.readReference();
            }
            case 60: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 63: {
                        this.context = 12;
                        return this.readPIStart();
                    }
                    case 33: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 45: {
                                return this.readComment();
                            }
                            case 91: {
                                this.context = 17;
                                return this.readIdentifier("CDATA[", 18, -1);
                            }
                        }
                        throw this.createException("character");
                    }
                    case 47: {
                        n = this.inputBuffer.next();
                        this.inputBuffer.unsetMark();
                        this.inputBuffer.setMark();
                        this.context = 18;
                        return this.readName(17);
                    }
                }
                ++this.depth;
                this.inputBuffer.unsetMark();
                this.inputBuffer.setMark();
                this.context = 13;
                return this.readName(2);
            }
        }
        while (n != -1 && n != 38 && n != 60) {
            n = this.inputBuffer.next();
        }
        this.type = 16;
        return 16;
    }

    protected int nextInEndTag() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                if (--this.depth < 0) {
                    throw this.createException("end.tag");
                }
                this.context = this.depth == 0 ? 11 : 16;
                this.inputBuffer.next();
                this.type = 10;
                return 10;
            }
        }
        throw this.createException("character");
    }

    /*
     * Unable to fully structure code
     */
    protected int nextInCDATASection() throws IOException, LexicalException {
        if (this.cdataEndRead) {
            this.cdataEndRead = false;
            this.context = 16;
            this.type = 19;
            return 19;
        }
        var1_1 = this.inputBuffer.current();
        ** GOTO lbl12
        {
            var1_1 = this.inputBuffer.next();
            do {
                if (var1_1 != 93) continue block0;
                if (var1_1 != -1 && (var1_1 = this.inputBuffer.next()) == 93 && (var1_1 = this.inputBuffer.next()) == 62) break block0;
lbl12:
                // 2 sources

            } while (var1_1 != -1);
        }
        if (var1_1 == -1) {
            throw this.createException("eof");
        }
        this.inputBuffer.next();
        this.cdataEndRead = true;
        this.type = 16;
        return 16;
    }

    protected int nextInXMLDecl() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 118: {
                return this.readIdentifier("ersion", 20, -1);
            }
            case 101: {
                return this.readIdentifier("ncoding", 21, -1);
            }
            case 115: {
                return this.readIdentifier("tandalone", 22, -1);
            }
            case 61: {
                this.inputBuffer.next();
                this.type = 12;
                return 12;
            }
            case 63: {
                n = this.inputBuffer.next();
                if (n != 62) {
                    throw this.createException("pi.end");
                }
                n = this.inputBuffer.next();
                this.context = 11;
                this.type = 6;
                return 6;
            }
            case 34: {
                this.stringDelimiter = (char)34;
                return this.readString();
            }
            case 39: {
                this.stringDelimiter = (char)39;
                return this.readString();
            }
        }
        throw this.createException("character");
    }

    protected int nextInDoctype() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 62: {
                n = this.inputBuffer.next();
                this.context = 11;
                this.type = 10;
                return 10;
            }
            case 83: {
                return this.readIdentifier("YSTEM", 24, 11);
            }
            case 80: {
                return this.readIdentifier("UBLIC", 25, 11);
            }
            case 34: {
                this.stringDelimiter = (char)34;
                return this.readString();
            }
            case 39: {
                this.stringDelimiter = (char)39;
                return this.readString();
            }
            case 91: {
                this.inputBuffer.next();
                this.context = 1;
                this.inDTD = true;
                this.type = 26;
                return 26;
            }
        }
        return this.readName(11);
    }

    protected int nextInDTDDeclarations() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLSpace((char)n)) {
                }
                this.type = 1;
                return 1;
            }
            case 93: {
                this.inputBuffer.next();
                this.context = 14;
                this.inDTD = false;
                this.type = 27;
                return 27;
            }
            case 37: {
                return this.readPEReference();
            }
            case 60: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 63: {
                        this.context = 12;
                        return this.readPIStart();
                    }
                    case 33: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 45: {
                                return this.readComment();
                            }
                            case 69: {
                                n = this.inputBuffer.next();
                                switch (n) {
                                    case 76: {
                                        this.context = 6;
                                        return this.readIdentifier("EMENT", 29, -1);
                                    }
                                    case 78: {
                                        this.context = 7;
                                        return this.readIdentifier("TITY", 31, -1);
                                    }
                                }
                                throw this.createException("character");
                            }
                            case 65: {
                                this.context = 9;
                                return this.readIdentifier("TTLIST", 30, -1);
                            }
                            case 78: {
                                this.context = 8;
                                return this.readIdentifier("OTATION", 32, -1);
                            }
                        }
                        throw this.createException("character");
                    }
                }
                throw this.createException("character");
            }
        }
        throw this.createException("character");
    }
}

