/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.ConcreteGVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.gvt.renderer.StaticRendererFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class ImageTranscoder
extends XMLAbstractTranscoder {
    protected UserAgent userAgent = new ImageTranscoderUserAgent();
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey(0);
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey(1);
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey(0);
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey(0);
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey(0);
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey(1);
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM = new FloatKey(0);

    protected ImageTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, SVGDOMImplementation.getDOMImplementation());
    }

    protected void transcode(Document document, TranscoderOutput transcoderOutput) throws TranscoderException {
        float f;
        float f2;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage("notsvg", null));
        }
        SVGDocument sVGDocument = (SVGDocument)document;
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        String string = (String)this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        DefaultSVGContext defaultSVGContext = new DefaultSVGContext();
        defaultSVGContext.setPixelToMM(this.userAgent.getPixelToMM());
        ((SVGOMDocument)document).setSVGContext(defaultSVGContext);
        float f3 = (int)sVGSVGElement.getWidth().getBaseVal().getValue();
        float f4 = (int)sVGSVGElement.getHeight().getBaseVal().getValue();
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f5 > 0.0f && f6 > 0.0f) {
            f2 = f5;
            f = f6;
        } else if (f6 > 0.0f) {
            f2 = f3 * f6 / f4;
            f = f6;
        } else if (f5 > 0.0f) {
            f2 = f5;
            f = f4 * f5 / f3;
        } else {
            f2 = f3;
            f = f4;
        }
        AffineTransform affineTransform = SVGUtilities.getPreserveAspectRatioTransform(sVGSVGElement, f2, f);
        if (affineTransform.isIdentity() && (f2 != f3 || f != f4)) {
            float f7 = Math.max(f3, f4);
            float f8 = Math.max(f2, f);
            float f9 = f8 / f7;
            affineTransform = AffineTransform.getScaleInstance(f9, f9);
        }
        if (this.hints.containsKey(KEY_AOI)) {
            Rectangle2D rectangle2D = (Rectangle2D)this.hints.get(KEY_AOI);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            AffineTransform affineTransform2 = new AffineTransform();
            double d = (double)f2 / rectangle2D.getWidth();
            double d2 = (double)f / rectangle2D.getHeight();
            affineTransform2.scale(d, d2);
            double d3 = -rectangle2D.getX();
            double d4 = -rectangle2D.getY();
            affineTransform2.translate(d3, d4);
            affineTransform.preConcatenate(affineTransform2);
        }
        int n = (int)f2;
        int n2 = (int)f;
        BufferedImage bufferedImage = this.createImage(n, n2);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
            Paint paint = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.setComposite(AlphaComposite.SrcOver);
        StaticRenderer staticRenderer = new StaticRenderer(bufferedImage);
        ConcreteGVTBuilder concreteGVTBuilder = new ConcreteGVTBuilder();
        GraphicsNodeRenderContext graphicsNodeRenderContext = new StaticRendererFactory().getRenderContext();
        BridgeContext bridgeContext = new BridgeContext(this.userAgent, graphicsNodeRenderContext);
        GraphicsNode graphicsNode = concreteGVTBuilder.build(bridgeContext, sVGDocument);
        staticRenderer.setTransform(affineTransform);
        staticRenderer.setTree(graphicsNode);
        try {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f2, f);
            staticRenderer.repaint(affineTransform.createInverse().createTransformedShape(float_));
            this.writeImage(bufferedImage, transcoderOutput);
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;

    private static class Rectangle2DKey
    extends TranscodingHints.Key {
        public Rectangle2DKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof Rectangle2D;
        }
    }

    private static class PaintKey
    extends TranscodingHints.Key {
        public PaintKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof Paint;
        }
    }

    private static class LengthKey
    extends TranscodingHints.Key {
        public LengthKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof Float && ((Float)object).floatValue() > 0.0f;
        }
    }

    private static class FloatKey
    extends TranscodingHints.Key {
        public FloatKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof Float;
        }
    }

    private static class StringKey
    extends TranscodingHints.Key {
        public StringKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof String;
        }
    }

    protected class ImageTranscoderUserAgent
    implements UserAgent {
        protected ImageTranscoderUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String string) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                ImageTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public float getPixelToMM() {
            if (ImageTranscoder.this.hints.containsKey(KEY_PIXEL_TO_MM)) {
                return ((Float)ImageTranscoder.this.hints.get(KEY_PIXEL_TO_MM)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (ImageTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)ImageTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            return (String)ImageTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            return (String)ImageTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void setSVGCursor(Cursor cursor) {
        }

        public void runThread(Thread thread) {
        }

        public AffineTransform getTransform() {
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point();
        }
    }
}

