/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.AffineTransform;
import org.apache.batik.svggen.SVGTransform;
import org.apache.batik.svggen.TransformType;

public class TransformStackElement
implements Cloneable {
    private TransformType type;
    private double[] transformParameters;

    private TransformStackElement(TransformType transformType, double[] dArray) {
        this.type = transformType;
        this.transformParameters = dArray;
    }

    public Object clone() {
        double[] dArray = new double[this.transformParameters.length];
        System.arraycopy(this.transformParameters, 0, dArray, 0, dArray.length);
        return new TransformStackElement(this.type, dArray);
    }

    public String toString() {
        return SVGTransform.convertTransform(this);
    }

    public static TransformStackElement createTranslateElement(double d, double d2) {
        return new TransformStackElement(TransformType.TRANSLATE, new double[]{d, d2});
    }

    public static TransformStackElement createRotateElement(double d) {
        return new TransformStackElement(TransformType.ROTATE, new double[]{d});
    }

    public static TransformStackElement createScaleElement(double d, double d2) {
        return new TransformStackElement(TransformType.SCALE, new double[]{d, d2});
    }

    public static TransformStackElement createShearElement(double d, double d2) {
        return new TransformStackElement(TransformType.SHEAR, new double[]{d, d2});
    }

    public static TransformStackElement createGeneralTransformElement(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new TransformStackElement(TransformType.GENERAL, dArray);
    }

    public double[] getTransformParameters() {
        return this.transformParameters;
    }

    public TransformType getType() {
        return this.type;
    }

    public boolean concatenate(TransformStackElement transformStackElement) {
        boolean bl = false;
        if (this.type.toInt() == transformStackElement.type.toInt()) {
            bl = true;
            switch (this.type.toInt()) {
                case 0: {
                    this.transformParameters[0] = this.transformParameters[0] + transformStackElement.transformParameters[0];
                    this.transformParameters[1] = this.transformParameters[1] + transformStackElement.transformParameters[1];
                    break;
                }
                case 1: {
                    this.transformParameters[0] = this.transformParameters[0] + transformStackElement.transformParameters[0];
                    break;
                }
                case 2: {
                    this.transformParameters[0] = this.transformParameters[0] * transformStackElement.transformParameters[0];
                    this.transformParameters[1] = this.transformParameters[1] * transformStackElement.transformParameters[1];
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }
}

