/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGCustomBufferedImageOp
extends AbstractSVGFilterConverter {
    public static final String ERROR_EXTENSION_HANDLER_NULL = "extensionHandler should not be null";
    private ExtensionHandler extensionHandler;

    public SVGCustomBufferedImageOp(Document document, ExtensionHandler extensionHandler) {
        super(document);
        if (extensionHandler == null) {
            throw new IllegalArgumentException(ERROR_EXTENSION_HANDLER_NULL);
        }
        this.extensionHandler = extensionHandler;
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(bufferedImageOp);
        if (sVGFilterDescriptor == null) {
            sVGFilterDescriptor = this.extensionHandler.handleFilter(bufferedImageOp, rectangle, this.domFactory);
            if (sVGFilterDescriptor != null) {
                Element element = sVGFilterDescriptor.getDef();
                if (element != null) {
                    this.defSet.add(element);
                }
                this.descMap.put(bufferedImageOp, sVGFilterDescriptor);
            } else {
                System.err.println("SVGCustomBufferedImageOp:: ExtensionHandler could not convert filter");
            }
        }
        return sVGFilterDescriptor;
    }
}

