/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.NullOp;
import org.apache.batik.svggen.SVGConvolveOp;
import org.apache.batik.svggen.SVGCustomBufferedImageOp;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGLookupOp;
import org.apache.batik.svggen.SVGRescaleOp;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGBufferedImageOp
extends AbstractSVGFilterConverter {
    private SVGLookupOp svgLookupOp;
    private SVGRescaleOp svgRescaleOp;
    private SVGConvolveOp svgConvolveOp;
    private SVGCustomBufferedImageOp svgCustomBufferedImageOp;

    public SVGBufferedImageOp(Document document, ExtensionHandler extensionHandler) {
        super(document);
        this.svgLookupOp = new SVGLookupOp(document);
        this.svgRescaleOp = new SVGRescaleOp(document);
        this.svgConvolveOp = new SVGConvolveOp(document);
        this.svgCustomBufferedImageOp = new SVGCustomBufferedImageOp(document, extensionHandler);
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.svgCustomBufferedImageOp = new SVGCustomBufferedImageOp(this.domFactory, extensionHandler);
    }

    public Set getDefinitionSet() {
        HashSet hashSet = new HashSet(this.svgLookupOp.getDefinitionSet());
        hashSet.addAll(this.svgRescaleOp.getDefinitionSet());
        hashSet.addAll(this.svgConvolveOp.getDefinitionSet());
        hashSet.addAll(this.svgCustomBufferedImageOp.getDefinitionSet());
        return hashSet;
    }

    public SVGLookupOp getLookupOpConverter() {
        return this.svgLookupOp;
    }

    public SVGRescaleOp getRescaleOpConverter() {
        return this.svgRescaleOp;
    }

    public SVGConvolveOp getConvolveOpConverter() {
        return this.svgConvolveOp;
    }

    public SVGCustomBufferedImageOp getCustomBufferedImageOpConverter() {
        return this.svgCustomBufferedImageOp;
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        SVGFilterDescriptor sVGFilterDescriptor = this.svgCustomBufferedImageOp.toSVG(bufferedImageOp, rectangle);
        if (sVGFilterDescriptor == null) {
            if (bufferedImageOp instanceof LookupOp) {
                sVGFilterDescriptor = this.svgLookupOp.toSVG((LookupOp)bufferedImageOp, rectangle);
            } else if (bufferedImageOp instanceof RescaleOp) {
                sVGFilterDescriptor = this.svgRescaleOp.toSVG((RescaleOp)bufferedImageOp, rectangle);
            } else if (bufferedImageOp instanceof ConvolveOp) {
                sVGFilterDescriptor = this.svgConvolveOp.toSVG((ConvolveOp)bufferedImageOp, rectangle);
            }
        }
        return sVGFilterDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        Object object;
        byte[] byArray = new byte[256];
        int n = 0;
        while (n <= 255) {
            byArray[n] = (byte)(0xFF & 255 - n);
            ++n;
        }
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f};
        Kernel kernel = new Kernel(3, 3, fArray);
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{new LookupOp(new ByteLookupTable(0, byArray), null), new RescaleOp(4.0f, 0.0f, null), new ConvolveOp(kernel), new NullOp()};
        Document document = TestUtil.getDocumentPrototype();
        SVGBufferedImageOp sVGBufferedImageOp = new SVGBufferedImageOp(document, new DefaultExtensionHandler());
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n2 = 0;
        while (n2 < bufferedImageOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGBufferedImageOp.toSVG(bufferedImageOpArray[n2], null);
            if (sVGFilterDescriptor != null) {
                object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
                element4.appendChild((Node)object);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < bufferedImageOpArray.length) {
            object = sVGBufferedImageOp.toSVG(bufferedImageOpArray[n3], null);
            if (object != null) {
                element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
                element5.appendChild(element);
            }
            ++n3;
        }
        object = sVGBufferedImageOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        TestUtil.trace(element2, System.out);
    }
}

